/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4.CreateTenantRequest;
import com.google.cloud.talent.v4.DeleteTenantRequest;
import com.google.cloud.talent.v4.GetTenantRequest;
import com.google.cloud.talent.v4.ListTenantsRequest;
import com.google.cloud.talent.v4.ListTenantsResponse;
import com.google.cloud.talent.v4.Tenant;
import com.google.cloud.talent.v4.TenantServiceClient;
import com.google.cloud.talent.v4.UpdateTenantRequest;
import com.google.cloud.talent.v4.stub.GrpcTenantServiceStub;
import com.google.cloud.talent.v4.stub.HttpJsonTenantServiceStub;
import com.google.cloud.talent.v4.stub.TenantServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TenantServiceStubSettings
extends StubSettings<TenantServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/jobs").build();
    private final UnaryCallSettings<CreateTenantRequest, Tenant> createTenantSettings;
    private final UnaryCallSettings<GetTenantRequest, Tenant> getTenantSettings;
    private final UnaryCallSettings<UpdateTenantRequest, Tenant> updateTenantSettings;
    private final UnaryCallSettings<DeleteTenantRequest, Empty> deleteTenantSettings;
    private final PagedCallSettings<ListTenantsRequest, ListTenantsResponse, TenantServiceClient.ListTenantsPagedResponse> listTenantsSettings;
    private static final PagedListDescriptor<ListTenantsRequest, ListTenantsResponse, Tenant> LIST_TENANTS_PAGE_STR_DESC = new PagedListDescriptor<ListTenantsRequest, ListTenantsResponse, Tenant>(){

        public String emptyToken() {
            return "";
        }

        public ListTenantsRequest injectToken(ListTenantsRequest payload, String token) {
            return ListTenantsRequest.newBuilder((ListTenantsRequest)payload).setPageToken(token).build();
        }

        public ListTenantsRequest injectPageSize(ListTenantsRequest payload, int pageSize) {
            return ListTenantsRequest.newBuilder((ListTenantsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTenantsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTenantsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Tenant> extractResources(ListTenantsResponse payload) {
            return payload.getTenantsList() == null ? ImmutableList.of() : payload.getTenantsList();
        }
    };
    private static final PagedListResponseFactory<ListTenantsRequest, ListTenantsResponse, TenantServiceClient.ListTenantsPagedResponse> LIST_TENANTS_PAGE_STR_FACT = new PagedListResponseFactory<ListTenantsRequest, ListTenantsResponse, TenantServiceClient.ListTenantsPagedResponse>(){

        public ApiFuture<TenantServiceClient.ListTenantsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTenantsRequest, ListTenantsResponse> callable, ListTenantsRequest request, ApiCallContext context, ApiFuture<ListTenantsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TENANTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TenantServiceClient.ListTenantsPagedResponse.createAsync((PageContext<ListTenantsRequest, ListTenantsResponse, Tenant>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateTenantRequest, Tenant> createTenantSettings() {
        return this.createTenantSettings;
    }

    public UnaryCallSettings<GetTenantRequest, Tenant> getTenantSettings() {
        return this.getTenantSettings;
    }

    public UnaryCallSettings<UpdateTenantRequest, Tenant> updateTenantSettings() {
        return this.updateTenantSettings;
    }

    public UnaryCallSettings<DeleteTenantRequest, Empty> deleteTenantSettings() {
        return this.deleteTenantSettings;
    }

    public PagedCallSettings<ListTenantsRequest, ListTenantsResponse, TenantServiceClient.ListTenantsPagedResponse> listTenantsSettings() {
        return this.listTenantsSettings;
    }

    public TenantServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTenantServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTenantServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "jobs";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "jobs.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "jobs.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TenantServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TenantServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TenantServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return TenantServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TenantServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createTenantSettings = settingsBuilder.createTenantSettings().build();
        this.getTenantSettings = settingsBuilder.getTenantSettings().build();
        this.updateTenantSettings = settingsBuilder.updateTenantSettings().build();
        this.deleteTenantSettings = settingsBuilder.deleteTenantSettings().build();
        this.listTenantsSettings = settingsBuilder.listTenantsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TenantServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateTenantRequest, Tenant> createTenantSettings;
        private final UnaryCallSettings.Builder<GetTenantRequest, Tenant> getTenantSettings;
        private final UnaryCallSettings.Builder<UpdateTenantRequest, Tenant> updateTenantSettings;
        private final UnaryCallSettings.Builder<DeleteTenantRequest, Empty> deleteTenantSettings;
        private final PagedCallSettings.Builder<ListTenantsRequest, ListTenantsResponse, TenantServiceClient.ListTenantsPagedResponse> listTenantsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createTenantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTenantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTenantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTenantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTenantsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TENANTS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTenantSettings, this.getTenantSettings, this.updateTenantSettings, this.deleteTenantSettings, this.listTenantsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TenantServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createTenantSettings = settings.createTenantSettings.toBuilder();
            this.getTenantSettings = settings.getTenantSettings.toBuilder();
            this.updateTenantSettings = settings.updateTenantSettings.toBuilder();
            this.deleteTenantSettings = settings.deleteTenantSettings.toBuilder();
            this.listTenantsSettings = settings.listTenantsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createTenantSettings, this.getTenantSettings, this.updateTenantSettings, this.deleteTenantSettings, this.listTenantsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TenantServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TenantServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TenantServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TenantServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)TenantServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)TenantServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TenantServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(TenantServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createTenantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.getTenantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateTenantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.deleteTenantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTenantsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateTenantRequest, Tenant> createTenantSettings() {
            return this.createTenantSettings;
        }

        public UnaryCallSettings.Builder<GetTenantRequest, Tenant> getTenantSettings() {
            return this.getTenantSettings;
        }

        public UnaryCallSettings.Builder<UpdateTenantRequest, Tenant> updateTenantSettings() {
            return this.updateTenantSettings;
        }

        public UnaryCallSettings.Builder<DeleteTenantRequest, Empty> deleteTenantSettings() {
            return this.deleteTenantSettings;
        }

        public PagedCallSettings.Builder<ListTenantsRequest, ListTenantsResponse, TenantServiceClient.ListTenantsPagedResponse> listTenantsSettings() {
            return this.listTenantsSettings;
        }

        public TenantServiceStubSettings build() throws IOException {
            return new TenantServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_4_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"no_retry_4_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

