/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.talent.v4beta1.CreateProfileRequest;
import com.google.cloud.talent.v4beta1.DeleteProfileRequest;
import com.google.cloud.talent.v4beta1.GetProfileRequest;
import com.google.cloud.talent.v4beta1.HistogramQueryResult;
import com.google.cloud.talent.v4beta1.ListProfilesRequest;
import com.google.cloud.talent.v4beta1.ListProfilesResponse;
import com.google.cloud.talent.v4beta1.Profile;
import com.google.cloud.talent.v4beta1.ProfileServiceClient;
import com.google.cloud.talent.v4beta1.SearchProfilesRequest;
import com.google.cloud.talent.v4beta1.SearchProfilesResponse;
import com.google.cloud.talent.v4beta1.UpdateProfileRequest;
import com.google.cloud.talent.v4beta1.stub.GrpcProfileServiceStub;
import com.google.cloud.talent.v4beta1.stub.ProfileServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ProfileServiceStubSettings
extends StubSettings<ProfileServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/jobs").build();
    private final PagedCallSettings<ListProfilesRequest, ListProfilesResponse, ProfileServiceClient.ListProfilesPagedResponse> listProfilesSettings;
    private final UnaryCallSettings<CreateProfileRequest, Profile> createProfileSettings;
    private final UnaryCallSettings<GetProfileRequest, Profile> getProfileSettings;
    private final UnaryCallSettings<UpdateProfileRequest, Profile> updateProfileSettings;
    private final UnaryCallSettings<DeleteProfileRequest, Empty> deleteProfileSettings;
    private final PagedCallSettings<SearchProfilesRequest, SearchProfilesResponse, ProfileServiceClient.SearchProfilesPagedResponse> searchProfilesSettings;
    private static final PagedListDescriptor<ListProfilesRequest, ListProfilesResponse, Profile> LIST_PROFILES_PAGE_STR_DESC = new PagedListDescriptor<ListProfilesRequest, ListProfilesResponse, Profile>(){

        public String emptyToken() {
            return "";
        }

        public ListProfilesRequest injectToken(ListProfilesRequest payload, String token) {
            return ListProfilesRequest.newBuilder((ListProfilesRequest)payload).setPageToken(token).build();
        }

        public ListProfilesRequest injectPageSize(ListProfilesRequest payload, int pageSize) {
            return ListProfilesRequest.newBuilder((ListProfilesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProfilesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProfilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Profile> extractResources(ListProfilesResponse payload) {
            return payload.getProfilesList() == null ? ImmutableList.of() : payload.getProfilesList();
        }
    };
    private static final PagedListDescriptor<SearchProfilesRequest, SearchProfilesResponse, HistogramQueryResult> SEARCH_PROFILES_PAGE_STR_DESC = new PagedListDescriptor<SearchProfilesRequest, SearchProfilesResponse, HistogramQueryResult>(){

        public String emptyToken() {
            return "";
        }

        public SearchProfilesRequest injectToken(SearchProfilesRequest payload, String token) {
            return SearchProfilesRequest.newBuilder((SearchProfilesRequest)payload).setPageToken(token).build();
        }

        public SearchProfilesRequest injectPageSize(SearchProfilesRequest payload, int pageSize) {
            return SearchProfilesRequest.newBuilder((SearchProfilesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(SearchProfilesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(SearchProfilesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<HistogramQueryResult> extractResources(SearchProfilesResponse payload) {
            return payload.getHistogramQueryResultsList() == null ? ImmutableList.of() : payload.getHistogramQueryResultsList();
        }
    };
    private static final PagedListResponseFactory<ListProfilesRequest, ListProfilesResponse, ProfileServiceClient.ListProfilesPagedResponse> LIST_PROFILES_PAGE_STR_FACT = new PagedListResponseFactory<ListProfilesRequest, ListProfilesResponse, ProfileServiceClient.ListProfilesPagedResponse>(){

        public ApiFuture<ProfileServiceClient.ListProfilesPagedResponse> getFuturePagedResponse(UnaryCallable<ListProfilesRequest, ListProfilesResponse> callable, ListProfilesRequest request, ApiCallContext context, ApiFuture<ListProfilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROFILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ProfileServiceClient.ListProfilesPagedResponse.createAsync((PageContext<ListProfilesRequest, ListProfilesResponse, Profile>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<SearchProfilesRequest, SearchProfilesResponse, ProfileServiceClient.SearchProfilesPagedResponse> SEARCH_PROFILES_PAGE_STR_FACT = new PagedListResponseFactory<SearchProfilesRequest, SearchProfilesResponse, ProfileServiceClient.SearchProfilesPagedResponse>(){

        public ApiFuture<ProfileServiceClient.SearchProfilesPagedResponse> getFuturePagedResponse(UnaryCallable<SearchProfilesRequest, SearchProfilesResponse> callable, SearchProfilesRequest request, ApiCallContext context, ApiFuture<SearchProfilesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)SEARCH_PROFILES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ProfileServiceClient.SearchProfilesPagedResponse.createAsync((PageContext<SearchProfilesRequest, SearchProfilesResponse, HistogramQueryResult>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListProfilesRequest, ListProfilesResponse, ProfileServiceClient.ListProfilesPagedResponse> listProfilesSettings() {
        return this.listProfilesSettings;
    }

    public UnaryCallSettings<CreateProfileRequest, Profile> createProfileSettings() {
        return this.createProfileSettings;
    }

    public UnaryCallSettings<GetProfileRequest, Profile> getProfileSettings() {
        return this.getProfileSettings;
    }

    public UnaryCallSettings<UpdateProfileRequest, Profile> updateProfileSettings() {
        return this.updateProfileSettings;
    }

    public UnaryCallSettings<DeleteProfileRequest, Empty> deleteProfileSettings() {
        return this.deleteProfileSettings;
    }

    public PagedCallSettings<SearchProfilesRequest, SearchProfilesResponse, ProfileServiceClient.SearchProfilesPagedResponse> searchProfilesSettings() {
        return this.searchProfilesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProfileServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcProfileServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "jobs.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "jobs.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ProfileServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProfileServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ProfileServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listProfilesSettings = settingsBuilder.listProfilesSettings().build();
        this.createProfileSettings = settingsBuilder.createProfileSettings().build();
        this.getProfileSettings = settingsBuilder.getProfileSettings().build();
        this.updateProfileSettings = settingsBuilder.updateProfileSettings().build();
        this.deleteProfileSettings = settingsBuilder.deleteProfileSettings().build();
        this.searchProfilesSettings = settingsBuilder.searchProfilesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ProfileServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListProfilesRequest, ListProfilesResponse, ProfileServiceClient.ListProfilesPagedResponse> listProfilesSettings;
        private final UnaryCallSettings.Builder<CreateProfileRequest, Profile> createProfileSettings;
        private final UnaryCallSettings.Builder<GetProfileRequest, Profile> getProfileSettings;
        private final UnaryCallSettings.Builder<UpdateProfileRequest, Profile> updateProfileSettings;
        private final UnaryCallSettings.Builder<DeleteProfileRequest, Empty> deleteProfileSettings;
        private final PagedCallSettings.Builder<SearchProfilesRequest, SearchProfilesResponse, ProfileServiceClient.SearchProfilesPagedResponse> searchProfilesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listProfilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROFILES_PAGE_STR_FACT);
            this.createProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProfileSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.searchProfilesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)SEARCH_PROFILES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listProfilesSettings, this.createProfileSettings, this.getProfileSettings, this.updateProfileSettings, this.deleteProfileSettings, this.searchProfilesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ProfileServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listProfilesSettings = settings.listProfilesSettings.toBuilder();
            this.createProfileSettings = settings.createProfileSettings.toBuilder();
            this.getProfileSettings = settings.getProfileSettings.toBuilder();
            this.updateProfileSettings = settings.updateProfileSettings.toBuilder();
            this.deleteProfileSettings = settings.deleteProfileSettings.toBuilder();
            this.searchProfilesSettings = settings.searchProfilesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listProfilesSettings, this.createProfileSettings, this.getProfileSettings, this.updateProfileSettings, this.deleteProfileSettings, this.searchProfilesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ProfileServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ProfileServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProfileServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ProfileServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ProfileServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listProfilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.createProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.getProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.updateProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            builder.deleteProfileSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_6_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_6_params"));
            builder.searchProfilesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_4_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListProfilesRequest, ListProfilesResponse, ProfileServiceClient.ListProfilesPagedResponse> listProfilesSettings() {
            return this.listProfilesSettings;
        }

        public UnaryCallSettings.Builder<CreateProfileRequest, Profile> createProfileSettings() {
            return this.createProfileSettings;
        }

        public UnaryCallSettings.Builder<GetProfileRequest, Profile> getProfileSettings() {
            return this.getProfileSettings;
        }

        public UnaryCallSettings.Builder<UpdateProfileRequest, Profile> updateProfileSettings() {
            return this.updateProfileSettings;
        }

        public UnaryCallSettings.Builder<DeleteProfileRequest, Empty> deleteProfileSettings() {
            return this.deleteProfileSettings;
        }

        public PagedCallSettings.Builder<SearchProfilesRequest, SearchProfilesResponse, ProfileServiceClient.SearchProfilesPagedResponse> searchProfilesSettings() {
            return this.searchProfilesSettings;
        }

        public ProfileServiceStubSettings build() throws IOException {
            return new ProfileServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_6_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_4_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_6_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"no_retry_4_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

