/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storageinsights.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.storageinsights.v1.CreateReportConfigRequest;
import com.google.cloud.storageinsights.v1.DeleteReportConfigRequest;
import com.google.cloud.storageinsights.v1.GetReportConfigRequest;
import com.google.cloud.storageinsights.v1.GetReportDetailRequest;
import com.google.cloud.storageinsights.v1.ListReportConfigsRequest;
import com.google.cloud.storageinsights.v1.ListReportConfigsResponse;
import com.google.cloud.storageinsights.v1.ListReportDetailsRequest;
import com.google.cloud.storageinsights.v1.ListReportDetailsResponse;
import com.google.cloud.storageinsights.v1.ReportConfig;
import com.google.cloud.storageinsights.v1.ReportDetail;
import com.google.cloud.storageinsights.v1.StorageInsightsClient;
import com.google.cloud.storageinsights.v1.UpdateReportConfigRequest;
import com.google.cloud.storageinsights.v1.stub.HttpJsonStorageInsightsCallableFactory;
import com.google.cloud.storageinsights.v1.stub.StorageInsightsStub;
import com.google.cloud.storageinsights.v1.stub.StorageInsightsStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonStorageInsightsStub
extends StorageInsightsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<ListReportConfigsRequest, ListReportConfigsResponse> listReportConfigsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.storageinsights.v1.StorageInsights/ListReportConfigs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/reportConfigs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListReportConfigsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetReportConfigRequest, ReportConfig> getReportConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.storageinsights.v1.StorageInsights/GetReportConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/reportConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReportConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateReportConfigRequest, ReportConfig> createReportConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.storageinsights.v1.StorageInsights/CreateReportConfig").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/reportConfigs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("reportConfig", (Message)request.getReportConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReportConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateReportConfigRequest, ReportConfig> updateReportConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.storageinsights.v1.StorageInsights/UpdateReportConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{reportConfig.name=projects/*/locations/*/reportConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "reportConfig.name", (Object)request.getReportConfig().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("reportConfig", (Message)request.getReportConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReportConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteReportConfigRequest, Empty> deleteReportConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.storageinsights.v1.StorageInsights/DeleteReportConfig").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/reportConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListReportDetailsRequest, ListReportDetailsResponse> listReportDetailsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.storageinsights.v1.StorageInsights/ListReportDetails").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/reportConfigs/*}/reportDetails", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListReportDetailsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetReportDetailRequest, ReportDetail> getReportDetailMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.storageinsights.v1.StorageInsights/GetReportDetail").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/reportConfigs/*/reportDetails/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReportDetail.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListReportConfigsRequest, ListReportConfigsResponse> listReportConfigsCallable;
    private final UnaryCallable<ListReportConfigsRequest, StorageInsightsClient.ListReportConfigsPagedResponse> listReportConfigsPagedCallable;
    private final UnaryCallable<GetReportConfigRequest, ReportConfig> getReportConfigCallable;
    private final UnaryCallable<CreateReportConfigRequest, ReportConfig> createReportConfigCallable;
    private final UnaryCallable<UpdateReportConfigRequest, ReportConfig> updateReportConfigCallable;
    private final UnaryCallable<DeleteReportConfigRequest, Empty> deleteReportConfigCallable;
    private final UnaryCallable<ListReportDetailsRequest, ListReportDetailsResponse> listReportDetailsCallable;
    private final UnaryCallable<ListReportDetailsRequest, StorageInsightsClient.ListReportDetailsPagedResponse> listReportDetailsPagedCallable;
    private final UnaryCallable<GetReportDetailRequest, ReportDetail> getReportDetailCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, StorageInsightsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonStorageInsightsStub create(StorageInsightsStubSettings settings) throws IOException {
        return new HttpJsonStorageInsightsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonStorageInsightsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonStorageInsightsStub(StorageInsightsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonStorageInsightsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonStorageInsightsStub(StorageInsightsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonStorageInsightsStub(StorageInsightsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonStorageInsightsCallableFactory());
    }

    protected HttpJsonStorageInsightsStub(StorageInsightsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings listReportConfigsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listReportConfigsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getReportConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getReportConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createReportConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createReportConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateReportConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateReportConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("report_config.name", String.valueOf(request.getReportConfig().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteReportConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteReportConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listReportDetailsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listReportDetailsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getReportDetailTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getReportDetailMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listReportConfigsCallable = callableFactory.createUnaryCallable(listReportConfigsTransportSettings, settings.listReportConfigsSettings(), clientContext);
        this.listReportConfigsPagedCallable = callableFactory.createPagedCallable(listReportConfigsTransportSettings, settings.listReportConfigsSettings(), clientContext);
        this.getReportConfigCallable = callableFactory.createUnaryCallable(getReportConfigTransportSettings, settings.getReportConfigSettings(), clientContext);
        this.createReportConfigCallable = callableFactory.createUnaryCallable(createReportConfigTransportSettings, settings.createReportConfigSettings(), clientContext);
        this.updateReportConfigCallable = callableFactory.createUnaryCallable(updateReportConfigTransportSettings, settings.updateReportConfigSettings(), clientContext);
        this.deleteReportConfigCallable = callableFactory.createUnaryCallable(deleteReportConfigTransportSettings, settings.deleteReportConfigSettings(), clientContext);
        this.listReportDetailsCallable = callableFactory.createUnaryCallable(listReportDetailsTransportSettings, settings.listReportDetailsSettings(), clientContext);
        this.listReportDetailsPagedCallable = callableFactory.createPagedCallable(listReportDetailsTransportSettings, settings.listReportDetailsSettings(), clientContext);
        this.getReportDetailCallable = callableFactory.createUnaryCallable(getReportDetailTransportSettings, settings.getReportDetailSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listReportConfigsMethodDescriptor);
        methodDescriptors.add(getReportConfigMethodDescriptor);
        methodDescriptors.add(createReportConfigMethodDescriptor);
        methodDescriptors.add(updateReportConfigMethodDescriptor);
        methodDescriptors.add(deleteReportConfigMethodDescriptor);
        methodDescriptors.add(listReportDetailsMethodDescriptor);
        methodDescriptors.add(getReportDetailMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<ListReportConfigsRequest, ListReportConfigsResponse> listReportConfigsCallable() {
        return this.listReportConfigsCallable;
    }

    @Override
    public UnaryCallable<ListReportConfigsRequest, StorageInsightsClient.ListReportConfigsPagedResponse> listReportConfigsPagedCallable() {
        return this.listReportConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<GetReportConfigRequest, ReportConfig> getReportConfigCallable() {
        return this.getReportConfigCallable;
    }

    @Override
    public UnaryCallable<CreateReportConfigRequest, ReportConfig> createReportConfigCallable() {
        return this.createReportConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateReportConfigRequest, ReportConfig> updateReportConfigCallable() {
        return this.updateReportConfigCallable;
    }

    @Override
    public UnaryCallable<DeleteReportConfigRequest, Empty> deleteReportConfigCallable() {
        return this.deleteReportConfigCallable;
    }

    @Override
    public UnaryCallable<ListReportDetailsRequest, ListReportDetailsResponse> listReportDetailsCallable() {
        return this.listReportDetailsCallable;
    }

    @Override
    public UnaryCallable<ListReportDetailsRequest, StorageInsightsClient.ListReportDetailsPagedResponse> listReportDetailsPagedCallable() {
        return this.listReportDetailsPagedCallable;
    }

    @Override
    public UnaryCallable<GetReportDetailRequest, ReportDetail> getReportDetailCallable() {
        return this.getReportDetailCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, StorageInsightsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

