/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.UriTemplate;
import com.google.api.client.util.ObjectParser;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.services.storage.Storage;
import com.google.cloud.storage.ChecksumResponseParser;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.Utils;
import com.google.cloud.storage.XmlObjectParser;
import com.google.cloud.storage.multipartupload.model.AbortMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.AbortMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.CompleteMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.CompleteMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.CreateMultipartUploadRequest;
import com.google.cloud.storage.multipartupload.model.CreateMultipartUploadResponse;
import com.google.cloud.storage.multipartupload.model.ListMultipartUploadsRequest;
import com.google.cloud.storage.multipartupload.model.ListMultipartUploadsResponse;
import com.google.cloud.storage.multipartupload.model.ListPartsRequest;
import com.google.cloud.storage.multipartupload.model.ListPartsResponse;
import com.google.cloud.storage.multipartupload.model.UploadPartRequest;
import com.google.cloud.storage.multipartupload.model.UploadPartResponse;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

final class MultipartUploadHttpRequestManager {
    private final HttpRequestFactory requestFactory;
    private final ObjectParser objectParser;
    private final HeaderProvider headerProvider;
    private final URI uri;

    MultipartUploadHttpRequestManager(HttpRequestFactory requestFactory, ObjectParser objectParser, HeaderProvider headerProvider, URI uri) {
        this.requestFactory = requestFactory;
        this.objectParser = objectParser;
        this.headerProvider = headerProvider;
        this.uri = uri;
    }

    CreateMultipartUploadResponse sendCreateMultipartUploadRequest(CreateMultipartUploadRequest request) throws IOException {
        String createUri = UriTemplate.expand((String)this.uri.toString(), (String)"{bucket}/{key}?uploads", (Object)ImmutableMap.of((Object)"bucket", (Object)request.bucket(), (Object)"key", (Object)request.key()), (boolean)false);
        HttpRequest httpRequest = this.requestFactory.buildPostRequest(new GenericUrl(createUri), (HttpContent)new ByteArrayContent(null, new byte[0]));
        httpRequest.getHeaders().putAll(this.headerProvider.getHeaders());
        this.addHeadersForCreateMultipartUpload(request, httpRequest.getHeaders());
        httpRequest.setParser(this.objectParser);
        httpRequest.setThrowExceptionOnExecuteError(true);
        return (CreateMultipartUploadResponse)httpRequest.execute().parseAs(CreateMultipartUploadResponse.class);
    }

    ListPartsResponse sendListPartsRequest(ListPartsRequest request) throws IOException {
        ImmutableMap.Builder params = ImmutableMap.builder().put((Object)"bucket", (Object)request.bucket()).put((Object)"key", (Object)request.key()).put((Object)"uploadId", (Object)request.uploadId());
        if (request.maxParts() != null) {
            params.put((Object)"max-parts", (Object)request.maxParts());
        }
        if (request.partNumberMarker() != null) {
            params.put((Object)"part-number-marker", (Object)request.partNumberMarker());
        }
        String listUri = UriTemplate.expand((String)this.uri.toString(), (String)"{bucket}/{key}{?uploadId,max-parts,part-number-marker}", (Object)params.build(), (boolean)false);
        HttpRequest httpRequest = this.requestFactory.buildGetRequest(new GenericUrl(listUri));
        httpRequest.getHeaders().putAll(this.headerProvider.getHeaders());
        if (request.userProject() != null) {
            httpRequest.getHeaders().put("x-goog-user-project", (Object)request.userProject());
        }
        httpRequest.setParser(this.objectParser);
        httpRequest.setThrowExceptionOnExecuteError(true);
        return (ListPartsResponse)httpRequest.execute().parseAs(ListPartsResponse.class);
    }

    ListMultipartUploadsResponse sendListMultipartUploadsRequest(ListMultipartUploadsRequest request) throws IOException {
        ImmutableMap.Builder params = ImmutableMap.builder().put((Object)"bucket", (Object)request.bucket());
        if (request.delimiter() != null) {
            params.put((Object)"delimiter", (Object)request.delimiter());
        }
        if (request.encodingType() != null) {
            params.put((Object)"encoding-type", (Object)request.encodingType());
        }
        if (request.keyMarker() != null) {
            params.put((Object)"key-marker", (Object)request.keyMarker());
        }
        if (request.maxUploads() != null) {
            params.put((Object)"max-uploads", (Object)request.maxUploads());
        }
        if (request.prefix() != null) {
            params.put((Object)"prefix", (Object)request.prefix());
        }
        if (request.uploadIdMarker() != null) {
            params.put((Object)"upload-id-marker", (Object)request.uploadIdMarker());
        }
        String listUri = UriTemplate.expand((String)(this.uri.toString() + "{bucket}?uploads{&delimiter,encoding-type,key-marker,max-uploads,prefix,upload-id-marker}"), (Object)params.build(), (boolean)false);
        HttpRequest httpRequest = this.requestFactory.buildGetRequest(new GenericUrl(listUri));
        httpRequest.getHeaders().putAll(this.headerProvider.getHeaders());
        if (request.userProject() != null) {
            httpRequest.getHeaders().put("x-goog-user-project", (Object)request.userProject());
        }
        httpRequest.setParser(this.objectParser);
        httpRequest.setThrowExceptionOnExecuteError(true);
        return (ListMultipartUploadsResponse)httpRequest.execute().parseAs(ListMultipartUploadsResponse.class);
    }

    AbortMultipartUploadResponse sendAbortMultipartUploadRequest(AbortMultipartUploadRequest request) throws IOException {
        String abortUri = UriTemplate.expand((String)this.uri.toString(), (String)"{bucket}/{key}{?uploadId}", (Object)ImmutableMap.of((Object)"bucket", (Object)request.bucket(), (Object)"key", (Object)request.key(), (Object)"uploadId", (Object)request.uploadId()), (boolean)false);
        HttpRequest httpRequest = this.requestFactory.buildDeleteRequest(new GenericUrl(abortUri));
        httpRequest.getHeaders().putAll(this.headerProvider.getHeaders());
        if (request.userProject() != null) {
            httpRequest.getHeaders().put("x-goog-user-project", (Object)request.userProject());
        }
        httpRequest.setParser(this.objectParser);
        httpRequest.setThrowExceptionOnExecuteError(true);
        return (AbortMultipartUploadResponse)httpRequest.execute().parseAs(AbortMultipartUploadResponse.class);
    }

    CompleteMultipartUploadResponse sendCompleteMultipartUploadRequest(CompleteMultipartUploadRequest request) throws IOException {
        String completeUri = UriTemplate.expand((String)(this.uri.toString() + "{bucket}/{key}{?uploadId}"), (Object)ImmutableMap.of((Object)"bucket", (Object)request.bucket(), (Object)"key", (Object)request.key(), (Object)"uploadId", (Object)request.uploadId()), (boolean)false);
        byte[] bytes = new XmlMapper().writeValueAsBytes((Object)request.multipartUpload());
        HttpRequest httpRequest = this.requestFactory.buildPostRequest(new GenericUrl(completeUri), (HttpContent)new ByteArrayContent("application/xml", bytes));
        httpRequest.getHeaders().putAll(this.headerProvider.getHeaders());
        if (request.userProject() != null) {
            httpRequest.getHeaders().put("x-goog-user-project", (Object)request.userProject());
        }
         @Nullable Crc32cValue.Crc32cLengthKnown crc32cValue = Hasher.defaultHasher().hash(ByteBuffer.wrap(bytes));
        this.addChecksumHeader(crc32cValue, httpRequest.getHeaders());
        httpRequest.setParser(this.objectParser);
        httpRequest.setThrowExceptionOnExecuteError(true);
        return ChecksumResponseParser.parseCompleteResponse(httpRequest.execute());
    }

    UploadPartResponse sendUploadPartRequest(UploadPartRequest request, RewindableContent rewindableContent) throws IOException {
        String uploadUri = UriTemplate.expand((String)(this.uri.toString() + "{bucket}/{key}{?partNumber,uploadId}"), (Object)ImmutableMap.of((Object)"bucket", (Object)request.bucket(), (Object)"key", (Object)request.key(), (Object)"partNumber", (Object)request.partNumber(), (Object)"uploadId", (Object)request.uploadId()), (boolean)false);
        HttpRequest httpRequest = this.requestFactory.buildPutRequest(new GenericUrl(uploadUri), (HttpContent)rewindableContent);
        httpRequest.getHeaders().putAll(this.headerProvider.getHeaders());
        if (request.userProject() != null) {
            httpRequest.getHeaders().put("x-goog-user-project", (Object)request.userProject());
        }
        if (request.crc32c() != null) {
            this.addChecksumHeader(request.crc32c(), httpRequest.getHeaders());
        } else {
            this.addChecksumHeader(rewindableContent.getCrc32c(), httpRequest.getHeaders());
        }
        httpRequest.setThrowExceptionOnExecuteError(true);
        return ChecksumResponseParser.parseUploadResponse(httpRequest.execute());
    }

    static MultipartUploadHttpRequestManager createFrom(HttpStorageOptions options) {
        Storage storage = options.getStorageRpcV1().getStorage();
        ImmutableMap.Builder stableHeaders = ImmutableMap.builder().put((Object)"User-Agent", (Object)("gcloud-java/" + options.getLibraryVersion())).put((Object)"x-goog-api-client", (Object)String.format("gl-java/%s gccl/%s %s/%s", GaxProperties.getJavaVersion(), options.getLibraryVersion(), MultipartUploadHttpRequestManager.formatName(StandardSystemProperty.OS_NAME.value()), MultipartUploadHttpRequestManager.formatSemver(StandardSystemProperty.OS_VERSION.value())));
        return new MultipartUploadHttpRequestManager(storage.getRequestFactory(), new XmlObjectParser(new XmlMapper()), options.getMergedHeaderProvider((HeaderProvider)FixedHeaderProvider.create((Map)stableHeaders.build())), URI.create(MultipartUploadHttpRequestManager.ensureTrailingSlash(options.getHost())));
    }

    private static String ensureTrailingSlash(String host) {
        return host.endsWith("/") ? host : host + "/";
    }

    private void addChecksumHeader( @Nullable Crc32cValue.Crc32cLengthKnown crc32c, HttpHeaders headers) {
        if (crc32c != null) {
            this.addChecksumHeader((String)Utils.crc32cCodec.encode(crc32c.getValue()), headers);
        }
    }

    private void addChecksumHeader(@Nullable String crc32c, HttpHeaders headers) {
        if (crc32c != null) {
            headers.put("x-goog-hash", (Object)("crc32c=" + crc32c));
        }
    }

    private void addHeadersForCreateMultipartUpload(CreateMultipartUploadRequest request, HttpHeaders headers) {
        if (request.cannedAcl() != null) {
            headers.put("x-goog-acl", (Object)request.cannedAcl().getXmlEntry());
        }
        if (request.metadata() != null) {
            for (Map.Entry<String, String> entry : request.metadata().entrySet()) {
                if (entry.getKey() == null && entry.getValue() == null) continue;
                headers.put("x-goog-meta-" + MultipartUploadHttpRequestManager.urlEncode(entry.getKey()), (Object)MultipartUploadHttpRequestManager.urlEncode(entry.getValue()));
            }
        }
        if (request.contentType() != null) {
            headers.put("Content-Type", (Object)request.contentType());
        }
        if (request.contentDisposition() != null) {
            headers.put("Content-Disposition", (Object)request.contentDisposition());
        }
        if (request.contentEncoding() != null) {
            headers.put("Content-Encoding", (Object)request.contentEncoding());
        }
        if (request.contentLanguage() != null) {
            headers.put("Content-Language", (Object)request.contentLanguage());
        }
        if (request.cacheControl() != null) {
            headers.put("Cache-Control", (Object)request.cacheControl());
        }
        if (request.storageClass() != null) {
            headers.put("x-goog-storage-class", (Object)request.storageClass().toString());
        }
        if (request.kmsKeyName() != null && !request.kmsKeyName().isEmpty()) {
            headers.put("x-goog-encryption-kms-key-name", (Object)request.kmsKeyName());
        }
        if (request.objectLockMode() != null) {
            headers.put("x-goog-object-lock-mode", (Object)request.objectLockMode().toString());
        }
        if (request.objectLockRetainUntilDate() != null) {
            headers.put("x-goog-object-lock-retain-until-date", Utils.offsetDateTimeRfc3339Codec.encode(request.objectLockRetainUntilDate()));
        }
        if (request.customTime() != null) {
            headers.put("x-goog-custom-time", Utils.offsetDateTimeRfc3339Codec.encode(request.customTime()));
        }
        if (request.userProject() != null) {
            headers.put("x-goog-user-project", (Object)request.userProject());
        }
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new StorageException(0, "Unable to load UTF-8 charset for encoding", e);
        }
    }

    private static String formatName(String name) {
        return name.toLowerCase().replaceAll("[^\\w-]", "-");
    }

    private static String formatSemver(String version) {
        return MultipartUploadHttpRequestManager.formatSemver(version, version);
    }

    private static String formatSemver(String version, String defaultValue) {
        if (version == null) {
            return null;
        }
        Matcher m = Pattern.compile("(\\d+\\.\\d+\\.\\d+).*").matcher(version);
        if (m.find()) {
            return m.group(1);
        }
        return defaultValue;
    }
}

