/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.Crc32cValue;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.HttpClientContext;
import com.google.cloud.storage.HttpContentRange;
import com.google.cloud.storage.JsonResumableSessionPutTask;
import com.google.cloud.storage.JsonResumableSessionQueryTask;
import com.google.cloud.storage.JsonResumableWrite;
import com.google.cloud.storage.ResumableOperationResult;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.RewindableContent;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.spi.v1.HttpRpcContext;
import com.google.cloud.storage.spi.v1.HttpStorageRpc;
import io.opencensus.trace.EndSpanOptions;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.Nullable;

final class JsonResumableSession {
    static final String SPAN_NAME_WRITE = String.format(Locale.US, "Sent.%s.write", HttpStorageRpc.class.getName());
    static final EndSpanOptions END_SPAN_OPTIONS = EndSpanOptions.builder().setSampleToLocalSpanStore(true).build();
    private final HttpClientContext context;
    private final Retrying.RetrierWithAlg retrier;
    private final JsonResumableWrite resumableWrite;

    JsonResumableSession(HttpClientContext context, Retrying.RetrierWithAlg retrier, JsonResumableWrite resumableWrite) {
        this.context = context;
        this.retrier = retrier;
        this.resumableWrite = resumableWrite;
    }

    ResumableOperationResult<@Nullable StorageObject> query() {
        return new JsonResumableSessionQueryTask(this.context, this.resumableWrite).call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    ResumableOperationResult<@Nullable StorageObject> put(RewindableContent content, HttpContentRange contentRange) {
        Crc32cValue<?> crc32cSoFar = this.resumableWrite.getCumulativeCrc32c();
        @Nullable Crc32cValue<?> nextCumulativeCrc32c = this.resumableWrite.getHasher().nullSafeConcat(crc32cSoFar, content.getCrc32c());
        Crc32cValue<?> finalChecksum = contentRange.isFinalizing() ? nextCumulativeCrc32c : null;
        JsonResumableSessionPutTask task = new JsonResumableSessionPutTask(this.context, this.resumableWrite, content, contentRange, finalChecksum);
        HttpRpcContext httpRpcContext = HttpRpcContext.getInstance();
        try {
            httpRpcContext.newInvocationId();
            AtomicBoolean dirty = new AtomicBoolean(false);
            @Nullable ResumableOperationResult result = (ResumableOperationResult)this.retrier.run(() -> {
                if (dirty.getAndSet(true)) {
                    ResumableOperationResult<@Nullable StorageObject> query = this.query();
                    long persistedSize = query.getPersistedSize();
                    if (contentRange.endOffsetEquals(persistedSize) || query.getObject() != null) {
                        return query;
                    }
                    task.rewindTo(persistedSize);
                }
                return task.call();
            }, Conversions.Decoder.identity());
            if (nextCumulativeCrc32c != null) {
                long persistedSize = result.getPersistedSize();
                if (contentRange.endOffsetEquals(persistedSize) || result.getObject() != null) {
                    this.resumableWrite.setCumulativeCrc32c(nextCumulativeCrc32c);
                } else if (contentRange instanceof HttpContentRange.HasRange) {
                    ByteRangeSpec range = ((HttpContentRange.HasRange)((Object)contentRange)).range();
                    content.rewindTo(0L);
                    long serverConsumedBytes = persistedSize - range.beginOffset();
                    try (HashingGatheringByteChannel hashingChannel = new HashingGatheringByteChannel(serverConsumedBytes);){
                        StorageException.wrapIOException(() -> content.writeTo(hashingChannel));
                        this.resumableWrite.setCumulativeCrc32c(this.resumableWrite.getHasher().nullSafeConcat(crc32cSoFar, hashingChannel.cumulative));
                    }
                } else {
                    throw new StorageException(0, String.format(Locale.US, "Result persistedSize (%d) did not match expected end of contentRange (%s) and contentRange does not have range to allow automatic recovery", persistedSize, contentRange));
                }
            }
            ResumableOperationResult resumableOperationResult = result;
            return resumableOperationResult;
        }
        finally {
            httpRpcContext.clearInvocationId();
        }
    }

    private static final class HashingGatheringByteChannel
    implements GatheringByteChannel {
        private final long maxBytesToConsume;
        private Crc32cValue.Crc32cLengthKnown cumulative;

        private HashingGatheringByteChannel(long maxBytesToConsume) {
            this.maxBytesToConsume = maxBytesToConsume;
            this.cumulative = Crc32cValue.zero();
        }

        @Override
        public int write(ByteBuffer src) {
            return Math.toIntExact(this.write(new ByteBuffer[]{src}, 0, 1));
        }

        @Override
        public long write(ByteBuffer[] srcs) {
            return this.write(srcs, 0, srcs.length);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) {
            Crc32cValue.Crc32cLengthKnown cum = Crc32cValue.zero();
            for (int i = offset; i < length; ++i) {
                long toConsume = this.maxBytesToConsume - cum.getLength();
                if (toConsume <= 0L) {
                    if (cum.getLength() != 0L) break;
                    return -1L;
                }
                ByteBuffer buf = srcs[i];
                if ((long)buf.remaining() <= toConsume) {
                    cum = cum.concat(Hasher.enabled().hash(buf));
                    continue;
                }
                ByteBuffer slice = buf.slice();
                int limit = Math.toIntExact(toConsume);
                slice.limit(limit);
                cum = cum.concat(Hasher.enabled().hash(slice));
                buf.position(buf.position() + limit);
            }
            this.cumulative = this.cumulative.concat(cum);
            return cum.getLength();
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() {
        }
    }
}

