/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.Utils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;

final class JsonUtils {
    private static final Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
    @VisibleForTesting
    static final JsonObjectParser jop = new JsonObjectParser((JsonFactory)new GsonFactory());
    private static final Pattern array_part = Pattern.compile("(.*)\\[(\\d+)]");

    private JsonUtils() {
    }

    static <T extends GenericJson> T getOutputJsonWithSelectedFields(T src, Set<UnifiedOpts.NamedField> fieldsForOutput) {
        Set fieldPaths = (Set)fieldsForOutput.stream().map(UnifiedOpts.NamedField::getApiaryName).collect(ImmutableSet.toImmutableSet());
        try {
            Class<?> aClass;
            String string = jop.getJsonFactory().toPrettyString(src);
            JsonObject jsonObject = (JsonObject)gson.fromJson(string, JsonObject.class);
            JsonObject ret = JsonUtils.getOutputJson(jsonObject, fieldPaths);
            String json = gson.toJson((JsonElement)ret);
            Class<?> clazz = aClass = src.getClass();
            return (T)((GenericJson)jop.parseAndClose((Reader)new StringReader(json), clazz));
        }
        catch (IOException e) {
            throw StorageException.coalesce(e);
        }
    }

    @VisibleForTesting
    static @NonNull JsonObject getOutputJson(JsonObject inputJson, Set<String> fieldsInOutput) {
        Map<String, String> l = JsonUtils.flatten(inputJson);
        Map<String, String> r = Utils.setToMap(fieldsInOutput, k -> null);
        MapDifference diff = Maps.difference(l, r);
        HashMap<String, String> flat = new HashMap<String, String>();
        Stream.of(diff.entriesInCommon().entrySet().stream(), diff.entriesOnlyOnRight().entrySet().stream(), Maps.transformValues((Map)diff.entriesDiffering(), MapDifference.ValueDifference::leftValue).entrySet().stream()).flatMap(x -> x).forEach(e -> flat.put((String)e.getKey(), (String)e.getValue()));
        return JsonUtils.treeify(flat);
    }

    @VisibleForTesting
    static Map<String, String> flatten(JsonObject o) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry e : o.asMap().entrySet()) {
            ret.putAll(JsonUtils.flatten((String)e.getKey(), (JsonElement)e.getValue()));
        }
        return ret;
    }

    @VisibleForTesting
    static JsonObject treeify(Map<String, String> m) {
        JsonObject o = new JsonObject();
        for (Map.Entry<String, String> e : m.entrySet()) {
            String key = e.getKey();
            String[] splits = key.split("\\.");
            String leaf = splits[splits.length - 1];
            JsonObject curr = o;
            int currIdx = -1;
            int splitsEnd = splits.length;
            int leafIdx = splitsEnd - 1;
            for (int i = 0; i < splitsEnd; ++i) {
                JsonNull toAdd;
                int idx;
                String name;
                String split = splits[i];
                Matcher matcher = array_part.matcher(split);
                if (matcher.matches()) {
                    name = matcher.group(1);
                    String idxString = matcher.group(2);
                    idx = Integer.parseInt(idxString);
                } else {
                    idx = -1;
                    name = split;
                }
                if (curr.isJsonObject()) {
                    if (i != leafIdx) {
                        curr = curr.getAsJsonObject().asMap().computeIfAbsent(name, s -> {
                            if (idx > -1) {
                                return new JsonArray();
                            }
                            return new JsonObject();
                        });
                    } else if (idx > -1) {
                        curr = curr.getAsJsonObject().asMap().computeIfAbsent(name, s -> new JsonArray());
                    }
                    currIdx = currIdx == -1 ? idx : -1;
                }
                if (curr.isJsonArray()) {
                    JsonArray a = curr.getAsJsonArray();
                    int size = a.size();
                    int nullElementsToAdd = 0;
                    if (size < currIdx) {
                        nullElementsToAdd = currIdx - size;
                    }
                    for (int j = 0; j < nullElementsToAdd; ++j) {
                        a.add((JsonElement)JsonNull.INSTANCE);
                    }
                }
                if (i != leafIdx) continue;
                String v = e.getValue();
                if (curr.isJsonObject()) {
                    curr.getAsJsonObject().addProperty(leaf, v);
                    continue;
                }
                if (!curr.isJsonArray()) continue;
                JsonArray a = curr.getAsJsonArray();
                if (idx != currIdx) {
                    JsonObject tmp = new JsonObject();
                    tmp.addProperty(leaf, v);
                    toAdd = tmp;
                } else {
                    Object object = toAdd = v == null ? JsonNull.INSTANCE : new JsonPrimitive(v);
                }
                if (a.size() == currIdx) {
                    a.add((JsonElement)toAdd);
                    continue;
                }
                List l = a.asList();
                l.add(currIdx, toAdd);
                l.remove(currIdx + 1);
            }
        }
        return o;
    }

    private static Map<String, String> flatten(String k, JsonElement e) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (e.isJsonObject()) {
            JsonObject o = e.getAsJsonObject();
            for (Map.Entry oe : o.asMap().entrySet()) {
                String prefix = k + "." + (String)oe.getKey();
                ret.putAll(JsonUtils.flatten(prefix, (JsonElement)oe.getValue()));
            }
        } else if (e.isJsonArray()) {
            List asList = e.getAsJsonArray().asList();
            int asListSize = asList.size();
            for (int i = 0; i < asListSize; ++i) {
                JsonElement ee = (JsonElement)asList.get(i);
                ret.putAll(JsonUtils.flatten(k + "[" + i + "]", ee));
            }
        } else if (e.isJsonNull()) {
            ret.put(k, null);
        } else {
            ret.put(k, e.getAsString());
        }
        return ret;
    }
}

