/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.BufferedReadableByteChannelSession;
import com.google.common.base.Suppliers;
import java.util.function.Supplier;

final class LazyReadChannel<T> {
    private final Supplier<BufferedReadableByteChannelSession<T>> session;
    private final Supplier<BufferedReadableByteChannelSession.BufferedReadableByteChannel> channel;
    private boolean open = false;

    LazyReadChannel(Supplier<BufferedReadableByteChannelSession<T>> session) {
        this.session = session;
        this.channel = Suppliers.memoize(() -> {
            this.open = true;
            return (BufferedReadableByteChannelSession.BufferedReadableByteChannel)((BufferedReadableByteChannelSession)session.get()).open();
        });
    }

    BufferedReadableByteChannelSession.BufferedReadableByteChannel getChannel() {
        return this.channel.get();
    }

    Supplier<BufferedReadableByteChannelSession<T>> getSession() {
        return this.session;
    }

    boolean isOpen() {
        return this.open && this.channel.get().isOpen();
    }
}

