/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.Policy;
import com.google.cloud.Identity;
import com.google.cloud.Policy;
import com.google.cloud.Role;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PolicyHelper {
    static Policy convertFromApiPolicy(com.google.api.services.storage.model.Policy apiPolicy) {
        Policy.Builder policyBuilder = Policy.newBuilder();
        List bindings = apiPolicy.getBindings();
        if (null != bindings && !bindings.isEmpty()) {
            for (Policy.Bindings binding : bindings) {
                for (String member : binding.getMembers()) {
                    policyBuilder.addIdentity(Role.of((String)binding.getRole()), Identity.valueOf((String)member), new Identity[0]);
                }
            }
        } else {
            throw new IllegalStateException("Missing required bindings.");
        }
        return policyBuilder.setEtag(apiPolicy.getEtag()).build();
    }

    static com.google.api.services.storage.model.Policy convertToApiPolicy(Policy policy) {
        ArrayList<Policy.Bindings> bindings = new ArrayList<Policy.Bindings>(policy.getBindings().size());
        for (Map.Entry entry : policy.getBindings().entrySet()) {
            ArrayList<String> members = new ArrayList<String>(((Set)entry.getValue()).size());
            for (Identity identity : (Set)entry.getValue()) {
                members.add(identity.strValue());
            }
            bindings.add(new Policy.Bindings().setMembers(members).setRole(((Role)entry.getKey()).getValue()));
        }
        return new com.google.api.services.storage.model.Policy().setBindings(bindings).setEtag(policy.getEtag());
    }

    private PolicyHelper() {
    }
}

