/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Option;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.StorageRpc;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.security.Key;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Blob
extends BlobInfo {
    private static final long serialVersionUID = -6806832496717441434L;
    private final StorageOptions options;
    private transient Storage storage;
    static final Function<StorageRpc.Tuple<Storage, StorageObject>, Blob> BLOB_FROM_PB_FUNCTION = new Function<StorageRpc.Tuple<Storage, StorageObject>, Blob>(){

        public Blob apply(StorageRpc.Tuple<Storage, StorageObject> pb) {
            return Blob.fromPb(pb.x(), pb.y());
        }
    };

    Blob(Storage storage, BlobInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.storage = (Storage)Preconditions.checkNotNull((Object)storage);
        this.options = (StorageOptions)storage.options();
    }

    public boolean exists(BlobSourceOption ... options) {
        int length = options.length;
        Storage.BlobGetOption[] getOptions = Arrays.copyOf(BlobSourceOption.toGetOptions(this, options), length + 1);
        getOptions[length] = Storage.BlobGetOption.fields(new Storage.BlobField[0]);
        return this.storage.get(this.blobId(), getOptions) != null;
    }

    public byte[] content(BlobSourceOption ... options) {
        return this.storage.readAllBytes(this.blobId(), BlobSourceOption.toSourceOptions(this, options));
    }

    public Blob reload(BlobSourceOption ... options) {
        return this.storage.get(this.blobId(), BlobSourceOption.toGetOptions(this, options));
    }

    public Blob update(Storage.BlobTargetOption ... options) {
        return this.storage.update((BlobInfo)this, options);
    }

    public boolean delete(BlobSourceOption ... options) {
        return this.storage.delete(this.blobId(), BlobSourceOption.toSourceOptions(this, options));
    }

    public CopyWriter copyTo(BlobId targetBlob, BlobSourceOption ... options) {
        Storage.CopyRequest copyRequest = Storage.CopyRequest.builder().source(this.bucket(), this.name()).sourceOptions(BlobSourceOption.toSourceOptions(this, options)).target(targetBlob).build();
        return this.storage.copy(copyRequest);
    }

    public CopyWriter copyTo(String targetBucket, BlobSourceOption ... options) {
        return this.copyTo(targetBucket, this.name(), options);
    }

    public CopyWriter copyTo(String targetBucket, String targetBlob, BlobSourceOption ... options) {
        return this.copyTo(BlobId.of(targetBucket, targetBlob), options);
    }

    public ReadChannel reader(BlobSourceOption ... options) {
        return this.storage.reader(this.blobId(), BlobSourceOption.toSourceOptions(this, options));
    }

    public WriteChannel writer(Storage.BlobWriteOption ... options) {
        return this.storage.writer(this, options);
    }

    public URL signUrl(long duration, TimeUnit unit, Storage.SignUrlOption ... options) {
        return this.storage.signUrl(this, duration, unit, options);
    }

    public Acl getAcl(Acl.Entity entity) {
        return this.storage.getAcl(this.blobId(), entity);
    }

    public boolean deleteAcl(Acl.Entity entity) {
        return this.storage.deleteAcl(this.blobId(), entity);
    }

    public Acl createAcl(Acl acl) {
        return this.storage.createAcl(this.blobId(), acl);
    }

    public Acl updateAcl(Acl acl) {
        return this.storage.updateAcl(this.blobId(), acl);
    }

    public List<Acl> listAcls() {
        return this.storage.listAcls(this.blobId());
    }

    public Storage storage() {
        return this.storage;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Blob.class)) {
            return false;
        }
        Blob other = (Blob)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.storage = (Storage)this.options.service();
    }

    static Blob fromPb(Storage storage, StorageObject storageObject) {
        BlobInfo info = BlobInfo.fromPb(storageObject);
        return new Blob(storage, new BlobInfo.BuilderImpl(info));
    }

    public static class Builder
    extends BlobInfo.Builder {
        private final Storage storage;
        private final BlobInfo.BuilderImpl infoBuilder;

        Builder(Blob blob) {
            this.storage = blob.storage();
            this.infoBuilder = new BlobInfo.BuilderImpl(blob);
        }

        @Override
        public Builder blobId(BlobId blobId) {
            this.infoBuilder.blobId(blobId);
            return this;
        }

        @Override
        Builder generatedId(String generatedId) {
            this.infoBuilder.generatedId(generatedId);
            return this;
        }

        @Override
        public Builder contentType(String contentType) {
            this.infoBuilder.contentType(contentType);
            return this;
        }

        @Override
        public Builder contentDisposition(String contentDisposition) {
            this.infoBuilder.contentDisposition(contentDisposition);
            return this;
        }

        @Override
        public Builder contentLanguage(String contentLanguage) {
            this.infoBuilder.contentLanguage(contentLanguage);
            return this;
        }

        @Override
        public Builder contentEncoding(String contentEncoding) {
            this.infoBuilder.contentEncoding(contentEncoding);
            return this;
        }

        @Override
        Builder componentCount(Integer componentCount) {
            this.infoBuilder.componentCount(componentCount);
            return this;
        }

        @Override
        public Builder cacheControl(String cacheControl) {
            this.infoBuilder.cacheControl(cacheControl);
            return this;
        }

        @Override
        public Builder acl(List<Acl> acl) {
            this.infoBuilder.acl(acl);
            return this;
        }

        @Override
        Builder owner(Acl.Entity owner) {
            this.infoBuilder.owner(owner);
            return this;
        }

        @Override
        Builder size(Long size) {
            this.infoBuilder.size(size);
            return this;
        }

        @Override
        Builder etag(String etag) {
            this.infoBuilder.etag(etag);
            return this;
        }

        @Override
        Builder selfLink(String selfLink) {
            this.infoBuilder.selfLink(selfLink);
            return this;
        }

        @Override
        public Builder md5(String md5) {
            this.infoBuilder.md5(md5);
            return this;
        }

        @Override
        public Builder crc32c(String crc32c) {
            this.infoBuilder.crc32c(crc32c);
            return this;
        }

        @Override
        Builder mediaLink(String mediaLink) {
            this.infoBuilder.mediaLink(mediaLink);
            return this;
        }

        @Override
        public Builder metadata(Map<String, String> metadata) {
            this.infoBuilder.metadata(metadata);
            return this;
        }

        @Override
        Builder metageneration(Long metageneration) {
            this.infoBuilder.metageneration(metageneration);
            return this;
        }

        @Override
        Builder deleteTime(Long deleteTime) {
            this.infoBuilder.deleteTime(deleteTime);
            return this;
        }

        @Override
        Builder updateTime(Long updateTime) {
            this.infoBuilder.updateTime(updateTime);
            return this;
        }

        @Override
        Builder createTime(Long createTime) {
            this.infoBuilder.createTime(createTime);
            return this;
        }

        @Override
        Builder isDirectory(boolean isDirectory) {
            this.infoBuilder.isDirectory(isDirectory);
            return this;
        }

        @Override
        Builder customerEncryption(BlobInfo.CustomerEncryption customerEncryption) {
            this.infoBuilder.customerEncryption(customerEncryption);
            return this;
        }

        @Override
        public Blob build() {
            return new Blob(this.storage, this.infoBuilder);
        }
    }

    public static class BlobSourceOption
    extends Option {
        private static final long serialVersionUID = 214616862061934846L;

        private BlobSourceOption(StorageRpc.Option rpcOption) {
            super(rpcOption, null);
        }

        private BlobSourceOption(StorageRpc.Option rpcOption, Object value) {
            super(rpcOption, value);
        }

        private Storage.BlobSourceOption toSourceOptions(BlobInfo blobInfo) {
            switch (this.rpcOption()) {
                case IF_GENERATION_MATCH: {
                    return Storage.BlobSourceOption.generationMatch(blobInfo.generation());
                }
                case IF_GENERATION_NOT_MATCH: {
                    return Storage.BlobSourceOption.generationNotMatch(blobInfo.generation());
                }
                case IF_METAGENERATION_MATCH: {
                    return Storage.BlobSourceOption.metagenerationMatch(blobInfo.metageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BlobSourceOption.metagenerationNotMatch(blobInfo.metageneration());
                }
                case CUSTOMER_SUPPLIED_KEY: {
                    return Storage.BlobSourceOption.decryptionKey((String)this.value());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        private Storage.BlobGetOption toGetOption(BlobInfo blobInfo) {
            switch (this.rpcOption()) {
                case IF_GENERATION_MATCH: {
                    return Storage.BlobGetOption.generationMatch(blobInfo.generation());
                }
                case IF_GENERATION_NOT_MATCH: {
                    return Storage.BlobGetOption.generationNotMatch(blobInfo.generation());
                }
                case IF_METAGENERATION_MATCH: {
                    return Storage.BlobGetOption.metagenerationMatch(blobInfo.metageneration());
                }
                case IF_METAGENERATION_NOT_MATCH: {
                    return Storage.BlobGetOption.metagenerationNotMatch(blobInfo.metageneration());
                }
            }
            throw new AssertionError((Object)"Unexpected enum value");
        }

        public static BlobSourceOption generationMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_MATCH);
        }

        public static BlobSourceOption generationNotMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_GENERATION_NOT_MATCH);
        }

        public static BlobSourceOption metagenerationMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_METAGENERATION_MATCH);
        }

        public static BlobSourceOption metagenerationNotMatch() {
            return new BlobSourceOption(StorageRpc.Option.IF_METAGENERATION_NOT_MATCH);
        }

        public static BlobSourceOption decryptionKey(Key key) {
            String base64Key = BaseEncoding.base64().encode(key.getEncoded());
            return new BlobSourceOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, base64Key);
        }

        public static BlobSourceOption decryptionKey(String key) {
            return new BlobSourceOption(StorageRpc.Option.CUSTOMER_SUPPLIED_KEY, key);
        }

        static Storage.BlobSourceOption[] toSourceOptions(BlobInfo blobInfo, BlobSourceOption ... options) {
            Storage.BlobSourceOption[] convertedOptions = new Storage.BlobSourceOption[options.length];
            int index = 0;
            for (BlobSourceOption option : options) {
                convertedOptions[index++] = option.toSourceOptions(blobInfo);
            }
            return convertedOptions;
        }

        static Storage.BlobGetOption[] toGetOptions(BlobInfo blobInfo, BlobSourceOption ... options) {
            Storage.BlobGetOption[] convertedOptions = new Storage.BlobGetOption[options.length];
            int index = 0;
            for (BlobSourceOption option : options) {
                convertedOptions[index++] = option.toGetOption(blobInfo);
            }
            return convertedOptions;
        }
    }
}

