/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ListenableFutureToApiFuture;
import com.google.cloud.spanner.ThreadFactoryUtil;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Duration;
import io.opentelemetry.context.Context;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class StatementExecutor {
    private static final ThreadFactory DEFAULT_VIRTUAL_THREAD_FACTORY = ThreadFactoryUtil.createVirtualOrPlatformDaemonThreadFactory("connection-executor", true);
    private static final ThreadFactory DEFAULT_DAEMON_THREAD_FACTORY = ThreadFactoryUtil.createVirtualOrPlatformDaemonThreadFactory("connection-executor", false);
    private final ListeningExecutorService executor;
    private final List<StatementExecutionInterceptor> interceptors;

    private static ListeningExecutorService createExecutorService(StatementExecutorType type) {
        if (type == StatementExecutorType.DIRECT_EXECUTOR) {
            return MoreExecutors.newDirectExecutorService();
        }
        return MoreExecutors.listeningDecorator((ExecutorService)Context.taskWrapping((ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), type == StatementExecutorType.VIRTUAL_THREAD ? DEFAULT_VIRTUAL_THREAD_FACTORY : DEFAULT_DAEMON_THREAD_FACTORY)));
    }

    @VisibleForTesting
    StatementExecutor() {
        this(StatementExecutorType.PLATFORM_THREAD, Collections.emptyList());
    }

    StatementExecutor(StatementExecutorType type, List<StatementExecutionInterceptor> interceptors) {
        this.executor = StatementExecutor.createExecutorService(type);
        this.interceptors = Collections.unmodifiableList(interceptors);
    }

    void shutdown() {
        this.executor.shutdown();
    }

    void shutdownNow() {
        this.executor.shutdownNow();
    }

    <T> ApiFuture<T> submit(Callable<T> callable) {
        return new ListenableFutureToApiFuture(this.executor.submit(callable));
    }

    void invokeInterceptors(AbstractStatementParser.ParsedStatement statement, StatementExecutionStep step, UnitOfWork transaction) {
        for (StatementExecutionInterceptor interceptor : this.interceptors) {
            interceptor.intercept(statement, step, transaction);
        }
    }

    public static enum StatementExecutorType {
        PLATFORM_THREAD,
        VIRTUAL_THREAD,
        DIRECT_EXECUTOR;

    }

    static class StatementTimeout {
        private volatile Duration duration = null;

        StatementTimeout() {
        }

        static boolean isValidTimeoutUnit(TimeUnit unit) {
            return unit == TimeUnit.NANOSECONDS || unit == TimeUnit.MICROSECONDS || unit == TimeUnit.MILLISECONDS || unit == TimeUnit.SECONDS;
        }

        boolean hasTimeout() {
            return this.duration != null;
        }

        void clearTimeoutValue() {
            this.duration = null;
        }

        void setTimeoutValue(long timeout, TimeUnit unit) {
            Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)StatementTimeout.isValidTimeoutUnit(unit));
            this.duration = ReadOnlyStalenessUtil.createDuration(timeout, unit);
        }

        long getTimeoutValue(TimeUnit unit) {
            Preconditions.checkArgument((boolean)StatementTimeout.isValidTimeoutUnit(unit));
            return this.duration == null ? 0L : ReadOnlyStalenessUtil.durationToUnits(this.duration, unit);
        }

        TimeUnit getAppropriateTimeUnit() {
            ConnectionPreconditions.checkState(this.duration != null, "This StatementTimeout has no timeout value");
            return ReadOnlyStalenessUtil.getAppropriateTimeUnit(new ReadOnlyStalenessUtil.DurationValueGetter(){

                @Override
                public long getDuration(TimeUnit unit) {
                    return this.getTimeoutValue(unit);
                }

                @Override
                public boolean hasDuration() {
                    return this.hasTimeout();
                }
            });
        }

        java.time.Duration asDuration() {
            if (!this.hasTimeout()) {
                return java.time.Duration.ZERO;
            }
            TimeUnit unit = this.getAppropriateTimeUnit();
            switch (unit) {
                case DAYS: {
                    return java.time.Duration.ofDays(this.getTimeoutValue(unit));
                }
                case HOURS: {
                    return java.time.Duration.ofHours(this.getTimeoutValue(unit));
                }
                case MICROSECONDS: {
                    return java.time.Duration.of(this.getTimeoutValue(unit), ChronoUnit.MICROS);
                }
                case MILLISECONDS: {
                    return java.time.Duration.ofMillis(this.getTimeoutValue(unit));
                }
                case MINUTES: {
                    return java.time.Duration.ofMinutes(this.getTimeoutValue(unit));
                }
                case NANOSECONDS: {
                    return java.time.Duration.ofNanos(this.getTimeoutValue(unit));
                }
                case SECONDS: {
                    return java.time.Duration.ofSeconds(this.getTimeoutValue(unit));
                }
            }
            throw new IllegalStateException("invalid time unit: " + (Object)((Object)unit));
        }
    }
}

