/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TransactionManager;
import java.util.concurrent.ExecutionException;

public class DelayedAsyncTransactionManager
implements AsyncTransactionManager {
    private final ApiFuture<AsyncTransactionManager> asyncTransactionManagerApiFuture;

    DelayedAsyncTransactionManager(ApiFuture<AsyncTransactionManager> asyncTransactionManagerApiFuture) {
        this.asyncTransactionManagerApiFuture = asyncTransactionManagerApiFuture;
    }

    AsyncTransactionManager getAsyncTransactionManager() {
        try {
            return (AsyncTransactionManager)this.asyncTransactionManagerApiFuture.get();
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.causeAsRunTimeException(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
    }

    @Override
    public AsyncTransactionManager.TransactionContextFuture beginAsync() {
        return this.getAsyncTransactionManager().beginAsync();
    }

    @Override
    public AsyncTransactionManager.TransactionContextFuture beginAsync(AbortedException exception) {
        return this.getAsyncTransactionManager().beginAsync(exception);
    }

    @Override
    public ApiFuture<Void> rollbackAsync() {
        return this.getAsyncTransactionManager().rollbackAsync();
    }

    @Override
    public AsyncTransactionManager.TransactionContextFuture resetForRetryAsync() {
        return this.getAsyncTransactionManager().resetForRetryAsync();
    }

    @Override
    public TransactionManager.TransactionState getState() {
        return this.getAsyncTransactionManager().getState();
    }

    @Override
    public ApiFuture<CommitResponse> getCommitResponse() {
        return this.getAsyncTransactionManager().getCommitResponse();
    }

    @Override
    public void close() {
        this.getAsyncTransactionManager().close();
    }

    @Override
    public ApiFuture<Void> closeAsync() {
        return this.getAsyncTransactionManager().closeAsync();
    }
}

