/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.MethodName;
import com.google.api.gax.tracing.MetricsRecorder;
import com.google.api.gax.tracing.MetricsTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.cloud.spanner.BuiltInMetricsRecorder;
import com.google.cloud.spanner.BuiltInMetricsTracer;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.TraceWrapper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

class BuiltInMetricsTracerFactory
extends MetricsTracerFactory {
    protected BuiltInMetricsRecorder builtInMetricsRecorder;
    private final Map<String, String> attributes;
    private final TraceWrapper traceWrapper;

    public BuiltInMetricsTracerFactory(BuiltInMetricsRecorder builtInMetricsRecorder, Map<String, String> attributes, TraceWrapper traceWrapper) {
        super((MetricsRecorder)builtInMetricsRecorder, attributes);
        this.builtInMetricsRecorder = builtInMetricsRecorder;
        this.attributes = ImmutableMap.copyOf(attributes);
        this.traceWrapper = traceWrapper;
    }

    public ApiTracer newTracer(ApiTracer parent, SpanName spanName, ApiTracerFactory.OperationType operationType) {
        ISpan currentSpan = this.traceWrapper.getCurrentSpan();
        BuiltInMetricsTracer metricsTracer = new BuiltInMetricsTracer(MethodName.of((String)spanName.getClientName(), (String)spanName.getMethodName()), this.builtInMetricsRecorder, this.traceWrapper, currentSpan);
        metricsTracer.addAttributes(this.attributes);
        return metricsTracer;
    }
}

