/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.tracing.OpenTelemetryMetricsRecorder;
import com.google.cloud.spanner.BuiltInMetricsConstant;
import com.google.common.base.Preconditions;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.util.Map;

class BuiltInMetricsRecorder
extends OpenTelemetryMetricsRecorder {
    private final DoubleHistogram gfeLatencyRecorder;
    private final DoubleHistogram afeLatencyRecorder;
    private final LongCounter gfeHeaderMissingCountRecorder;
    private final LongCounter afeHeaderMissingCountRecorder;

    BuiltInMetricsRecorder(OpenTelemetry openTelemetry, String serviceName) {
        super(openTelemetry, serviceName);
        Meter meter = openTelemetry.meterBuilder("spanner-java").setInstrumentationVersion(GaxProperties.getLibraryVersion(((Object)((Object)this)).getClass())).build();
        this.gfeLatencyRecorder = meter.histogramBuilder(serviceName + '/' + "gfe_latencies").setDescription("Latency between Google's network receiving an RPC and reading back the first byte of the response").setUnit("ms").setExplicitBucketBoundariesAdvice(BuiltInMetricsConstant.BUCKET_BOUNDARIES).build();
        this.afeLatencyRecorder = meter.histogramBuilder(serviceName + '/' + "afe_latencies").setDescription("Latency between Spanner API Frontend receiving an RPC and starting to write back the response.").setExplicitBucketBoundariesAdvice(BuiltInMetricsConstant.BUCKET_BOUNDARIES).setUnit("ms").build();
        this.gfeHeaderMissingCountRecorder = meter.counterBuilder(serviceName + '/' + "gfe_connectivity_error_count").setDescription("Number of requests that failed to reach the Google network.").setUnit("1").build();
        this.afeHeaderMissingCountRecorder = meter.counterBuilder(serviceName + '/' + "afe_connectivity_error_count").setDescription("Number of requests that failed to reach the Spanner API Frontend.").setUnit("1").build();
    }

    void recordServerTimingHeaderMetrics(Float gfeLatency, Float afeLatency, Long gfeHeaderMissingCount, Long afeHeaderMissingCount, Map<String, String> attributes) {
        Attributes otelAttributes = this.toOtelAttributes(attributes);
        if (gfeLatency != null) {
            this.gfeLatencyRecorder.record((double)gfeLatency.floatValue(), otelAttributes);
        }
        if (gfeHeaderMissingCount > 0L) {
            this.gfeHeaderMissingCountRecorder.add(gfeHeaderMissingCount.longValue(), otelAttributes);
        }
        if (afeLatency != null) {
            this.afeLatencyRecorder.record((double)afeLatency.floatValue(), otelAttributes);
        }
        if (afeHeaderMissingCount > 0L) {
            this.afeHeaderMissingCountRecorder.add(afeHeaderMissingCount.longValue(), otelAttributes);
        }
    }

    Attributes toOtelAttributes(Map<String, String> attributes) {
        Preconditions.checkNotNull(attributes, (Object)"Attributes map cannot be null");
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return attributesBuilder.build();
    }
}

