/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.spanner.v1.TransactionOptions;
import java.util.Objects;

class PgTransactionMode {
    private AccessMode accessMode;
    private IsolationLevel isolationLevel;

    PgTransactionMode() {
    }

    AccessMode getAccessMode() {
        return this.accessMode;
    }

    void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    void setIsolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessMode, this.isolationLevel});
    }

    public boolean equals(Object o) {
        if (!(o instanceof PgTransactionMode)) {
            return false;
        }
        PgTransactionMode other = (PgTransactionMode)o;
        return Objects.equals((Object)this.accessMode, (Object)other.accessMode) && Objects.equals((Object)this.isolationLevel, (Object)other.isolationLevel);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.accessMode != null) {
            result.append(this.accessMode.statementString);
        }
        if (this.isolationLevel != null) {
            if (this.accessMode != null) {
                result.append(' ');
            }
            result.append(this.isolationLevel.statementString);
        }
        return result.toString();
    }

    static enum AccessMode {
        READ_ONLY_TRANSACTION("READ ONLY"),
        READ_WRITE_TRANSACTION("READ WRITE");

        private final String statementString;

        private AccessMode(String statement) {
            this.statementString = statement;
        }

        public String toString() {
            return this.statementString;
        }
    }

    static enum IsolationLevel {
        ISOLATION_LEVEL_DEFAULT("ISOLATION LEVEL DEFAULT", "DEFAULT", TransactionOptions.IsolationLevel.ISOLATION_LEVEL_UNSPECIFIED),
        ISOLATION_LEVEL_SERIALIZABLE("ISOLATION LEVEL SERIALIZABLE", "SERIALIZABLE", TransactionOptions.IsolationLevel.SERIALIZABLE),
        ISOLATION_LEVEL_REPEATABLE_READ("ISOLATION LEVEL REPEATABLE READ", "REPEATABLE READ", TransactionOptions.IsolationLevel.REPEATABLE_READ);

        private final String statementString;
        private final String shortStatementString;
        private final TransactionOptions.IsolationLevel spannerIsolationLevel;

        private IsolationLevel(String statement, String shortStatementString, TransactionOptions.IsolationLevel spannerIsolationLevel) {
            this.statementString = statement;
            this.shortStatementString = shortStatementString;
            this.spannerIsolationLevel = spannerIsolationLevel;
        }

        public String getStatementString() {
            return this.statementString;
        }

        public String getShortStatementString() {
            return this.shortStatementString;
        }

        public TransactionOptions.IsolationLevel getSpannerIsolationLevel() {
            return this.spannerIsolationLevel;
        }

        public String toString() {
            return this.statementString;
        }
    }
}

