/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiClock;
import com.google.api.core.CurrentMillisClock;
import com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.google.api.gax.retrying.PollException;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.RetryHelper;
import com.google.cloud.RetryOption;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.rpc.Status;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

public class Operation<R, M> {
    private final RetrySettings DEFAULT_OPERATION_WAIT_SETTINGS = RetrySettings.newBuilder().setTotalTimeoutDuration(Duration.ofHours(12L)).setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.0).setJittered(false).setMaxRetryDelayDuration(Duration.ofMinutes(500L)).build();
    private final M metadata;
    private final R result;
    private final SpannerException exception;
    private final boolean isDone;
    private final SpannerRpc rpc;
    private final String name;
    private final Parser<R, M> parser;
    private final ApiClock clock;

    @VisibleForTesting
    Operation(SpannerRpc rpc, String name, @Nullable M metadata, @Nullable R result, @Nullable SpannerException exception, boolean isDone, Parser<R, M> parser, ApiClock clock) {
        this.rpc = rpc;
        this.name = name;
        this.metadata = metadata;
        this.result = result;
        this.exception = exception;
        this.isDone = isDone;
        this.parser = parser;
        this.clock = clock;
    }

    private static <R, M> Operation<R, M> failed(SpannerRpc rpc, String name, Status status, M metadata, Parser<R, M> parser, ApiClock clock) {
        SpannerException e = SpannerExceptionFactory.newSpannerException(ErrorCode.fromRpcStatus(status), status.getMessage(), (Throwable)null);
        return new Operation<Object, M>(rpc, name, metadata, null, e, true, parser, clock);
    }

    private static <R, M> Operation<R, M> successful(SpannerRpc rpc, String name, M metadata, R result, Parser<R, M> parser, ApiClock clock) {
        return new Operation<R, M>(rpc, name, metadata, result, null, true, parser, clock);
    }

    private static <R, M> Operation<R, M> pending(SpannerRpc rpc, String name, M metadata, Parser<R, M> parser, ApiClock clock) {
        return new Operation<Object, M>(rpc, name, metadata, null, null, false, parser, clock);
    }

    static <R, M> Operation<R, M> create(SpannerRpc rpc, com.google.longrunning.Operation proto, Parser<R, M> parser) {
        return Operation.create(rpc, proto, parser, CurrentMillisClock.getDefaultClock());
    }

    static <R, M> Operation<R, M> create(SpannerRpc rpc, com.google.longrunning.Operation proto, Parser<R, M> parser, ApiClock clock) {
        M metadata = proto.hasMetadata() ? (M)parser.parseMetadata(proto.getMetadata()) : null;
        String name = proto.getName();
        if (proto.getDone()) {
            if (proto.getResultCase() == Operation.ResultCase.ERROR) {
                return Operation.failed(rpc, name, proto.getError(), metadata, parser, clock);
            }
            return Operation.successful(rpc, name, metadata, parser.parseResult(proto.getResponse()), parser, clock);
        }
        return Operation.pending(rpc, name, metadata, parser, clock);
    }

    public Operation<R, M> reload() throws SpannerException {
        if (this.isDone) {
            return this;
        }
        com.google.longrunning.Operation proto = this.rpc.getOperation(this.name);
        return Operation.create(this.rpc, proto, this.parser);
    }

    public Operation<R, M> waitFor(RetryOption ... waitOptions) throws SpannerException {
        if (this.isDone()) {
            return this;
        }
        RetrySettings waitSettings = RetryOption.mergeToSettings((RetrySettings)this.DEFAULT_OPERATION_WAIT_SETTINGS, (RetryOption[])waitOptions);
        try {
            com.google.longrunning.Operation proto = (com.google.longrunning.Operation)RetryHelper.poll(() -> this.rpc.getOperation(this.name), (RetrySettings)waitSettings, (ResultRetryAlgorithm)new BasicResultRetryAlgorithm<com.google.longrunning.Operation>(){

                public boolean shouldRetry(Throwable prevThrowable, com.google.longrunning.Operation prevResponse) {
                    if (prevResponse != null) {
                        return !prevResponse.getDone();
                    }
                    if (prevThrowable instanceof SpannerException) {
                        SpannerException spannerException = (SpannerException)((Object)prevThrowable);
                        return spannerException.getErrorCode() != ErrorCode.NOT_FOUND && spannerException.isRetryable();
                    }
                    return false;
                }
            }, (ApiClock)this.clock);
            return Operation.create(this.rpc, proto, this.parser);
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SpannerException) {
                SpannerException spannerException = (SpannerException)((Object)cause);
                if (spannerException.getErrorCode() == ErrorCode.NOT_FOUND) {
                    return null;
                }
                throw spannerException;
            }
            if (cause instanceof PollException) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.DEADLINE_EXCEEDED, "Operation did not complete in the given time");
            }
            throw SpannerExceptionFactory.newSpannerException(cause);
        }
    }

    public M getMetadata() {
        return this.metadata;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public R getResult() throws SpannerException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSuccessful() {
        return this.isDone && this.exception == null;
    }

    static interface Parser<R, M> {
        public R parseResult(Any var1);

        public M parseMetadata(Any var1);
    }
}

