/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.StatementParser;

@InternalApi
interface UnitOfWork {
    public void cancel();

    public Type getType();

    public UnitOfWorkState getState();

    public boolean isActive();

    public ApiFuture<Void> commitAsync();

    public ApiFuture<Void> rollbackAsync();

    public ApiFuture<long[]> runBatchAsync();

    public void abortBatch();

    public boolean isReadOnly();

    public ApiFuture<ResultSet> executeQueryAsync(StatementParser.ParsedStatement var1, AnalyzeMode var2, Options.QueryOption ... var3);

    public Timestamp getReadTimestamp();

    public Timestamp getReadTimestampOrNull();

    public Timestamp getCommitTimestamp();

    public Timestamp getCommitTimestampOrNull();

    public ApiFuture<Void> executeDdlAsync(StatementParser.ParsedStatement var1);

    public ApiFuture<Long> executeUpdateAsync(StatementParser.ParsedStatement var1);

    public ApiFuture<long[]> executeBatchUpdateAsync(Iterable<StatementParser.ParsedStatement> var1);

    public ApiFuture<Void> writeAsync(Iterable<Mutation> var1);

    public static enum UnitOfWorkState {
        STARTED,
        COMMITTING,
        COMMITTED,
        COMMIT_FAILED,
        ROLLED_BACK,
        RUNNING,
        RAN,
        RUN_FAILED,
        ABORTED;


        public boolean isActive() {
            return this == STARTED;
        }
    }

    public static enum Type {
        TRANSACTION,
        BATCH;

    }
}

