/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.connection.AbstractBaseUnitOfWork;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

class SingleUseTransaction
extends AbstractBaseUnitOfWork {
    private final boolean readOnly;
    private final DdlClient ddlClient;
    private final DatabaseClient dbClient;
    private final TimestampBound readOnlyStaleness;
    private final AutocommitDmlMode autocommitDmlMode;
    private Timestamp readTimestamp = null;
    private volatile TransactionManager txManager;
    private TransactionRunner writeTransaction;
    private boolean used = false;
    private UnitOfWork.UnitOfWorkState state = UnitOfWork.UnitOfWorkState.STARTED;
    private final StatementParser.ParsedStatement executeBatchUpdateStatement = StatementParser.INSTANCE.parse(Statement.of("RUN BATCH"));

    static Builder newBuilder() {
        return new Builder();
    }

    private SingleUseTransaction(Builder builder) {
        super(builder);
        this.ddlClient = builder.ddlClient;
        this.dbClient = builder.dbClient;
        this.readOnly = builder.readOnly;
        this.readOnlyStaleness = builder.readOnlyStaleness;
        this.autocommitDmlMode = builder.autocommitDmlMode;
    }

    @Override
    public UnitOfWork.Type getType() {
        return UnitOfWork.Type.TRANSACTION;
    }

    @Override
    public UnitOfWork.UnitOfWorkState getState() {
        return this.state;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    private void checkAndMarkUsed() {
        Preconditions.checkState((!this.used ? 1 : 0) != 0, (Object)"This single-use transaction has already been used");
        this.used = true;
    }

    @Override
    public ResultSet executeQuery(final StatementParser.ParsedStatement statement, final AnalyzeMode analyzeMode, final Options.QueryOption ... options) {
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkArgument((boolean)statement.isQuery(), (Object)"Statement is not a query");
        this.checkAndMarkUsed();
        final ReadOnlyTransaction currentTransaction = this.dbClient.singleUseReadOnlyTransaction(this.readOnlyStaleness);
        Callable<ResultSet> callable = new Callable<ResultSet>(){

            @Override
            public ResultSet call() throws Exception {
                try {
                    ResultSet rs = analyzeMode == AnalyzeMode.NONE ? currentTransaction.executeQuery(statement.getStatement(), options) : currentTransaction.analyzeQuery(statement.getStatement(), analyzeMode.getQueryAnalyzeMode());
                    DirectExecuteResultSet directExecuteResultSet = DirectExecuteResultSet.ofResultSet(rs);
                    return directExecuteResultSet;
                }
                finally {
                    currentTransaction.close();
                }
            }
        };
        try {
            ResultSet res = this.asyncExecuteStatement(statement, callable);
            this.readTimestamp = currentTransaction.getReadTimestamp();
            this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
            ResultSet resultSet = res;
            return resultSet;
        }
        catch (Throwable e) {
            this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
            throw e;
        }
        finally {
            currentTransaction.close();
        }
    }

    @Override
    public Timestamp getReadTimestamp() {
        ConnectionPreconditions.checkState(this.readTimestamp != null, "There is no read timestamp available for this transaction.");
        return this.readTimestamp;
    }

    @Override
    public Timestamp getReadTimestampOrNull() {
        return this.readTimestamp;
    }

    private boolean hasCommitTimestamp() {
        return this.writeTransaction != null || this.txManager != null && this.txManager.getState() == TransactionManager.TransactionState.COMMITTED;
    }

    @Override
    public Timestamp getCommitTimestamp() {
        ConnectionPreconditions.checkState(this.hasCommitTimestamp(), "There is no commit timestamp available for this transaction.");
        return this.writeTransaction != null ? this.writeTransaction.getCommitTimestamp() : this.txManager.getCommitTimestamp();
    }

    @Override
    public Timestamp getCommitTimestampOrNull() {
        if (this.hasCommitTimestamp()) {
            try {
                return this.writeTransaction != null ? this.writeTransaction.getCommitTimestamp() : this.txManager.getCommitTimestamp();
            }
            catch (SpannerException spannerException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void executeDdl(final StatementParser.ParsedStatement ddl) {
        Preconditions.checkNotNull((Object)ddl);
        Preconditions.checkArgument((ddl.getType() == StatementParser.StatementType.DDL ? 1 : 0) != 0, (Object)"Statement is not a ddl statement");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "DDL statements are not allowed in read-only mode");
        this.checkAndMarkUsed();
        try {
            Callable<Void> callable = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    OperationFuture<Void, UpdateDatabaseDdlMetadata> operation = SingleUseTransaction.this.ddlClient.executeDdl(ddl.getSqlWithoutComments());
                    return (Void)operation.get();
                }
            };
            this.asyncExecuteStatement(ddl, callable);
            this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
        }
        catch (Throwable e) {
            this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
            throw e;
        }
    }

    @Override
    public long executeUpdate(StatementParser.ParsedStatement update) {
        long res;
        Preconditions.checkNotNull((Object)update);
        Preconditions.checkArgument((boolean)update.isUpdate(), (Object)"Statement is not an update statement");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Update statements are not allowed in read-only mode");
        this.checkAndMarkUsed();
        try {
            switch (this.autocommitDmlMode) {
                case TRANSACTIONAL: {
                    res = this.executeAsyncTransactionalUpdate(update, new TransactionalUpdateCallable(update));
                    break;
                }
                case PARTITIONED_NON_ATOMIC: {
                    res = this.executeAsyncPartitionedUpdate(update);
                    break;
                }
                default: {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Unknown dml mode: " + (Object)((Object)this.autocommitDmlMode));
                }
            }
        }
        catch (Throwable e) {
            this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
            throw e;
        }
        this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
        return res;
    }

    private long executeAsyncPartitionedUpdate(final StatementParser.ParsedStatement update) {
        Callable<Long> callable = new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return SingleUseTransaction.this.dbClient.executePartitionedUpdate(update.getStatement());
            }
        };
        return this.asyncExecuteStatement(update, callable);
    }

    @Override
    public long[] executeBatchUpdate(Iterable<StatementParser.ParsedStatement> updates) {
        long[] res;
        Preconditions.checkNotNull(updates);
        for (StatementParser.ParsedStatement update : updates) {
            Preconditions.checkArgument((boolean)update.isUpdate(), (Object)("Statement is not an update statement: " + update.getSqlWithoutComments()));
        }
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Batch update statements are not allowed in read-only mode");
        this.checkAndMarkUsed();
        try {
            switch (this.autocommitDmlMode) {
                case TRANSACTIONAL: {
                    res = this.executeAsyncTransactionalUpdate(this.executeBatchUpdateStatement, new TransactionalBatchUpdateCallable(updates));
                    break;
                }
                case PARTITIONED_NON_ATOMIC: {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Batch updates are not allowed in " + (Object)((Object)this.autocommitDmlMode));
                }
                default: {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Unknown dml mode: " + (Object)((Object)this.autocommitDmlMode));
                }
            }
        }
        catch (SpannerBatchUpdateException e) {
            this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
            throw e;
        }
        catch (Throwable e) {
            this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
            throw e;
        }
        this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
        return res;
    }

    private <T> T executeAsyncTransactionalUpdate(StatementParser.ParsedStatement update, AbstractUpdateCallable<T> callable) {
        long startedTime = System.currentTimeMillis();
        while (true) {
            try {
                return this.asyncExecuteStatement(update, callable);
            }
            catch (AbortedException e) {
                try {
                    Thread.sleep(e.getRetryDelayInMillis() / 1000L);
                }
                catch (InterruptedException e1) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "Statement execution was interrupted", e1);
                }
                long executionTime = System.currentTimeMillis() - startedTime;
                if (!this.getStatementTimeout().hasTimeout() || executionTime <= this.getStatementTimeout().getTimeoutValue(TimeUnit.MILLISECONDS)) continue;
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.DEADLINE_EXCEEDED, "Statement execution timeout occurred for " + update.getSqlWithoutComments());
            }
            break;
        }
    }

    private void checkInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    @Override
    public void write(Mutation mutation) {
        this.write(Arrays.asList(mutation));
    }

    @Override
    public void write(final Iterable<Mutation> mutations) {
        Preconditions.checkNotNull(mutations);
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Update statements are not allowed in read-only mode");
        this.checkAndMarkUsed();
        this.writeTransaction = this.dbClient.readWriteTransaction();
        try {
            this.writeTransaction.run(new TransactionRunner.TransactionCallable<Void>(){

                @Override
                public Void run(TransactionContext transaction) throws Exception {
                    transaction.buffer(mutations);
                    return null;
                }
            });
        }
        catch (Throwable e) {
            this.state = UnitOfWork.UnitOfWorkState.COMMIT_FAILED;
            throw e;
        }
        this.state = UnitOfWork.UnitOfWorkState.COMMITTED;
    }

    @Override
    public void commit() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Commit is not supported for single-use transactions");
    }

    @Override
    public void rollback() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Rollback is not supported for single-use transactions");
    }

    @Override
    public long[] runBatch() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Run batch is not supported for single-use transactions");
    }

    @Override
    public void abortBatch() {
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "Run batch is not supported for single-use transactions");
    }

    private final class TransactionalBatchUpdateCallable
    extends AbstractUpdateCallable<long[]> {
        private final List<Statement> updates;

        private TransactionalBatchUpdateCallable(Iterable<StatementParser.ParsedStatement> updates) {
            this.updates = new LinkedList<Statement>();
            for (StatementParser.ParsedStatement update : updates) {
                this.updates.add(update.getStatement());
            }
        }

        @Override
        long[] executeUpdate(TransactionContext txContext) {
            return txContext.batchUpdate(this.updates);
        }
    }

    private final class TransactionalUpdateCallable
    extends AbstractUpdateCallable<Long> {
        private final StatementParser.ParsedStatement update;

        private TransactionalUpdateCallable(StatementParser.ParsedStatement update) {
            this.update = update;
        }

        @Override
        Long executeUpdate(TransactionContext txContext) {
            return txContext.executeUpdate(this.update.getStatement());
        }
    }

    private abstract class AbstractUpdateCallable<T>
    implements Callable<T> {
        private AbstractUpdateCallable() {
        }

        abstract T executeUpdate(TransactionContext var1);

        /*
         * Loose catch block
         */
        @Override
        public T call() throws Exception {
            try {
                T t;
                SingleUseTransaction.this.txManager = SingleUseTransaction.this.dbClient.transactionManager();
                SingleUseTransaction.this.checkInterrupted();
                try (TransactionContext txContext = SingleUseTransaction.this.txManager.begin();){
                    SingleUseTransaction.this.checkInterrupted();
                    T res = this.executeUpdate(txContext);
                    SingleUseTransaction.this.checkInterrupted();
                    SingleUseTransaction.this.txManager.commit();
                    SingleUseTransaction.this.checkInterrupted();
                    t = res;
                }
                return t;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (SingleUseTransaction.this.txManager != null) {
                    SingleUseTransaction.this.txManager.close();
                }
            }
        }
    }

    static class Builder
    extends AbstractBaseUnitOfWork.Builder<Builder, SingleUseTransaction> {
        private DdlClient ddlClient;
        private DatabaseClient dbClient;
        private boolean readOnly;
        private TimestampBound readOnlyStaleness;
        private AutocommitDmlMode autocommitDmlMode;

        private Builder() {
        }

        Builder setDdlClient(DdlClient ddlClient) {
            Preconditions.checkNotNull((Object)ddlClient);
            this.ddlClient = ddlClient;
            return this;
        }

        Builder setDatabaseClient(DatabaseClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbClient = client;
            return this;
        }

        Builder setReadOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        Builder setReadOnlyStaleness(TimestampBound staleness) {
            Preconditions.checkNotNull((Object)staleness);
            this.readOnlyStaleness = staleness;
            return this;
        }

        Builder setAutocommitDmlMode(AutocommitDmlMode dmlMode) {
            Preconditions.checkNotNull((Object)((Object)dmlMode));
            this.autocommitDmlMode = dmlMode;
            return this;
        }

        @Override
        SingleUseTransaction build() {
            Preconditions.checkState((this.ddlClient != null ? 1 : 0) != 0, (Object)"No DDL client specified");
            Preconditions.checkState((this.dbClient != null ? 1 : 0) != 0, (Object)"No DatabaseClient client specified");
            Preconditions.checkState((this.readOnlyStaleness != null ? 1 : 0) != 0, (Object)"No read-only staleness specified");
            Preconditions.checkState((this.autocommitDmlMode != null ? 1 : 0) != 0, (Object)"No autocommit dml mode specified");
            return new SingleUseTransaction(this);
        }
    }
}

