/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

abstract class AbstractBaseUnitOfWork
implements UnitOfWork {
    private final StatementExecutor statementExecutor;
    private final StatementExecutor.StatementTimeout statementTimeout;
    @GuardedBy(value="this")
    private Future<?> currentlyRunningStatementFuture = null;

    AbstractBaseUnitOfWork(Builder<?, ?> builder) {
        Preconditions.checkState((((Builder)builder).statementExecutor != null ? 1 : 0) != 0, (Object)"No statement executor specified");
        this.statementExecutor = ((Builder)builder).statementExecutor;
        this.statementTimeout = ((Builder)builder).statementTimeout;
    }

    StatementExecutor getStatementExecutor() {
        return this.statementExecutor;
    }

    StatementExecutor.StatementTimeout getStatementTimeout() {
        return this.statementTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        AbstractBaseUnitOfWork abstractBaseUnitOfWork = this;
        synchronized (abstractBaseUnitOfWork) {
            if (this.currentlyRunningStatementFuture != null && !this.currentlyRunningStatementFuture.isDone() && !this.currentlyRunningStatementFuture.isCancelled()) {
                this.currentlyRunningStatementFuture.cancel(true);
            }
        }
    }

    <T> T asyncExecuteStatement(StatementParser.ParsedStatement statement, Callable<T> callable) {
        return this.asyncExecuteStatement(statement, callable, InterceptorsUsage.INVOKE_INTERCEPTORS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T asyncExecuteStatement(StatementParser.ParsedStatement statement, Callable<T> callable, InterceptorsUsage interceptorUsage) {
        T res;
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkNotNull(callable);
        if (interceptorUsage == InterceptorsUsage.INVOKE_INTERCEPTORS) {
            this.statementExecutor.invokeInterceptors(statement, StatementExecutionStep.EXECUTE_STATEMENT, this);
        }
        Future<T> future = this.statementExecutor.submit(callable);
        AbstractBaseUnitOfWork abstractBaseUnitOfWork = this;
        synchronized (abstractBaseUnitOfWork) {
            this.currentlyRunningStatementFuture = future;
        }
        try {
            if (this.statementTimeout.hasTimeout()) {
                Object unit = this.statementTimeout.getAppropriateTimeUnit();
                res = future.get(this.statementTimeout.getTimeoutValue((TimeUnit)((Object)unit)), (TimeUnit)((Object)unit));
            } else {
                res = future.get();
            }
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.DEADLINE_EXCEEDED, "Statement execution timeout occurred for " + statement.getSqlWithoutComments(), e);
        }
        catch (ExecutionException e) {
            HashSet<Throwable> causes = new HashSet<Throwable>();
            for (Throwable cause = e.getCause(); cause != null && !causes.contains(cause); cause = cause.getCause()) {
                if (cause instanceof SpannerException) {
                    throw (SpannerException)((Object)cause);
                }
                causes.add(cause);
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.UNKNOWN, "Statement execution failed for " + statement.getSqlWithoutComments(), e);
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "Statement execution was interrupted", e);
        }
        catch (CancellationException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "Statement execution was cancelled", e);
        }
        finally {
            AbstractBaseUnitOfWork abstractBaseUnitOfWork2 = this;
            synchronized (abstractBaseUnitOfWork2) {
                this.currentlyRunningStatementFuture = null;
            }
        }
        return res;
    }

    static abstract class Builder<B extends Builder<?, T>, T extends AbstractBaseUnitOfWork> {
        private StatementExecutor statementExecutor;
        private StatementExecutor.StatementTimeout statementTimeout = new StatementExecutor.StatementTimeout();

        Builder() {
        }

        B self() {
            return (B)this;
        }

        B withStatementExecutor(StatementExecutor executor) {
            Preconditions.checkNotNull((Object)executor);
            this.statementExecutor = executor;
            return this.self();
        }

        B setStatementTimeout(StatementExecutor.StatementTimeout timeout) {
            Preconditions.checkNotNull((Object)timeout);
            this.statementTimeout = timeout;
            return this.self();
        }

        abstract T build();
    }

    static enum InterceptorsUsage {
        INVOKE_INTERCEPTORS,
        IGNORE_INTERCEPTORS;

    }
}

