/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.StatementParser;

@InternalApi
interface UnitOfWork {
    public void cancel();

    public Type getType();

    public UnitOfWorkState getState();

    public boolean isActive();

    public void commit();

    public void rollback();

    public long[] runBatch();

    public void abortBatch();

    public boolean isReadOnly();

    public ResultSet executeQuery(StatementParser.ParsedStatement var1, AnalyzeMode var2, Options.QueryOption ... var3);

    public Timestamp getReadTimestamp();

    public Timestamp getReadTimestampOrNull();

    public Timestamp getCommitTimestamp();

    public Timestamp getCommitTimestampOrNull();

    public void executeDdl(StatementParser.ParsedStatement var1);

    public long executeUpdate(StatementParser.ParsedStatement var1);

    public long[] executeBatchUpdate(Iterable<StatementParser.ParsedStatement> var1);

    public void write(Mutation var1);

    public void write(Iterable<Mutation> var1);

    public static enum UnitOfWorkState {
        STARTED,
        COMMITTED,
        COMMIT_FAILED,
        ROLLED_BACK,
        RAN,
        RUN_FAILED,
        ABORTED;


        public boolean isActive() {
            return this == STARTED;
        }
    }

    public static enum Type {
        TRANSACTION,
        BATCH;

    }
}

