/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.StatementExecutionInterceptor;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class StatementExecutor {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("connection-executor-%d").setThreadFactory(MoreExecutors.platformThreadFactory()).build();
    private ExecutorService executor = StatementExecutor.createExecutorService();
    private final List<StatementExecutionInterceptor> interceptors;

    private static ExecutorService createExecutorService() {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), THREAD_FACTORY);
    }

    @VisibleForTesting
    StatementExecutor() {
        this.interceptors = Collections.emptyList();
    }

    StatementExecutor(List<StatementExecutionInterceptor> interceptors) {
        this.interceptors = Collections.unmodifiableList(interceptors);
    }

    void recreate() {
        this.executor.shutdown();
        this.executor = StatementExecutor.createExecutorService();
    }

    List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    <T> Future<T> submit(Callable<T> callable) {
        return this.executor.submit(callable);
    }

    void invokeInterceptors(StatementParser.ParsedStatement statement, StatementExecutionStep step, UnitOfWork transaction) {
        for (StatementExecutionInterceptor interceptor : this.interceptors) {
            interceptor.intercept(statement, step, transaction);
        }
    }

    static class StatementTimeout {
        private Duration duration = null;

        StatementTimeout() {
        }

        static boolean isValidTimeoutUnit(TimeUnit unit) {
            return unit == TimeUnit.NANOSECONDS || unit == TimeUnit.MICROSECONDS || unit == TimeUnit.MILLISECONDS || unit == TimeUnit.SECONDS;
        }

        @VisibleForTesting
        static StatementTimeout nullTimeout() {
            return new StatementTimeout();
        }

        @VisibleForTesting
        static StatementTimeout of(long timeout, TimeUnit unit) {
            Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)StatementTimeout.isValidTimeoutUnit(unit));
            StatementTimeout res = new StatementTimeout();
            res.duration = ReadOnlyStalenessUtil.createDuration(timeout, unit);
            return res;
        }

        boolean hasTimeout() {
            return this.duration != null;
        }

        void clearTimeoutValue() {
            this.duration = null;
        }

        void setTimeoutValue(long timeout, TimeUnit unit) {
            Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)StatementTimeout.isValidTimeoutUnit(unit));
            this.duration = ReadOnlyStalenessUtil.createDuration(timeout, unit);
        }

        long getTimeoutValue(TimeUnit unit) {
            Preconditions.checkArgument((boolean)StatementTimeout.isValidTimeoutUnit(unit));
            return this.duration == null ? 0L : ReadOnlyStalenessUtil.durationToUnits(this.duration, unit);
        }

        TimeUnit getAppropriateTimeUnit() {
            ConnectionPreconditions.checkState(this.duration != null, "This StatementTimeout has no timeout value");
            return ReadOnlyStalenessUtil.getAppropriateTimeUnit(new ReadOnlyStalenessUtil.DurationValueGetter(){

                @Override
                public long getDuration(TimeUnit unit) {
                    return StatementTimeout.this.getTimeoutValue(unit);
                }

                @Override
                public boolean hasDuration() {
                    return StatementTimeout.this.hasTimeout();
                }
            });
        }
    }
}

