/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiAsyncFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.AsyncTransactionManagerImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionContextFutureImpl;
import com.google.cloud.spanner.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

class SessionPoolAsyncTransactionManager
implements TransactionContextFutureImpl.CommittableAsyncTransactionManager {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private TransactionManager.TransactionState txnState;
    private volatile SessionPool.PooledSessionFuture session;
    private final SettableApiFuture<AsyncTransactionManagerImpl> delegate = SettableApiFuture.create();

    SessionPoolAsyncTransactionManager(SessionPool.PooledSessionFuture session) {
        this.session = session;
        this.session.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    SessionPoolAsyncTransactionManager.this.delegate.set((Object)SessionPoolAsyncTransactionManager.this.session.get().transactionManagerAsync());
                }
                catch (Throwable t) {
                    SessionPoolAsyncTransactionManager.this.delegate.setException(t);
                }
            }
        }, MoreExecutors.directExecutor());
    }

    @Override
    public void close() {
        this.delegate.addListener(new Runnable(){

            @Override
            public void run() {
                SessionPoolAsyncTransactionManager.this.session.close();
            }
        }, MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncTransactionManager.TransactionContextFuture beginAsync() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.txnState == null ? 1 : 0) != 0, (Object)"begin can only be called once");
            this.txnState = TransactionManager.TransactionState.STARTED;
        }
        final SettableApiFuture delegateTxnFuture = SettableApiFuture.create();
        ApiFutures.addCallback(this.delegate, (ApiFutureCallback)new ApiFutureCallback<AsyncTransactionManagerImpl>(){

            public void onFailure(Throwable t) {
                delegateTxnFuture.setException(t);
            }

            public void onSuccess(AsyncTransactionManagerImpl result) {
                ApiFutures.addCallback((ApiFuture)result.beginAsync(), (ApiFutureCallback)new ApiFutureCallback<TransactionContext>(){

                    public void onFailure(Throwable t) {
                        delegateTxnFuture.setException(t);
                    }

                    public void onSuccess(TransactionContext result) {
                        delegateTxnFuture.set((Object)result);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            }
        }, (Executor)MoreExecutors.directExecutor());
        return new TransactionContextFutureImpl(this, (ApiFuture<TransactionContext>)delegateTxnFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable t) {
        if (t instanceof AbortedException) {
            Object object = this.lock;
            synchronized (object) {
                this.txnState = TransactionManager.TransactionState.ABORTED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<Timestamp> commitAsync() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.txnState == TransactionManager.TransactionState.STARTED ? 1 : 0) != 0, (Object)("commit can only be invoked if the transaction is in progress. Current state: " + (Object)((Object)this.txnState)));
            this.txnState = TransactionManager.TransactionState.COMMITTED;
        }
        return ApiFutures.transformAsync(this.delegate, (ApiAsyncFunction)new ApiAsyncFunction<AsyncTransactionManagerImpl, Timestamp>(){

            public ApiFuture<Timestamp> apply(AsyncTransactionManagerImpl input) throws Exception {
                final SettableApiFuture res = SettableApiFuture.create();
                ApiFutures.addCallback(input.commitAsync(), (ApiFutureCallback)new ApiFutureCallback<Timestamp>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onFailure(Throwable t) {
                        Object object = SessionPoolAsyncTransactionManager.this.lock;
                        synchronized (object) {
                            if (t instanceof AbortedException) {
                                SessionPoolAsyncTransactionManager.this.txnState = TransactionManager.TransactionState.ABORTED;
                            } else {
                                SessionPoolAsyncTransactionManager.this.txnState = TransactionManager.TransactionState.COMMIT_FAILED;
                            }
                        }
                        res.setException(t);
                    }

                    public void onSuccess(Timestamp result) {
                        res.set((Object)result);
                    }
                }, (Executor)MoreExecutors.directExecutor());
                return res;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<Void> rollbackAsync() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.txnState == TransactionManager.TransactionState.STARTED ? 1 : 0) != 0, (Object)"rollback can only be called if the transaction is in progress");
            this.txnState = TransactionManager.TransactionState.ROLLED_BACK;
        }
        return ApiFutures.transformAsync(this.delegate, (ApiAsyncFunction)new ApiAsyncFunction<AsyncTransactionManagerImpl, Void>(){

            public ApiFuture<Void> apply(AsyncTransactionManagerImpl input) throws Exception {
                ApiFuture<Void> res = input.rollbackAsync();
                res.addListener(new Runnable(){

                    @Override
                    public void run() {
                        SessionPoolAsyncTransactionManager.this.session.close();
                    }
                }, MoreExecutors.directExecutor());
                return res;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncTransactionManager.TransactionContextFuture resetForRetryAsync() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState((this.txnState == TransactionManager.TransactionState.ABORTED ? 1 : 0) != 0, (Object)"resetForRetry can only be called after the transaction aborted.");
            this.txnState = TransactionManager.TransactionState.STARTED;
        }
        return new TransactionContextFutureImpl(this, (ApiFuture<TransactionContext>)ApiFutures.transformAsync(this.delegate, (ApiAsyncFunction)new ApiAsyncFunction<AsyncTransactionManagerImpl, TransactionContext>(){

            public ApiFuture<TransactionContext> apply(AsyncTransactionManagerImpl input) throws Exception {
                return input.resetForRetryAsync();
            }
        }, (Executor)MoreExecutors.directExecutor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionManager.TransactionState getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.txnState;
        }
    }
}

