/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.database.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminSettings;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStub;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DatabaseName;
import com.google.spanner.admin.database.v1.DropDatabaseRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.GetDatabaseRequest;
import com.google.spanner.admin.database.v1.InstanceName;
import com.google.spanner.admin.database.v1.ListDatabasesRequest;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DatabaseAdminClient
implements BackgroundResource {
    private final DatabaseAdminSettings settings;
    private final DatabaseAdminStub stub;
    private final OperationsClient operationsClient;

    public static final DatabaseAdminClient create() throws IOException {
        return DatabaseAdminClient.create(DatabaseAdminSettings.newBuilder().build());
    }

    public static final DatabaseAdminClient create(DatabaseAdminSettings settings) throws IOException {
        return new DatabaseAdminClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DatabaseAdminClient create(DatabaseAdminStub stub) {
        return new DatabaseAdminClient(stub);
    }

    protected DatabaseAdminClient(DatabaseAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DatabaseAdminStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DatabaseAdminClient(DatabaseAdminStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DatabaseAdminSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DatabaseAdminStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Database, CreateDatabaseMetadata> createDatabaseAsync(InstanceName parent, String createStatement) {
        CreateDatabaseRequest request = CreateDatabaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCreateStatement(createStatement).build();
        return this.createDatabaseAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Database, CreateDatabaseMetadata> createDatabaseAsync(String parent, String createStatement) {
        CreateDatabaseRequest request = CreateDatabaseRequest.newBuilder().setParent(parent).setCreateStatement(createStatement).build();
        return this.createDatabaseAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Database, CreateDatabaseMetadata> createDatabaseAsync(CreateDatabaseRequest request) {
        return this.createDatabaseOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateDatabaseRequest, Database, CreateDatabaseMetadata> createDatabaseOperationCallable() {
        return this.stub.createDatabaseOperationCallable();
    }

    public final UnaryCallable<CreateDatabaseRequest, Operation> createDatabaseCallable() {
        return this.stub.createDatabaseCallable();
    }

    public final Database getDatabase(DatabaseName name) {
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDatabase(request);
    }

    public final Database getDatabase(String name) {
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(name).build();
        return this.getDatabase(request);
    }

    public final Database getDatabase(GetDatabaseRequest request) {
        return (Database)this.getDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatabaseRequest, Database> getDatabaseCallable() {
        return this.stub.getDatabaseCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlAsync(DatabaseName database, List<String> statements) {
        UpdateDatabaseDdlRequest request = UpdateDatabaseDdlRequest.newBuilder().setDatabase(database == null ? null : database.toString()).addAllStatements(statements).build();
        return this.updateDatabaseDdlAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlAsync(String database, List<String> statements) {
        UpdateDatabaseDdlRequest request = UpdateDatabaseDdlRequest.newBuilder().setDatabase(database).addAllStatements(statements).build();
        return this.updateDatabaseDdlAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlAsync(UpdateDatabaseDdlRequest request) {
        return this.updateDatabaseDdlOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdlOperationCallable() {
        return this.stub.updateDatabaseDdlOperationCallable();
    }

    public final UnaryCallable<UpdateDatabaseDdlRequest, Operation> updateDatabaseDdlCallable() {
        return this.stub.updateDatabaseDdlCallable();
    }

    public final void dropDatabase(DatabaseName database) {
        DropDatabaseRequest request = DropDatabaseRequest.newBuilder().setDatabase(database == null ? null : database.toString()).build();
        this.dropDatabase(request);
    }

    public final void dropDatabase(String database) {
        DropDatabaseRequest request = DropDatabaseRequest.newBuilder().setDatabase(database).build();
        this.dropDatabase(request);
    }

    public final void dropDatabase(DropDatabaseRequest request) {
        this.dropDatabaseCallable().call((Object)request);
    }

    public final UnaryCallable<DropDatabaseRequest, Empty> dropDatabaseCallable() {
        return this.stub.dropDatabaseCallable();
    }

    public final GetDatabaseDdlResponse getDatabaseDdl(DatabaseName database) {
        GetDatabaseDdlRequest request = GetDatabaseDdlRequest.newBuilder().setDatabase(database == null ? null : database.toString()).build();
        return this.getDatabaseDdl(request);
    }

    public final GetDatabaseDdlResponse getDatabaseDdl(String database) {
        GetDatabaseDdlRequest request = GetDatabaseDdlRequest.newBuilder().setDatabase(database).build();
        return this.getDatabaseDdl(request);
    }

    public final GetDatabaseDdlResponse getDatabaseDdl(GetDatabaseDdlRequest request) {
        return (GetDatabaseDdlResponse)this.getDatabaseDdlCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatabaseDdlRequest, GetDatabaseDdlResponse> getDatabaseDdlCallable() {
        return this.stub.getDatabaseDdlCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final ListDatabasesPagedResponse listDatabases(InstanceName parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesPagedResponse listDatabases(String parent) {
        ListDatabasesRequest request = ListDatabasesRequest.newBuilder().setParent(parent).build();
        return this.listDatabases(request);
    }

    public final ListDatabasesPagedResponse listDatabases(ListDatabasesRequest request) {
        return (ListDatabasesPagedResponse)((Object)this.listDatabasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatabasesRequest, ListDatabasesPagedResponse> listDatabasesPagedCallable() {
        return this.stub.listDatabasesPagedCallable();
    }

    public final UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> listDatabasesCallable() {
        return this.stub.listDatabasesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDatabasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage, ListDatabasesFixedSizeCollection> {
        private ListDatabasesFixedSizeCollection(List<ListDatabasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatabasesFixedSizeCollection createEmptyCollection() {
            return new ListDatabasesFixedSizeCollection(null, 0);
        }

        protected ListDatabasesFixedSizeCollection createCollection(List<ListDatabasesPage> pages, int collectionSize) {
            return new ListDatabasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatabasesPage
    extends AbstractPage<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage> {
        private ListDatabasesPage(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ListDatabasesResponse response) {
            super(context, (Object)response);
        }

        private static ListDatabasesPage createEmptyPage() {
            return new ListDatabasesPage(null, null);
        }

        protected ListDatabasesPage createPage(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ListDatabasesResponse response) {
            return new ListDatabasesPage(context, response);
        }

        public ApiFuture<ListDatabasesPage> createPageAsync(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ApiFuture<ListDatabasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatabasesPagedResponse
    extends AbstractPagedListResponse<ListDatabasesRequest, ListDatabasesResponse, Database, ListDatabasesPage, ListDatabasesFixedSizeCollection> {
        public static ApiFuture<ListDatabasesPagedResponse> createAsync(PageContext<ListDatabasesRequest, ListDatabasesResponse, Database> context, ApiFuture<ListDatabasesResponse> futureResponse) {
            ApiFuture<ListDatabasesPage> futurePage = ListDatabasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListDatabasesPage, ListDatabasesPagedResponse>(){

                public ListDatabasesPagedResponse apply(ListDatabasesPage input) {
                    return new ListDatabasesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListDatabasesPagedResponse(ListDatabasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatabasesFixedSizeCollection.createEmptyCollection());
        }
    }
}

