/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.gax.paging.Page;
import com.google.cloud.BaseService;
import com.google.cloud.PageImpl;
import com.google.cloud.ServiceOptions;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchClientImpl;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseAdminClientImpl;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.InstanceAdminClient;
import com.google.cloud.spanner.InstanceAdminClientImpl;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Context;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class SpannerImpl
extends BaseService<SpannerOptions>
implements Spanner {
    private static final int MIN_BACKOFF_MS = 1000;
    private static final int MAX_BACKOFF_MS = 32000;
    private static final Logger logger = Logger.getLogger(SpannerImpl.class.getName());
    static final Tracer tracer = Tracing.getTracer();
    static final String CREATE_SESSION = "CloudSpannerOperation.CreateSession";
    static final String BATCH_CREATE_SESSIONS = "CloudSpannerOperation.BatchCreateSessions";
    static final String BATCH_CREATE_SESSIONS_REQUEST = "CloudSpannerOperation.BatchCreateSessionsRequest";
    static final String DELETE_SESSION = "CloudSpannerOperation.DeleteSession";
    static final String BEGIN_TRANSACTION = "CloudSpannerOperation.BeginTransaction";
    static final String COMMIT = "CloudSpannerOperation.Commit";
    static final String QUERY = "CloudSpannerOperation.ExecuteStreamingQuery";
    static final String READ = "CloudSpannerOperation.ExecuteStreamingRead";
    private final SpannerRpc gapicRpc;
    @GuardedBy(value="this")
    private final Map<DatabaseId, DatabaseClientImpl> dbClients = new HashMap<DatabaseId, DatabaseClientImpl>();
    @GuardedBy(value="this")
    private final List<DatabaseClientImpl> invalidatedDbClients = new ArrayList<DatabaseClientImpl>();
    @GuardedBy(value="this")
    private final Map<DatabaseId, SessionClient> sessionClients = new HashMap<DatabaseId, SessionClient>();
    private final DatabaseAdminClient dbAdminClient;
    private final InstanceAdminClient instanceClient;
    @GuardedBy(value="this")
    private boolean spannerIsClosed = false;

    @VisibleForTesting
    SpannerImpl(SpannerRpc gapicRpc, SpannerOptions options) {
        super((ServiceOptions)options);
        this.gapicRpc = gapicRpc;
        this.dbAdminClient = new DatabaseAdminClientImpl(options.getProjectId(), gapicRpc);
        this.instanceClient = new InstanceAdminClientImpl(options.getProjectId(), gapicRpc, this.dbAdminClient);
    }

    SpannerImpl(SpannerOptions options) {
        this(options.getSpannerRpcV1(), options);
    }

    static ExponentialBackOff newBackOff() {
        return new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setMaxIntervalMillis(32000).setMaxElapsedTimeMillis(Integer.MAX_VALUE).build();
    }

    static void backoffSleep(Context context, BackOff backoff) throws SpannerException {
        SpannerImpl.backoffSleep(context, SpannerImpl.nextBackOffMillis(backoff));
    }

    static long nextBackOffMillis(BackOff backoff) throws SpannerException {
        try {
            return backoff.nextBackOffMillis();
        }
        catch (IOException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, e.getMessage(), e);
        }
    }

    static void backoffSleep(Context context, long backoffMillis) throws SpannerException {
        tracer.getCurrentSpan().addAnnotation("Backing off", (Map)ImmutableMap.of((Object)"Delay", (Object)AttributeValue.longAttributeValue((long)backoffMillis)));
        final CountDownLatch latch = new CountDownLatch(1);
        Context.CancellationListener listener = new Context.CancellationListener(){

            public void cancelled(Context context) {
                latch.countDown();
            }
        };
        context.addListener(listener, (Executor)DirectExecutor.INSTANCE);
        try {
            if (backoffMillis == -1L) {
                backoffMillis = 32000L;
            }
            if (latch.await(backoffMillis, TimeUnit.MILLISECONDS)) {
                throw SpannerExceptionFactory.newSpannerExceptionForCancellation(context, null);
            }
        }
        catch (InterruptedException interruptExcept) {
            throw SpannerExceptionFactory.newSpannerExceptionForCancellation(context, interruptExcept);
        }
        finally {
            context.removeListener(listener);
        }
    }

    SpannerRpc getRpc() {
        return this.gapicRpc;
    }

    int getDefaultPrefetchChunks() {
        return ((SpannerOptions)this.getOptions()).getPrefetchChunks();
    }

    SessionImpl sessionWithId(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        SessionClient.SessionId id = SessionClient.SessionId.of(name);
        return this.getSessionClient(id.getDatabaseId()).sessionWithId(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SessionClient getSessionClient(DatabaseId db) {
        SpannerImpl spannerImpl = this;
        synchronized (spannerImpl) {
            Preconditions.checkState((!this.spannerIsClosed ? 1 : 0) != 0, (Object)"Cloud Spanner client has been closed");
            if (this.sessionClients.containsKey(db)) {
                return this.sessionClients.get(db);
            }
            SessionClient client = new SessionClient(this, db, (GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService>)((GrpcTransportOptions)((SpannerOptions)this.getOptions()).getTransportOptions()).getExecutorFactory());
            this.sessionClients.put(db, client);
            return client;
        }
    }

    @Override
    public DatabaseAdminClient getDatabaseAdminClient() {
        return this.dbAdminClient;
    }

    @Override
    public InstanceAdminClient getInstanceAdminClient() {
        return this.instanceClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseClient getDatabaseClient(DatabaseId db) {
        SpannerImpl spannerImpl = this;
        synchronized (spannerImpl) {
            Preconditions.checkState((!this.spannerIsClosed ? 1 : 0) != 0, (Object)"Cloud Spanner client has been closed");
            if (this.dbClients.containsKey(db) && !this.dbClients.get((Object)db).pool.isValid()) {
                this.invalidatedDbClients.add(this.dbClients.get(db));
                this.dbClients.remove(db);
            }
            if (this.dbClients.containsKey(db)) {
                return this.dbClients.get(db);
            }
            SessionPool pool = SessionPool.createPool((SpannerOptions)this.getOptions(), this.getSessionClient(db));
            DatabaseClientImpl dbClient = this.createDatabaseClient(pool);
            this.dbClients.put(db, dbClient);
            return dbClient;
        }
    }

    @VisibleForTesting
    DatabaseClientImpl createDatabaseClient(SessionPool pool) {
        return new DatabaseClientImpl(pool);
    }

    @Override
    public BatchClient getBatchClient(DatabaseId db) {
        return new BatchClientImpl(this.getSessionClient(db));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<ListenableFuture<Void>> closureFutures = null;
        SpannerImpl spannerImpl = this;
        synchronized (spannerImpl) {
            Preconditions.checkState((!this.spannerIsClosed ? 1 : 0) != 0, (Object)"Cloud Spanner client has been closed");
            this.spannerIsClosed = true;
            closureFutures = new ArrayList<ListenableFuture<Void>>();
            this.invalidatedDbClients.addAll(this.dbClients.values());
            for (DatabaseClientImpl dbClient : this.invalidatedDbClients) {
                closureFutures.add(dbClient.closeAsync());
            }
            this.dbClients.clear();
        }
        try {
            Futures.successfulAsList(closureFutures).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
        for (SessionClient sessionClient : this.sessionClients.values()) {
            sessionClient.close();
        }
        this.sessionClients.clear();
        try {
            this.gapicRpc.shutdown();
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Failed to close channels", e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.spannerIsClosed;
    }

    private static enum DirectExecutor implements Executor
    {
        INSTANCE;


        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    static abstract class PageFetcher<S, T>
    implements PageImpl.NextPageFetcher<S> {
        private String nextPageToken;

        PageFetcher() {
        }

        public Page<S> getNextPage() {
            SpannerRpc.Paginated<T> nextPage = this.getNextPage(this.nextPageToken);
            this.nextPageToken = nextPage.getNextPageToken();
            ArrayList<S> results = new ArrayList<S>();
            for (T proto : nextPage.getResults()) {
                results.add(this.fromProto(proto));
            }
            return new PageImpl((PageImpl.NextPageFetcher)this, this.nextPageToken, results);
        }

        void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        abstract SpannerRpc.Paginated<T> getNextPage(@Nullable String var1);

        abstract S fromProto(T var1);
    }
}

