/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationFutureImpl;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.paging.Page;
import com.google.cloud.Policy;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.protobuf.Empty;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

class DatabaseAdminClientImpl
implements DatabaseAdminClient {
    private final String projectId;
    private final SpannerRpc rpc;
    private final PolicyMarshaller policyMarshaller = new PolicyMarshaller();

    DatabaseAdminClientImpl(String projectId, SpannerRpc rpc) {
        this.projectId = projectId;
        this.rpc = rpc;
    }

    private static String randomOperationId() {
        UUID uuid = UUID.randomUUID();
        return ("r" + uuid.toString()).replace("-", "_");
    }

    @Override
    public OperationFuture<Database, CreateDatabaseMetadata> createDatabase(String instanceId, String databaseId, Iterable<String> statements) throws SpannerException {
        String instanceName = this.getInstanceName(instanceId);
        String createStatement = "CREATE DATABASE `" + databaseId + "`";
        OperationFuture<com.google.spanner.admin.database.v1.Database, CreateDatabaseMetadata> rawOperationFuture = this.rpc.createDatabase(instanceName, createStatement, statements);
        return new OperationFutureImpl(rawOperationFuture.getPollingFuture(), rawOperationFuture.getInitialFuture(), (ApiFunction)new ApiFunction<OperationSnapshot, Database>(){

            public Database apply(OperationSnapshot snapshot) {
                return Database.fromProto((com.google.spanner.admin.database.v1.Database)ProtoOperationTransformers.ResponseTransformer.create(com.google.spanner.admin.database.v1.Database.class).apply(snapshot), DatabaseAdminClientImpl.this);
            }
        }, (ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateDatabaseMetadata.class), (ApiFunction)new ApiFunction<Exception, Database>(){

            public Database apply(Exception e) {
                throw SpannerExceptionFactory.newSpannerException(e);
            }
        });
    }

    @Override
    public Database getDatabase(String instanceId, String databaseId) throws SpannerException {
        String dbName = this.getDatabaseName(instanceId, databaseId);
        return Database.fromProto(this.rpc.getDatabase(dbName), this);
    }

    @Override
    public OperationFuture<Void, UpdateDatabaseDdlMetadata> updateDatabaseDdl(String instanceId, String databaseId, Iterable<String> statements, @Nullable String operationId) throws SpannerException {
        String dbName = this.getDatabaseName(instanceId, databaseId);
        String opId = operationId != null ? operationId : DatabaseAdminClientImpl.randomOperationId();
        OperationFuture<Empty, UpdateDatabaseDdlMetadata> rawOperationFuture = this.rpc.updateDatabaseDdl(dbName, statements, opId);
        return new OperationFutureImpl(rawOperationFuture.getPollingFuture(), rawOperationFuture.getInitialFuture(), (ApiFunction)new ApiFunction<OperationSnapshot, Void>(){

            public Void apply(OperationSnapshot snapshot) {
                ProtoOperationTransformers.ResponseTransformer.create(Empty.class).apply(snapshot);
                return null;
            }
        }, (ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateDatabaseDdlMetadata.class), (ApiFunction)new ApiFunction<Exception, Void>(){

            public Void apply(Exception e) {
                throw SpannerExceptionFactory.newSpannerException(e);
            }
        });
    }

    @Override
    public void dropDatabase(String instanceId, String databaseId) throws SpannerException {
        String dbName = this.getDatabaseName(instanceId, databaseId);
        this.rpc.dropDatabase(dbName);
    }

    @Override
    public List<String> getDatabaseDdl(String instanceId, String databaseId) {
        String dbName = this.getDatabaseName(instanceId, databaseId);
        return this.rpc.getDatabaseDdl(dbName);
    }

    @Override
    public Page<Database> listDatabases(String instanceId, Options.ListOption ... options) {
        final String instanceName = this.getInstanceName(instanceId);
        Options listOptions = Options.fromListOptions(options);
        Preconditions.checkArgument((!listOptions.hasFilter() ? 1 : 0) != 0, (Object)"Filter option is not support bylistDatabases");
        final int pageSize = listOptions.hasPageSize() ? listOptions.pageSize() : 0;
        SpannerImpl.PageFetcher<Database, com.google.spanner.admin.database.v1.Database> pageFetcher = new SpannerImpl.PageFetcher<Database, com.google.spanner.admin.database.v1.Database>(){

            @Override
            public SpannerRpc.Paginated<com.google.spanner.admin.database.v1.Database> getNextPage(String nextPageToken) {
                return DatabaseAdminClientImpl.this.rpc.listDatabases(instanceName, pageSize, nextPageToken);
            }

            @Override
            public Database fromProto(com.google.spanner.admin.database.v1.Database proto) {
                return Database.fromProto(proto, DatabaseAdminClientImpl.this);
            }
        };
        if (listOptions.hasPageToken()) {
            pageFetcher.setNextPageToken(listOptions.pageToken());
        }
        return pageFetcher.getNextPage();
    }

    @Override
    public Policy getDatabaseIAMPolicy(String instanceId, String databaseId) {
        String databaseName = DatabaseId.of(this.projectId, instanceId, databaseId).getName();
        return this.policyMarshaller.fromPb(this.rpc.getDatabaseAdminIAMPolicy(databaseName));
    }

    @Override
    public Policy setDatabaseIAMPolicy(String instanceId, String databaseId, Policy policy) {
        Preconditions.checkNotNull((Object)policy);
        String databaseName = DatabaseId.of(this.projectId, instanceId, databaseId).getName();
        return this.policyMarshaller.fromPb(this.rpc.setDatabaseAdminIAMPolicy(databaseName, this.policyMarshaller.toPb(policy)));
    }

    @Override
    public Iterable<String> testDatabaseIAMPermissions(String instanceId, String databaseId, Iterable<String> permissions) {
        Preconditions.checkNotNull(permissions);
        String databaseName = DatabaseId.of(this.projectId, instanceId, databaseId).getName();
        return this.rpc.testDatabaseAdminIAMPermissions(databaseName, permissions).getPermissionsList();
    }

    private String getInstanceName(String instanceId) {
        return new InstanceId(this.projectId, instanceId).getName();
    }

    private String getDatabaseName(String instanceId, String databaseId) {
        return new DatabaseId(new InstanceId(this.projectId, instanceId), databaseId).getName();
    }

    private static final class PolicyMarshaller
    extends Policy.DefaultMarshaller {
        private PolicyMarshaller() {
        }

        protected Policy fromPb(com.google.iam.v1.Policy policyPb) {
            return super.fromPb(policyPb);
        }

        protected com.google.iam.v1.Policy toPb(Policy policy) {
            return super.toPb(policy);
        }
    }
}

