/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.api.core.NanoClock;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.InstantiatingWatchdogProvider;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.WatchdogProvider;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.ServiceOptions;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStub;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStubSettings;
import com.google.cloud.spanner.admin.database.v1.stub.GrpcDatabaseAdminStub;
import com.google.cloud.spanner.admin.instance.v1.stub.GrpcInstanceAdminStub;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStub;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStubSettings;
import com.google.cloud.spanner.spi.v1.SpannerInterceptorProvider;
import com.google.cloud.spanner.spi.v1.SpannerMetadataProvider;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.cloud.spanner.v1.stub.GrpcSpannerStub;
import com.google.cloud.spanner.v1.stub.SpannerStub;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import com.google.spanner.admin.database.v1.CreateDatabaseRequest;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DropDatabaseRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlRequest;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.GetDatabaseRequest;
import com.google.spanner.admin.database.v1.ListDatabasesRequest;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlRequest;
import com.google.spanner.admin.instance.v1.CreateInstanceMetadata;
import com.google.spanner.admin.instance.v1.CreateInstanceRequest;
import com.google.spanner.admin.instance.v1.DeleteInstanceRequest;
import com.google.spanner.admin.instance.v1.GetInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.GetInstanceRequest;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsResponse;
import com.google.spanner.admin.instance.v1.ListInstancesRequest;
import com.google.spanner.admin.instance.v1.ListInstancesResponse;
import com.google.spanner.admin.instance.v1.UpdateInstanceMetadata;
import com.google.spanner.admin.instance.v1.UpdateInstanceRequest;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BatchCreateSessionsResponse;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.Transaction;
import io.grpc.Context;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public class GapicSpannerRpc
implements SpannerRpc {
    private static final PathTemplate PROJECT_NAME_TEMPLATE = PathTemplate.create((String)"projects/{project}");
    private static final PathTemplate OPERATION_NAME_TEMPLATE = PathTemplate.create((String)"{database=projects/*/instances/*/databases/*}/operations/{operation}");
    private static final int MAX_MESSAGE_SIZE = 0x6400000;
    private static final int MAX_METADATA_SIZE = 32768;
    private static final String PROPERTY_TIMEOUT_SECONDS = "com.google.cloud.spanner.watchdogTimeoutSeconds";
    private static final String PROPERTY_PERIOD_SECONDS = "com.google.cloud.spanner.watchdogPeriodSeconds";
    private static final int DEFAULT_TIMEOUT_SECONDS = 1800;
    private static final int DEFAULT_PERIOD_SECONDS = 10;
    private final ManagedInstantiatingExecutorProvider executorProvider;
    private boolean rpcIsClosed;
    private final SpannerStub spannerStub;
    private final InstanceAdminStub instanceAdminStub;
    private final DatabaseAdminStub databaseAdminStub;
    private final String projectId;
    private final String projectName;
    private final SpannerMetadataProvider metadataProvider;
    private final Duration waitTimeout = GapicSpannerRpc.systemProperty("com.google.cloud.spanner.watchdogTimeoutSeconds", 1800);
    private final Duration idleTimeout = GapicSpannerRpc.systemProperty("com.google.cloud.spanner.watchdogTimeoutSeconds", 1800);
    private final Duration checkInterval = GapicSpannerRpc.systemProperty("com.google.cloud.spanner.watchdogPeriodSeconds", 10);
    private final ScheduledExecutorService spannerWatchdog;

    public static GapicSpannerRpc create(SpannerOptions options) {
        return new GapicSpannerRpc(options);
    }

    public GapicSpannerRpc(SpannerOptions options) {
        this.projectId = options.getProjectId();
        this.projectName = PROJECT_NAME_TEMPLATE.instantiate(new String[]{"project", this.projectId});
        ApiClientHeaderProvider.Builder internalHeaderProviderBuilder = ApiClientHeaderProvider.newBuilder();
        ApiClientHeaderProvider internalHeaderProvider = internalHeaderProviderBuilder.setClientLibToken(options.getClientLibToken(), GaxProperties.getLibraryVersion(((Object)((Object)options)).getClass())).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion()).build();
        HeaderProvider mergedHeaderProvider = options.getMergedHeaderProvider((HeaderProvider)internalHeaderProvider);
        this.metadataProvider = SpannerMetadataProvider.create(mergedHeaderProvider.getHeaders(), internalHeaderProviderBuilder.getResourceHeaderKey());
        this.executorProvider = new ManagedInstantiatingExecutorProvider(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Cloud-Spanner-TransportChannel-%d").build());
        TransportChannelProvider channelProvider = (TransportChannelProvider)MoreObjects.firstNonNull((Object)options.getChannelProvider(), (Object)InstantiatingGrpcChannelProvider.newBuilder().setChannelConfigurator(options.getChannelConfigurator()).setEndpoint(options.getEndpoint()).setMaxInboundMessageSize(Integer.valueOf(0x6400000)).setMaxInboundMetadataSize(Integer.valueOf(32768)).setPoolSize(options.getNumChannels()).setExecutorProvider((ExecutorProvider)this.executorProvider).setInterceptorProvider((GrpcInterceptorProvider)MoreObjects.firstNonNull((Object)options.getInterceptorProvider(), (Object)SpannerInterceptorProvider.createDefault())).setHeaderProvider(mergedHeaderProvider).build());
        CredentialsProvider credentialsProvider = GrpcTransportOptions.setUpCredentialsProvider((ServiceOptions)options);
        this.spannerWatchdog = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Cloud-Spanner-WatchdogProvider-%d").build());
        WatchdogProvider watchdogProvider = InstantiatingWatchdogProvider.create().withExecutor(this.spannerWatchdog).withCheckInterval(this.checkInterval).withClock(NanoClock.getDefaultClock());
        try {
            this.spannerStub = GrpcSpannerStub.create(((SpannerStubSettings.Builder)((SpannerStubSettings.Builder)((SpannerStubSettings.Builder)options.getSpannerStubSettings().toBuilder().setTransportChannelProvider(channelProvider)).setCredentialsProvider(credentialsProvider)).setStreamWatchdogProvider(watchdogProvider)).build());
            this.instanceAdminStub = GrpcInstanceAdminStub.create(((InstanceAdminStubSettings.Builder)((InstanceAdminStubSettings.Builder)((InstanceAdminStubSettings.Builder)options.getInstanceAdminStubSettings().toBuilder().setTransportChannelProvider(channelProvider)).setCredentialsProvider(credentialsProvider)).setStreamWatchdogProvider(watchdogProvider)).build());
            this.databaseAdminStub = GrpcDatabaseAdminStub.create(((DatabaseAdminStubSettings.Builder)((DatabaseAdminStubSettings.Builder)((DatabaseAdminStubSettings.Builder)options.getDatabaseAdminStubSettings().toBuilder().setTransportChannelProvider(channelProvider)).setCredentialsProvider(credentialsProvider)).setStreamWatchdogProvider(watchdogProvider)).build());
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
    }

    @Override
    public SpannerRpc.Paginated<InstanceConfig> listInstanceConfigs(int pageSize, @Nullable String pageToken) throws SpannerException {
        ListInstanceConfigsRequest.Builder requestBuilder = ListInstanceConfigsRequest.newBuilder().setParent(this.projectName).setPageSize(pageSize);
        if (pageToken != null) {
            requestBuilder.setPageToken(pageToken);
        }
        ListInstanceConfigsRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, this.projectName);
        ListInstanceConfigsResponse response = (ListInstanceConfigsResponse)GapicSpannerRpc.get(this.instanceAdminStub.listInstanceConfigsCallable().futureCall((Object)request, (ApiCallContext)context));
        return new SpannerRpc.Paginated<InstanceConfig>(response.getInstanceConfigsList(), response.getNextPageToken());
    }

    @Override
    public InstanceConfig getInstanceConfig(String instanceConfigName) throws SpannerException {
        GetInstanceConfigRequest request = GetInstanceConfigRequest.newBuilder().setName(instanceConfigName).build();
        GrpcCallContext context = this.newCallContext(null, this.projectName);
        return (InstanceConfig)GapicSpannerRpc.get(this.instanceAdminStub.getInstanceConfigCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public SpannerRpc.Paginated<Instance> listInstances(int pageSize, @Nullable String pageToken, @Nullable String filter) throws SpannerException {
        ListInstancesRequest.Builder requestBuilder = ListInstancesRequest.newBuilder().setParent(this.projectName).setPageSize(pageSize);
        if (pageToken != null) {
            requestBuilder.setPageToken(pageToken);
        }
        if (filter != null) {
            requestBuilder.setFilter(filter);
        }
        ListInstancesRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, this.projectName);
        ListInstancesResponse response = (ListInstancesResponse)GapicSpannerRpc.get(this.instanceAdminStub.listInstancesCallable().futureCall((Object)request, (ApiCallContext)context));
        return new SpannerRpc.Paginated<Instance>(response.getInstancesList(), response.getNextPageToken());
    }

    @Override
    public OperationFuture<Instance, CreateInstanceMetadata> createInstance(String parent, String instanceId, Instance instance) throws SpannerException {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstanceId(instanceId).setInstance(instance).build();
        GrpcCallContext context = this.newCallContext(null, parent);
        return this.instanceAdminStub.createInstanceOperationCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public OperationFuture<Instance, UpdateInstanceMetadata> updateInstance(Instance instance, FieldMask fieldMask) throws SpannerException {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setInstance(instance).setFieldMask(fieldMask).build();
        GrpcCallContext context = this.newCallContext(null, instance.getName());
        return this.instanceAdminStub.updateInstanceOperationCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public Instance getInstance(String instanceName) throws SpannerException {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(instanceName).build();
        GrpcCallContext context = this.newCallContext(null, instanceName);
        return (Instance)GapicSpannerRpc.get(this.instanceAdminStub.getInstanceCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public void deleteInstance(String instanceName) throws SpannerException {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(instanceName).build();
        GrpcCallContext context = this.newCallContext(null, instanceName);
        GapicSpannerRpc.get(this.instanceAdminStub.deleteInstanceCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public SpannerRpc.Paginated<Database> listDatabases(String instanceName, int pageSize, @Nullable String pageToken) throws SpannerException {
        ListDatabasesRequest.Builder requestBuilder = ListDatabasesRequest.newBuilder().setParent(instanceName).setPageSize(pageSize);
        if (pageToken != null) {
            requestBuilder.setPageToken(pageToken);
        }
        ListDatabasesRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(null, instanceName);
        ListDatabasesResponse response = (ListDatabasesResponse)GapicSpannerRpc.get(this.databaseAdminStub.listDatabasesCallable().futureCall((Object)request, (ApiCallContext)context));
        return new SpannerRpc.Paginated<Database>(response.getDatabasesList(), response.getNextPageToken());
    }

    @Override
    public OperationFuture<Database, CreateDatabaseMetadata> createDatabase(String instanceName, String createDatabaseStatement, Iterable<String> additionalStatements) throws SpannerException {
        CreateDatabaseRequest request = CreateDatabaseRequest.newBuilder().setParent(instanceName).setCreateStatement(createDatabaseStatement).addAllExtraStatements(additionalStatements).build();
        GrpcCallContext context = this.newCallContext(null, instanceName);
        return this.databaseAdminStub.createDatabaseOperationCallable().futureCall((Object)request, (ApiCallContext)context);
    }

    @Override
    public OperationFuture<Empty, UpdateDatabaseDdlMetadata> updateDatabaseDdl(String databaseName, Iterable<String> updateDatabaseStatements, @Nullable String updateId) throws SpannerException {
        OperationFuture operationFuture;
        block3: {
            UpdateDatabaseDdlRequest request = UpdateDatabaseDdlRequest.newBuilder().setDatabase(databaseName).addAllStatements(updateDatabaseStatements).setOperationId((String)MoreObjects.firstNonNull((Object)updateId, (Object)"")).build();
            GrpcCallContext context = this.newCallContext(null, databaseName);
            OperationCallable<UpdateDatabaseDdlRequest, Empty, UpdateDatabaseDdlMetadata> callable = this.databaseAdminStub.updateDatabaseDdlOperationCallable();
            operationFuture = callable.futureCall((Object)request, (ApiCallContext)context);
            try {
                operationFuture.getInitialFuture().get();
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.newSpannerException(e);
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (!(t instanceof AlreadyExistsException)) break block3;
                String operationName = OPERATION_NAME_TEMPLATE.instantiate(new String[]{"database", databaseName, "operation", updateId});
                return callable.resumeFutureCall(operationName, (ApiCallContext)context);
            }
        }
        return operationFuture;
    }

    @Override
    public void dropDatabase(String databaseName) throws SpannerException {
        DropDatabaseRequest request = DropDatabaseRequest.newBuilder().setDatabase(databaseName).build();
        GrpcCallContext context = this.newCallContext(null, databaseName);
        GapicSpannerRpc.get(this.databaseAdminStub.dropDatabaseCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public Database getDatabase(String databaseName) throws SpannerException {
        GetDatabaseRequest request = GetDatabaseRequest.newBuilder().setName(databaseName).build();
        GrpcCallContext context = this.newCallContext(null, databaseName);
        return (Database)GapicSpannerRpc.get(this.databaseAdminStub.getDatabaseCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public List<String> getDatabaseDdl(String databaseName) throws SpannerException {
        GetDatabaseDdlRequest request = GetDatabaseDdlRequest.newBuilder().setDatabase(databaseName).build();
        GrpcCallContext context = this.newCallContext(null, databaseName);
        return ((GetDatabaseDdlResponse)GapicSpannerRpc.get(this.databaseAdminStub.getDatabaseDdlCallable().futureCall((Object)request, (ApiCallContext)context))).getStatementsList();
    }

    @Override
    public Operation getOperation(String name) throws SpannerException {
        GetOperationRequest request = GetOperationRequest.newBuilder().setName(name).build();
        GrpcCallContext context = this.newCallContext(null, name);
        return (Operation)GapicSpannerRpc.get(this.databaseAdminStub.getOperationsStub().getOperationCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public List<Session> batchCreateSessions(String databaseName, int sessionCount, @Nullable Map<String, String> labels, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        BatchCreateSessionsRequest.Builder requestBuilder = BatchCreateSessionsRequest.newBuilder().setDatabase(databaseName).setSessionCount(sessionCount);
        if (labels != null && !labels.isEmpty()) {
            Session.Builder session = Session.newBuilder().putAllLabels(labels);
            requestBuilder.setSessionTemplate(session);
        }
        BatchCreateSessionsRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(options, databaseName);
        return ((BatchCreateSessionsResponse)GapicSpannerRpc.get(this.spannerStub.batchCreateSessionsCallable().futureCall((Object)request, (ApiCallContext)context))).getSessionList();
    }

    @Override
    public Session createSession(String databaseName, @Nullable Map<String, String> labels, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        CreateSessionRequest.Builder requestBuilder = CreateSessionRequest.newBuilder().setDatabase(databaseName);
        if (labels != null && !labels.isEmpty()) {
            Session.Builder session = Session.newBuilder().putAllLabels(labels);
            requestBuilder.setSession(session);
        }
        CreateSessionRequest request = requestBuilder.build();
        GrpcCallContext context = this.newCallContext(options, databaseName);
        return (Session)GapicSpannerRpc.get(this.spannerStub.createSessionCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public void deleteSession(String sessionName, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(sessionName).build();
        GrpcCallContext context = this.newCallContext(options, sessionName);
        GapicSpannerRpc.get(this.spannerStub.deleteSessionCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public SpannerRpc.StreamingCall read(ReadRequest request, SpannerRpc.ResultStreamConsumer consumer, @Nullable Map<SpannerRpc.Option, ?> options) {
        GrpcCallContext context = this.newCallContext(options, request.getSession());
        SpannerResponseObserver responseObserver = new SpannerResponseObserver(consumer);
        this.spannerStub.streamingReadCallable().call((Object)request, (ResponseObserver)responseObserver, (ApiCallContext)context);
        final StreamController controller = responseObserver.getController();
        return new SpannerRpc.StreamingCall(){

            @Override
            public void request(int numMessage) {
                controller.request(numMessage);
            }

            @Override
            public void cancel(String message) {
                controller.cancel();
            }
        };
    }

    @Override
    public ResultSet executeQuery(ExecuteSqlRequest request, @Nullable Map<SpannerRpc.Option, ?> options) {
        GrpcCallContext context = this.newCallContext(options, request.getSession());
        return (ResultSet)GapicSpannerRpc.get(this.spannerStub.executeSqlCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public ResultSet executePartitionedDml(ExecuteSqlRequest request, @Nullable Map<SpannerRpc.Option, ?> options, Duration timeout) {
        GrpcCallContext context = this.newCallContext(options, request.getSession(), timeout);
        return (ResultSet)GapicSpannerRpc.get(this.spannerStub.executeSqlCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public SpannerRpc.StreamingCall executeQuery(ExecuteSqlRequest request, SpannerRpc.ResultStreamConsumer consumer, @Nullable Map<SpannerRpc.Option, ?> options) {
        GrpcCallContext context = this.newCallContext(options, request.getSession());
        SpannerResponseObserver responseObserver = new SpannerResponseObserver(consumer);
        this.spannerStub.executeStreamingSqlCallable().call((Object)request, (ResponseObserver)responseObserver, (ApiCallContext)context);
        final StreamController controller = responseObserver.getController();
        return new SpannerRpc.StreamingCall(){

            @Override
            public void request(int numMessage) {
                controller.request(numMessage);
            }

            @Override
            public void cancel(String message) {
                controller.cancel();
            }
        };
    }

    @Override
    public ExecuteBatchDmlResponse executeBatchDml(ExecuteBatchDmlRequest request, @Nullable Map<SpannerRpc.Option, ?> options) {
        GrpcCallContext context = this.newCallContext(options, request.getSession());
        return (ExecuteBatchDmlResponse)GapicSpannerRpc.get(this.spannerStub.executeBatchDmlCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public Transaction beginTransaction(BeginTransactionRequest request, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        GrpcCallContext context = this.newCallContext(options, request.getSession());
        return (Transaction)GapicSpannerRpc.get(this.spannerStub.beginTransactionCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public CommitResponse commit(CommitRequest commitRequest, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        GrpcCallContext context = this.newCallContext(options, commitRequest.getSession());
        return (CommitResponse)GapicSpannerRpc.get(this.spannerStub.commitCallable().futureCall((Object)commitRequest, (ApiCallContext)context));
    }

    @Override
    public void rollback(RollbackRequest request, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        GrpcCallContext context = this.newCallContext(options, request.getSession());
        GapicSpannerRpc.get(this.spannerStub.rollbackCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public PartitionResponse partitionQuery(PartitionQueryRequest request, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        GrpcCallContext context = this.newCallContext(options, request.getSession());
        return (PartitionResponse)GapicSpannerRpc.get(this.spannerStub.partitionQueryCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public PartitionResponse partitionRead(PartitionReadRequest request, @Nullable Map<SpannerRpc.Option, ?> options) throws SpannerException {
        GrpcCallContext context = this.newCallContext(options, request.getSession());
        return (PartitionResponse)GapicSpannerRpc.get(this.spannerStub.partitionReadCallable().futureCall((Object)request, (ApiCallContext)context));
    }

    @Override
    public Policy getDatabaseAdminIAMPolicy(String resource) {
        GrpcCallContext context = this.newCallContext(null, resource);
        return (Policy)GapicSpannerRpc.get(this.databaseAdminStub.getIamPolicyCallable().futureCall((Object)GetIamPolicyRequest.newBuilder().setResource(resource).build(), (ApiCallContext)context));
    }

    @Override
    public Policy setDatabaseAdminIAMPolicy(String resource, Policy policy) {
        GrpcCallContext context = this.newCallContext(null, resource);
        return (Policy)GapicSpannerRpc.get(this.databaseAdminStub.setIamPolicyCallable().futureCall((Object)SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build(), (ApiCallContext)context));
    }

    @Override
    public TestIamPermissionsResponse testDatabaseAdminIAMPermissions(String resource, Iterable<String> permissions) {
        GrpcCallContext context = this.newCallContext(null, resource);
        return (TestIamPermissionsResponse)GapicSpannerRpc.get(this.databaseAdminStub.testIamPermissionsCallable().futureCall((Object)TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build(), (ApiCallContext)context));
    }

    @Override
    public Policy getInstanceAdminIAMPolicy(String resource) {
        GrpcCallContext context = this.newCallContext(null, resource);
        return (Policy)GapicSpannerRpc.get(this.instanceAdminStub.getIamPolicyCallable().futureCall((Object)GetIamPolicyRequest.newBuilder().setResource(resource).build(), (ApiCallContext)context));
    }

    @Override
    public Policy setInstanceAdminIAMPolicy(String resource, Policy policy) {
        GrpcCallContext context = this.newCallContext(null, resource);
        return (Policy)GapicSpannerRpc.get(this.instanceAdminStub.setIamPolicyCallable().futureCall((Object)SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build(), (ApiCallContext)context));
    }

    @Override
    public TestIamPermissionsResponse testInstanceAdminIAMPermissions(String resource, Iterable<String> permissions) {
        GrpcCallContext context = this.newCallContext(null, resource);
        return (TestIamPermissionsResponse)GapicSpannerRpc.get(this.instanceAdminStub.testIamPermissionsCallable().futureCall((Object)TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build(), (ApiCallContext)context));
    }

    private static <T> T get(Future<T> future) throws SpannerException {
        Context context = Context.current();
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw SpannerExceptionFactory.propagateInterrupt(e);
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(context, e);
        }
    }

    private GrpcCallContext newCallContext(@Nullable Map<SpannerRpc.Option, ?> options, String resource) {
        return this.newCallContext(options, resource, null);
    }

    private GrpcCallContext newCallContext(@Nullable Map<SpannerRpc.Option, ?> options, String resource, Duration timeout) {
        GrpcCallContext context = GrpcCallContext.createDefault();
        if (options != null) {
            context = context.withChannelAffinity(Integer.valueOf(SpannerRpc.Option.CHANNEL_HINT.getLong(options).intValue()));
        }
        context = context.withExtraHeaders(this.metadataProvider.newExtraHeaders(resource, this.projectName));
        if (timeout != null) {
            context = context.withTimeout(timeout);
        }
        return context.withStreamWaitTimeout(this.waitTimeout).withStreamIdleTimeout(this.idleTimeout);
    }

    @Override
    public void shutdown() {
        this.rpcIsClosed = true;
        this.spannerStub.close();
        this.instanceAdminStub.close();
        this.databaseAdminStub.close();
        this.spannerWatchdog.shutdown();
        this.executorProvider.shutdown();
    }

    @Override
    public boolean isClosed() {
        return this.rpcIsClosed;
    }

    private static Duration systemProperty(String name, int defaultValue) {
        String stringValue = System.getProperty(name, "");
        return Duration.ofSeconds((long)(stringValue.isEmpty() ? (long)defaultValue : (long)Integer.parseInt(stringValue)));
    }

    private static class SpannerResponseObserver
    implements ResponseObserver<PartialResultSet> {
        private StreamController controller;
        private final SpannerRpc.ResultStreamConsumer consumer;

        public SpannerResponseObserver(SpannerRpc.ResultStreamConsumer consumer) {
            this.consumer = consumer;
        }

        public void onStart(StreamController controller) {
            controller.disableAutoInboundFlowControl();
            this.controller = controller;
        }

        public void onResponse(PartialResultSet response) {
            this.consumer.onPartialResultSet(response);
        }

        public void onError(Throwable t) {
            this.consumer.onError(SpannerExceptionFactory.newSpannerException(t));
        }

        public void onComplete() {
            this.consumer.onCompleted();
        }

        StreamController getController() {
            return (StreamController)Preconditions.checkNotNull((Object)this.controller);
        }
    }

    private static final class ManagedInstantiatingExecutorProvider
    implements ExecutorProvider {
        private static final int DEFAULT_THREAD_COUNT = 4;
        private final List<ScheduledExecutorService> executors = new LinkedList<ScheduledExecutorService>();
        private final ThreadFactory threadFactory;

        private ManagedInstantiatingExecutorProvider(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        public boolean shouldAutoClose() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScheduledExecutorService getExecutor() {
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(4, this.threadFactory);
            ManagedInstantiatingExecutorProvider managedInstantiatingExecutorProvider = this;
            synchronized (managedInstantiatingExecutorProvider) {
                this.executors.add(executor);
            }
            return executor;
        }

        private synchronized void shutdown() {
            for (ScheduledExecutorService executor : this.executors) {
                executor.shutdown();
            }
        }
    }
}

