/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

public class SessionPoolOptions {
    private static final int DEFAULT_MAX_SESSIONS = 400;
    private static final int DEFAULT_MIN_SESSIONS = 100;
    private static final ActionOnExhaustion DEFAULT_ACTION = ActionOnExhaustion.BLOCK;
    private final int minSessions;
    private final int maxSessions;
    private final int maxIdleSessions;
    private final float writeSessionsFraction;
    private final ActionOnExhaustion actionOnExhaustion;
    private final int keepAliveIntervalMinutes;
    private final ActionOnSessionNotFound actionOnSessionNotFound;
    private final long initialWaitForSessionTimeoutMillis;

    private SessionPoolOptions(Builder builder) {
        this.minSessions = Math.min(builder.minSessions, builder.maxSessions);
        this.maxSessions = builder.maxSessions;
        this.maxIdleSessions = builder.maxIdleSessions;
        this.writeSessionsFraction = builder.writeSessionsFraction;
        this.actionOnExhaustion = builder.actionOnExhaustion;
        this.actionOnSessionNotFound = builder.actionOnSessionNotFound;
        this.initialWaitForSessionTimeoutMillis = builder.initialWaitForSessionTimeoutMillis;
        this.keepAliveIntervalMinutes = builder.keepAliveIntervalMinutes;
    }

    public int getMinSessions() {
        return this.minSessions;
    }

    public int getMaxSessions() {
        return this.maxSessions;
    }

    public int getMaxIdleSessions() {
        return this.maxIdleSessions;
    }

    public float getWriteSessionsFraction() {
        return this.writeSessionsFraction;
    }

    public int getKeepAliveIntervalMinutes() {
        return this.keepAliveIntervalMinutes;
    }

    public boolean isFailIfPoolExhausted() {
        return this.actionOnExhaustion == ActionOnExhaustion.FAIL;
    }

    public boolean isBlockIfPoolExhausted() {
        return this.actionOnExhaustion == ActionOnExhaustion.BLOCK;
    }

    @VisibleForTesting
    long getInitialWaitForSessionTimeoutMillis() {
        return this.initialWaitForSessionTimeoutMillis;
    }

    @VisibleForTesting
    boolean isFailIfSessionNotFound() {
        return this.actionOnSessionNotFound == ActionOnSessionNotFound.FAIL;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static /* synthetic */ ActionOnExhaustion access$800() {
        return DEFAULT_ACTION;
    }

    public static class Builder {
        private boolean minSessionsSet = false;
        private int minSessions = 100;
        private int maxSessions = 400;
        private int maxIdleSessions;
        private float writeSessionsFraction = 0.2f;
        private ActionOnExhaustion actionOnExhaustion = SessionPoolOptions.access$800();
        private long initialWaitForSessionTimeoutMillis = 30000L;
        private ActionOnSessionNotFound actionOnSessionNotFound = ActionOnSessionNotFound.RETRY;
        private int keepAliveIntervalMinutes = 30;

        public Builder setMinSessions(int minSessions) {
            Preconditions.checkArgument((minSessions >= 0 ? 1 : 0) != 0, (Object)"minSessions must be >= 0");
            this.minSessionsSet = true;
            this.minSessions = minSessions;
            return this;
        }

        public Builder setMaxSessions(int maxSessions) {
            Preconditions.checkArgument((maxSessions > 0 ? 1 : 0) != 0, (Object)"maxSessions must be > 0");
            this.maxSessions = maxSessions;
            return this;
        }

        public Builder setMaxIdleSessions(int maxIdleSessions) {
            this.maxIdleSessions = maxIdleSessions;
            return this;
        }

        public Builder setKeepAliveIntervalMinutes(int intervalMinutes) {
            this.keepAliveIntervalMinutes = intervalMinutes;
            return this;
        }

        public Builder setFailIfPoolExhausted() {
            this.actionOnExhaustion = ActionOnExhaustion.FAIL;
            return this;
        }

        public Builder setBlockIfPoolExhausted() {
            this.actionOnExhaustion = ActionOnExhaustion.BLOCK;
            return this;
        }

        @VisibleForTesting
        Builder setInitialWaitForSessionTimeoutMillis(long timeout) {
            this.initialWaitForSessionTimeoutMillis = timeout;
            return this;
        }

        @VisibleForTesting
        Builder setFailIfSessionNotFound() {
            this.actionOnSessionNotFound = ActionOnSessionNotFound.FAIL;
            return this;
        }

        public Builder setWriteSessionsFraction(float writeSessionsFraction) {
            this.writeSessionsFraction = writeSessionsFraction;
            return this;
        }

        public SessionPoolOptions build() {
            this.validate();
            return new SessionPoolOptions(this);
        }

        private void validate() {
            if (this.minSessionsSet) {
                Preconditions.checkArgument((this.maxSessions >= this.minSessions ? 1 : 0) != 0, (String)"Min sessions(%s) must be <= max sessions(%s)", (int)this.minSessions, (int)this.maxSessions);
            }
            Preconditions.checkArgument((this.keepAliveIntervalMinutes < 60 ? 1 : 0) != 0, (Object)"Keep alive interval should be less than60 minutes");
            Preconditions.checkArgument((this.writeSessionsFraction >= 0.0f && this.writeSessionsFraction <= 1.0f ? 1 : 0) != 0, (Object)"Fraction of write sessions must be between 0 and 1 (inclusive)");
        }
    }

    private static enum ActionOnSessionNotFound {
        RETRY,
        FAIL;

    }

    private static enum ActionOnExhaustion {
        BLOCK,
        FAIL;

    }
}

