/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.Policy;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DatabaseInfo;
import com.google.cloud.spanner.SpannerException;
import com.google.common.base.Preconditions;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;

public class Database
extends DatabaseInfo {
    private final DatabaseAdminClient dbClient;

    public Database(DatabaseId id, DatabaseInfo.State state, DatabaseAdminClient dbClient) {
        super(id, state);
        this.dbClient = dbClient;
    }

    public Database reload() throws SpannerException {
        return this.dbClient.getDatabase(this.instance(), this.database());
    }

    public OperationFuture<Void, UpdateDatabaseDdlMetadata> updateDdl(Iterable<String> statements, String operationId) throws SpannerException {
        return this.dbClient.updateDatabaseDdl(this.instance(), this.database(), statements, operationId);
    }

    public void drop() throws SpannerException {
        this.dbClient.dropDatabase(this.instance(), this.database());
    }

    public Iterable<String> getDdl() throws SpannerException {
        return this.dbClient.getDatabaseDdl(this.instance(), this.database());
    }

    public Policy getIAMPolicy() {
        return this.dbClient.getDatabaseIAMPolicy(this.instance(), this.database());
    }

    public Policy setIAMPolicy(Policy policy) {
        return this.dbClient.setDatabaseIAMPolicy(this.instance(), this.database(), policy);
    }

    public Iterable<String> testIAMPermissions(Iterable<String> permissions) {
        return this.dbClient.testDatabaseIAMPermissions(this.instance(), this.database(), permissions);
    }

    private String instance() {
        return this.getId().getInstanceId().getInstance();
    }

    private String database() {
        return this.getId().getDatabase();
    }

    static Database fromProto(com.google.spanner.admin.database.v1.Database proto, DatabaseAdminClient client) {
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"Missing expected 'name' field");
        return new Database(DatabaseId.of(proto.getName()), Database.fromProtoState(proto.getState()), client);
    }

    static DatabaseInfo.State fromProtoState(Database.State protoState) {
        switch (protoState) {
            case STATE_UNSPECIFIED: {
                return DatabaseInfo.State.UNSPECIFIED;
            }
            case CREATING: {
                return DatabaseInfo.State.CREATING;
            }
            case READY: {
                return DatabaseInfo.State.READY;
            }
        }
        throw new IllegalArgumentException("Unrecognized state " + protoState);
    }
}

