/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.shell.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.shell.v1.AddPublicKeyMetadata;
import com.google.cloud.shell.v1.AddPublicKeyRequest;
import com.google.cloud.shell.v1.AddPublicKeyResponse;
import com.google.cloud.shell.v1.AuthorizeEnvironmentMetadata;
import com.google.cloud.shell.v1.AuthorizeEnvironmentRequest;
import com.google.cloud.shell.v1.AuthorizeEnvironmentResponse;
import com.google.cloud.shell.v1.CloudShellServiceSettings;
import com.google.cloud.shell.v1.Environment;
import com.google.cloud.shell.v1.EnvironmentName;
import com.google.cloud.shell.v1.GetEnvironmentRequest;
import com.google.cloud.shell.v1.RemovePublicKeyMetadata;
import com.google.cloud.shell.v1.RemovePublicKeyRequest;
import com.google.cloud.shell.v1.RemovePublicKeyResponse;
import com.google.cloud.shell.v1.StartEnvironmentMetadata;
import com.google.cloud.shell.v1.StartEnvironmentRequest;
import com.google.cloud.shell.v1.StartEnvironmentResponse;
import com.google.cloud.shell.v1.stub.CloudShellServiceStub;
import com.google.cloud.shell.v1.stub.CloudShellServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CloudShellServiceClient
implements BackgroundResource {
    private final CloudShellServiceSettings settings;
    private final CloudShellServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final CloudShellServiceClient create() throws IOException {
        return CloudShellServiceClient.create(CloudShellServiceSettings.newBuilder().build());
    }

    public static final CloudShellServiceClient create(CloudShellServiceSettings settings) throws IOException {
        return new CloudShellServiceClient(settings);
    }

    public static final CloudShellServiceClient create(CloudShellServiceStub stub) {
        return new CloudShellServiceClient(stub);
    }

    protected CloudShellServiceClient(CloudShellServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudShellServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected CloudShellServiceClient(CloudShellServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final CloudShellServiceSettings getSettings() {
        return this.settings;
    }

    public CloudShellServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Environment getEnvironment(EnvironmentName name) {
        GetEnvironmentRequest request = GetEnvironmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEnvironment(request);
    }

    public final Environment getEnvironment(String name) {
        GetEnvironmentRequest request = GetEnvironmentRequest.newBuilder().setName(name).build();
        return this.getEnvironment(request);
    }

    public final Environment getEnvironment(GetEnvironmentRequest request) {
        return (Environment)this.getEnvironmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.stub.getEnvironmentCallable();
    }

    public final OperationFuture<StartEnvironmentResponse, StartEnvironmentMetadata> startEnvironmentAsync(StartEnvironmentRequest request) {
        return this.startEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<StartEnvironmentRequest, StartEnvironmentResponse, StartEnvironmentMetadata> startEnvironmentOperationCallable() {
        return this.stub.startEnvironmentOperationCallable();
    }

    public final UnaryCallable<StartEnvironmentRequest, Operation> startEnvironmentCallable() {
        return this.stub.startEnvironmentCallable();
    }

    public final OperationFuture<AuthorizeEnvironmentResponse, AuthorizeEnvironmentMetadata> authorizeEnvironmentAsync(AuthorizeEnvironmentRequest request) {
        return this.authorizeEnvironmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AuthorizeEnvironmentRequest, AuthorizeEnvironmentResponse, AuthorizeEnvironmentMetadata> authorizeEnvironmentOperationCallable() {
        return this.stub.authorizeEnvironmentOperationCallable();
    }

    public final UnaryCallable<AuthorizeEnvironmentRequest, Operation> authorizeEnvironmentCallable() {
        return this.stub.authorizeEnvironmentCallable();
    }

    public final OperationFuture<AddPublicKeyResponse, AddPublicKeyMetadata> addPublicKeyAsync(AddPublicKeyRequest request) {
        return this.addPublicKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddPublicKeyRequest, AddPublicKeyResponse, AddPublicKeyMetadata> addPublicKeyOperationCallable() {
        return this.stub.addPublicKeyOperationCallable();
    }

    public final UnaryCallable<AddPublicKeyRequest, Operation> addPublicKeyCallable() {
        return this.stub.addPublicKeyCallable();
    }

    public final OperationFuture<RemovePublicKeyResponse, RemovePublicKeyMetadata> removePublicKeyAsync(RemovePublicKeyRequest request) {
        return this.removePublicKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemovePublicKeyRequest, RemovePublicKeyResponse, RemovePublicKeyMetadata> removePublicKeyOperationCallable() {
        return this.stub.removePublicKeyOperationCallable();
    }

    public final UnaryCallable<RemovePublicKeyRequest, Operation> removePublicKeyCallable() {
        return this.stub.removePublicKeyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

