/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.secretmanager.v1beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.secretmanager.v1beta1.AccessSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1beta1.AddSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta1.CreateSecretRequest;
import com.google.cloud.secretmanager.v1beta1.DeleteSecretRequest;
import com.google.cloud.secretmanager.v1beta1.DestroySecretVersionRequest;
import com.google.cloud.secretmanager.v1beta1.DisableSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta1.EnableSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta1.GetSecretRequest;
import com.google.cloud.secretmanager.v1beta1.GetSecretVersionRequest;
import com.google.cloud.secretmanager.v1beta1.ListSecretVersionsRequest;
import com.google.cloud.secretmanager.v1beta1.ListSecretVersionsResponse;
import com.google.cloud.secretmanager.v1beta1.ListSecretsRequest;
import com.google.cloud.secretmanager.v1beta1.ListSecretsResponse;
import com.google.cloud.secretmanager.v1beta1.Secret;
import com.google.cloud.secretmanager.v1beta1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1beta1.SecretVersion;
import com.google.cloud.secretmanager.v1beta1.UpdateSecretRequest;
import com.google.cloud.secretmanager.v1beta1.stub.GrpcSecretManagerServiceCallableFactory;
import com.google.cloud.secretmanager.v1beta1.stub.SecretManagerServiceStub;
import com.google.cloud.secretmanager.v1beta1.stub.SecretManagerServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcSecretManagerServiceStub
extends SecretManagerServiceStub {
    private static final MethodDescriptor<ListSecretsRequest, ListSecretsResponse> listSecretsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/ListSecrets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSecretsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSecretsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateSecretRequest, Secret> createSecretMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/CreateSecret").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSecretRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Secret.getDefaultInstance())).build();
    private static final MethodDescriptor<AddSecretVersionRequest, SecretVersion> addSecretVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/AddSecretVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)AddSecretVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SecretVersion.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSecretRequest, Secret> getSecretMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/GetSecret").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSecretRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Secret.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSecretRequest, Secret> updateSecretMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/UpdateSecret").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSecretRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Secret.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSecretRequest, Empty> deleteSecretMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/DeleteSecret").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSecretRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSecretVersionsRequest, ListSecretVersionsResponse> listSecretVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/ListSecretVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSecretVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSecretVersionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSecretVersionRequest, SecretVersion> getSecretVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/GetSecretVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSecretVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SecretVersion.getDefaultInstance())).build();
    private static final MethodDescriptor<AccessSecretVersionRequest, AccessSecretVersionResponse> accessSecretVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/AccessSecretVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)AccessSecretVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AccessSecretVersionResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DisableSecretVersionRequest, SecretVersion> disableSecretVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/DisableSecretVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)DisableSecretVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SecretVersion.getDefaultInstance())).build();
    private static final MethodDescriptor<EnableSecretVersionRequest, SecretVersion> enableSecretVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/EnableSecretVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)EnableSecretVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SecretVersion.getDefaultInstance())).build();
    private static final MethodDescriptor<DestroySecretVersionRequest, SecretVersion> destroySecretVersionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/DestroySecretVersion").setRequestMarshaller(ProtoUtils.marshaller((Message)DestroySecretVersionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SecretVersion.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.secrets.v1beta1.SecretManagerService/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListSecretsRequest, ListSecretsResponse> listSecretsCallable;
    private final UnaryCallable<ListSecretsRequest, SecretManagerServiceClient.ListSecretsPagedResponse> listSecretsPagedCallable;
    private final UnaryCallable<CreateSecretRequest, Secret> createSecretCallable;
    private final UnaryCallable<AddSecretVersionRequest, SecretVersion> addSecretVersionCallable;
    private final UnaryCallable<GetSecretRequest, Secret> getSecretCallable;
    private final UnaryCallable<UpdateSecretRequest, Secret> updateSecretCallable;
    private final UnaryCallable<DeleteSecretRequest, Empty> deleteSecretCallable;
    private final UnaryCallable<ListSecretVersionsRequest, ListSecretVersionsResponse> listSecretVersionsCallable;
    private final UnaryCallable<ListSecretVersionsRequest, SecretManagerServiceClient.ListSecretVersionsPagedResponse> listSecretVersionsPagedCallable;
    private final UnaryCallable<GetSecretVersionRequest, SecretVersion> getSecretVersionCallable;
    private final UnaryCallable<AccessSecretVersionRequest, AccessSecretVersionResponse> accessSecretVersionCallable;
    private final UnaryCallable<DisableSecretVersionRequest, SecretVersion> disableSecretVersionCallable;
    private final UnaryCallable<EnableSecretVersionRequest, SecretVersion> enableSecretVersionCallable;
    private final UnaryCallable<DestroySecretVersionRequest, SecretVersion> destroySecretVersionCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSecretManagerServiceStub create(SecretManagerServiceStubSettings settings) throws IOException {
        return new GrpcSecretManagerServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSecretManagerServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSecretManagerServiceStub(SecretManagerServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSecretManagerServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSecretManagerServiceStub(SecretManagerServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSecretManagerServiceStub(SecretManagerServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSecretManagerServiceCallableFactory());
    }

    protected GrpcSecretManagerServiceStub(SecretManagerServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listSecretsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSecretsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListSecretsRequest>(){

            public Map<String, String> extract(ListSecretsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createSecretTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSecretMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateSecretRequest>(){

            public Map<String, String> extract(CreateSecretRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings addSecretVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(addSecretVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<AddSecretVersionRequest>(){

            public Map<String, String> extract(AddSecretVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getSecretTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSecretMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetSecretRequest>(){

            public Map<String, String> extract(GetSecretRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateSecretTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSecretMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateSecretRequest>(){

            public Map<String, String> extract(UpdateSecretRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"secret.name", (Object)String.valueOf(request.getSecret().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteSecretTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSecretMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteSecretRequest>(){

            public Map<String, String> extract(DeleteSecretRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listSecretVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSecretVersionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListSecretVersionsRequest>(){

            public Map<String, String> extract(ListSecretVersionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getSecretVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSecretVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetSecretVersionRequest>(){

            public Map<String, String> extract(GetSecretVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings accessSecretVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(accessSecretVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<AccessSecretVersionRequest>(){

            public Map<String, String> extract(AccessSecretVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings disableSecretVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(disableSecretVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DisableSecretVersionRequest>(){

            public Map<String, String> extract(DisableSecretVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings enableSecretVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(enableSecretVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<EnableSecretVersionRequest>(){

            public Map<String, String> extract(EnableSecretVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings destroySecretVersionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(destroySecretVersionMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DestroySecretVersionRequest>(){

            public Map<String, String> extract(DestroySecretVersionRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<SetIamPolicyRequest>(){

            public Map<String, String> extract(SetIamPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetIamPolicyRequest>(){

            public Map<String, String> extract(GetIamPolicyRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<TestIamPermissionsRequest>(){

            public Map<String, String> extract(TestIamPermissionsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
                return params.build();
            }
        }).build();
        this.listSecretsCallable = callableFactory.createUnaryCallable(listSecretsTransportSettings, settings.listSecretsSettings(), clientContext);
        this.listSecretsPagedCallable = callableFactory.createPagedCallable(listSecretsTransportSettings, settings.listSecretsSettings(), clientContext);
        this.createSecretCallable = callableFactory.createUnaryCallable(createSecretTransportSettings, settings.createSecretSettings(), clientContext);
        this.addSecretVersionCallable = callableFactory.createUnaryCallable(addSecretVersionTransportSettings, settings.addSecretVersionSettings(), clientContext);
        this.getSecretCallable = callableFactory.createUnaryCallable(getSecretTransportSettings, settings.getSecretSettings(), clientContext);
        this.updateSecretCallable = callableFactory.createUnaryCallable(updateSecretTransportSettings, settings.updateSecretSettings(), clientContext);
        this.deleteSecretCallable = callableFactory.createUnaryCallable(deleteSecretTransportSettings, settings.deleteSecretSettings(), clientContext);
        this.listSecretVersionsCallable = callableFactory.createUnaryCallable(listSecretVersionsTransportSettings, settings.listSecretVersionsSettings(), clientContext);
        this.listSecretVersionsPagedCallable = callableFactory.createPagedCallable(listSecretVersionsTransportSettings, settings.listSecretVersionsSettings(), clientContext);
        this.getSecretVersionCallable = callableFactory.createUnaryCallable(getSecretVersionTransportSettings, settings.getSecretVersionSettings(), clientContext);
        this.accessSecretVersionCallable = callableFactory.createUnaryCallable(accessSecretVersionTransportSettings, settings.accessSecretVersionSettings(), clientContext);
        this.disableSecretVersionCallable = callableFactory.createUnaryCallable(disableSecretVersionTransportSettings, settings.disableSecretVersionSettings(), clientContext);
        this.enableSecretVersionCallable = callableFactory.createUnaryCallable(enableSecretVersionTransportSettings, settings.enableSecretVersionSettings(), clientContext);
        this.destroySecretVersionCallable = callableFactory.createUnaryCallable(destroySecretVersionTransportSettings, settings.destroySecretVersionSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListSecretsRequest, ListSecretsResponse> listSecretsCallable() {
        return this.listSecretsCallable;
    }

    @Override
    public UnaryCallable<ListSecretsRequest, SecretManagerServiceClient.ListSecretsPagedResponse> listSecretsPagedCallable() {
        return this.listSecretsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateSecretRequest, Secret> createSecretCallable() {
        return this.createSecretCallable;
    }

    @Override
    public UnaryCallable<AddSecretVersionRequest, SecretVersion> addSecretVersionCallable() {
        return this.addSecretVersionCallable;
    }

    @Override
    public UnaryCallable<GetSecretRequest, Secret> getSecretCallable() {
        return this.getSecretCallable;
    }

    @Override
    public UnaryCallable<UpdateSecretRequest, Secret> updateSecretCallable() {
        return this.updateSecretCallable;
    }

    @Override
    public UnaryCallable<DeleteSecretRequest, Empty> deleteSecretCallable() {
        return this.deleteSecretCallable;
    }

    @Override
    public UnaryCallable<ListSecretVersionsRequest, ListSecretVersionsResponse> listSecretVersionsCallable() {
        return this.listSecretVersionsCallable;
    }

    @Override
    public UnaryCallable<ListSecretVersionsRequest, SecretManagerServiceClient.ListSecretVersionsPagedResponse> listSecretVersionsPagedCallable() {
        return this.listSecretVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetSecretVersionRequest, SecretVersion> getSecretVersionCallable() {
        return this.getSecretVersionCallable;
    }

    @Override
    public UnaryCallable<AccessSecretVersionRequest, AccessSecretVersionResponse> accessSecretVersionCallable() {
        return this.accessSecretVersionCallable;
    }

    @Override
    public UnaryCallable<DisableSecretVersionRequest, SecretVersion> disableSecretVersionCallable() {
        return this.disableSecretVersionCallable;
    }

    @Override
    public UnaryCallable<EnableSecretVersionRequest, SecretVersion> enableSecretVersionCallable() {
        return this.enableSecretVersionCallable;
    }

    @Override
    public UnaryCallable<DestroySecretVersionRequest, SecretVersion> destroySecretVersionCallable() {
        return this.destroySecretVersionCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

