/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.scheduler.v1beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.scheduler.v1beta1.CloudSchedulerSettings;
import com.google.cloud.scheduler.v1beta1.CreateJobRequest;
import com.google.cloud.scheduler.v1beta1.DeleteJobRequest;
import com.google.cloud.scheduler.v1beta1.GetJobRequest;
import com.google.cloud.scheduler.v1beta1.Job;
import com.google.cloud.scheduler.v1beta1.ListJobsRequest;
import com.google.cloud.scheduler.v1beta1.ListJobsResponse;
import com.google.cloud.scheduler.v1beta1.PauseJobRequest;
import com.google.cloud.scheduler.v1beta1.ResumeJobRequest;
import com.google.cloud.scheduler.v1beta1.RunJobRequest;
import com.google.cloud.scheduler.v1beta1.UpdateJobRequest;
import com.google.cloud.scheduler.v1beta1.stub.CloudSchedulerStub;
import com.google.cloud.scheduler.v1beta1.stub.CloudSchedulerStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CloudSchedulerClient
implements BackgroundResource {
    private final CloudSchedulerSettings settings;
    private final CloudSchedulerStub stub;
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");
    private static final PathTemplate LOCATION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}");
    private static final PathTemplate JOB_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/jobs/{job}");

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String formatLocationName(String project, String location) {
        return LOCATION_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location});
    }

    public static final String formatJobName(String project, String location, String job) {
        return JOB_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "job", job});
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final String parseProjectFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"project");
    }

    public static final String parseLocationFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"location");
    }

    public static final String parseProjectFromJobName(String jobName) {
        return JOB_PATH_TEMPLATE.parse(jobName).get((Object)"project");
    }

    public static final String parseLocationFromJobName(String jobName) {
        return JOB_PATH_TEMPLATE.parse(jobName).get((Object)"location");
    }

    public static final String parseJobFromJobName(String jobName) {
        return JOB_PATH_TEMPLATE.parse(jobName).get((Object)"job");
    }

    public static final CloudSchedulerClient create() throws IOException {
        return CloudSchedulerClient.create(CloudSchedulerSettings.newBuilder().build());
    }

    public static final CloudSchedulerClient create(CloudSchedulerSettings settings) throws IOException {
        return new CloudSchedulerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CloudSchedulerClient create(CloudSchedulerStub stub) {
        return new CloudSchedulerClient(stub);
    }

    protected CloudSchedulerClient(CloudSchedulerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudSchedulerStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CloudSchedulerClient(CloudSchedulerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CloudSchedulerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudSchedulerStub getStub() {
        return this.stub;
    }

    public final ListJobsPagedResponse listJobs(String parent) {
        LOCATION_PATH_TEMPLATE.validate(parent, "listJobs");
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(ListJobsRequest request) {
        return (ListJobsPagedResponse)((Object)this.listJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListJobsRequest, ListJobsPagedResponse> listJobsPagedCallable() {
        return this.stub.listJobsPagedCallable();
    }

    public final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.stub.listJobsCallable();
    }

    public final Job getJob(String name) {
        JOB_PATH_TEMPLATE.validate(name, "getJob");
        GetJobRequest request = GetJobRequest.newBuilder().setName(name).build();
        return this.getJob(request);
    }

    public final Job getJob(GetJobRequest request) {
        return (Job)this.getJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.stub.getJobCallable();
    }

    public final Job createJob(String parent, Job job) {
        LOCATION_PATH_TEMPLATE.validate(parent, "createJob");
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent).setJob(job).build();
        return this.createJob(request);
    }

    public final Job createJob(CreateJobRequest request) {
        return (Job)this.createJobCallable().call((Object)request);
    }

    public final UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.stub.createJobCallable();
    }

    public final Job updateJob(Job job, FieldMask updateMask) {
        UpdateJobRequest request = UpdateJobRequest.newBuilder().setJob(job).setUpdateMask(updateMask).build();
        return this.updateJob(request);
    }

    public final Job updateJob(UpdateJobRequest request) {
        return (Job)this.updateJobCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.stub.updateJobCallable();
    }

    public final void deleteJob(String name) {
        JOB_PATH_TEMPLATE.validate(name, "deleteJob");
        DeleteJobRequest request = DeleteJobRequest.newBuilder().setName(name).build();
        this.deleteJob(request);
    }

    public final void deleteJob(DeleteJobRequest request) {
        this.deleteJobCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.stub.deleteJobCallable();
    }

    public final Job pauseJob(String name) {
        JOB_PATH_TEMPLATE.validate(name, "pauseJob");
        PauseJobRequest request = PauseJobRequest.newBuilder().setName(name).build();
        return this.pauseJob(request);
    }

    public final Job pauseJob(PauseJobRequest request) {
        return (Job)this.pauseJobCallable().call((Object)request);
    }

    public final UnaryCallable<PauseJobRequest, Job> pauseJobCallable() {
        return this.stub.pauseJobCallable();
    }

    public final Job resumeJob(String name) {
        JOB_PATH_TEMPLATE.validate(name, "resumeJob");
        ResumeJobRequest request = ResumeJobRequest.newBuilder().setName(name).build();
        return this.resumeJob(request);
    }

    public final Job resumeJob(ResumeJobRequest request) {
        return (Job)this.resumeJobCallable().call((Object)request);
    }

    public final UnaryCallable<ResumeJobRequest, Job> resumeJobCallable() {
        return this.stub.resumeJobCallable();
    }

    public final Job runJob(String name) {
        JOB_PATH_TEMPLATE.validate(name, "runJob");
        RunJobRequest request = RunJobRequest.newBuilder().setName(name).build();
        return this.runJob(request);
    }

    public final Job runJob(RunJobRequest request) {
        return (Job)this.runJobCallable().call((Object)request);
    }

    public final UnaryCallable<RunJobRequest, Job> runJobCallable() {
        return this.stub.runJobCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        private ListJobsFixedSizeCollection(List<ListJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListJobsFixedSizeCollection createEmptyCollection() {
            return new ListJobsFixedSizeCollection(null, 0);
        }

        protected ListJobsFixedSizeCollection createCollection(List<ListJobsPage> pages, int collectionSize) {
            return new ListJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListJobsPage
    extends AbstractPage<ListJobsRequest, ListJobsResponse, Job, ListJobsPage> {
        private ListJobsPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListJobsPage createEmptyPage() {
            return new ListJobsPage(null, null);
        }

        protected ListJobsPage createPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            return new ListJobsPage(context, response);
        }

        public ApiFuture<ListJobsPage> createPageAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListJobsPagedResponse
    extends AbstractPagedListResponse<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        public static ApiFuture<ListJobsPagedResponse> createAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            ApiFuture<ListJobsPage> futurePage = ListJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListJobsPage, ListJobsPagedResponse>(){

                public ListJobsPagedResponse apply(ListJobsPage input) {
                    return new ListJobsPagedResponse(input);
                }
            });
        }

        private ListJobsPagedResponse(ListJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

