/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.GetTaskRequest;
import com.google.cloud.run.v2.ListTasksRequest;
import com.google.cloud.run.v2.ListTasksResponse;
import com.google.cloud.run.v2.Task;
import com.google.cloud.run.v2.TasksClient;
import com.google.cloud.run.v2.stub.GrpcTasksCallableFactory;
import com.google.cloud.run.v2.stub.TasksStub;
import com.google.cloud.run.v2.stub.TasksStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcTasksStub
extends TasksStub {
    private static final MethodDescriptor<GetTaskRequest, Task> getTaskMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Tasks/GetTask").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTaskRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Task.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListTasksRequest, ListTasksResponse> listTasksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Tasks/ListTasks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTasksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTasksResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetTaskRequest, Task> getTaskCallable;
    private final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable;
    private final UnaryCallable<ListTasksRequest, TasksClient.ListTasksPagedResponse> listTasksPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTasksStub create(TasksStubSettings settings) throws IOException {
        return new GrpcTasksStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTasksStub create(ClientContext clientContext) throws IOException {
        return new GrpcTasksStub(TasksStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTasksStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTasksStub(TasksStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTasksStub(TasksStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTasksCallableFactory());
    }

    protected GrpcTasksStub(TasksStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getTaskTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTaskMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listTasksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTasksMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getTaskCallable = callableFactory.createUnaryCallable(getTaskTransportSettings, settings.getTaskSettings(), clientContext);
        this.listTasksCallable = callableFactory.createUnaryCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.listTasksPagedCallable = callableFactory.createPagedCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.getTaskCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.listTasksCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, TasksClient.ListTasksPagedResponse> listTasksPagedCallable() {
        return this.listTasksPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

