/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.run.v2.CreateWorkerPoolRequest;
import com.google.cloud.run.v2.DeleteWorkerPoolRequest;
import com.google.cloud.run.v2.GetWorkerPoolRequest;
import com.google.cloud.run.v2.ListWorkerPoolsRequest;
import com.google.cloud.run.v2.ListWorkerPoolsResponse;
import com.google.cloud.run.v2.UpdateWorkerPoolRequest;
import com.google.cloud.run.v2.WorkerPool;
import com.google.cloud.run.v2.WorkerPoolsClient;
import com.google.cloud.run.v2.stub.HttpJsonWorkerPoolsCallableFactory;
import com.google.cloud.run.v2.stub.WorkerPoolsStub;
import com.google.cloud.run.v2.stub.WorkerPoolsStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonWorkerPoolsStub
extends WorkerPoolsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(WorkerPool.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateWorkerPoolRequest, Operation> createWorkerPoolMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.WorkerPools/CreateWorkerPool").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/workerPools", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "workerPoolId", (Object)request.getWorkerPoolId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workerPool", (Message)request.getWorkerPool(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetWorkerPoolRequest, WorkerPool> getWorkerPoolMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.WorkerPools/GetWorkerPool").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/workerPools/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)WorkerPool.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.WorkerPools/ListWorkerPools").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/workerPools", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListWorkerPoolsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateWorkerPoolRequest, Operation> updateWorkerPoolMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.WorkerPools/UpdateWorkerPool").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{workerPool.name=projects/*/locations/*/workerPools/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "workerPool.name", (Object)request.getWorkerPool().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "forceNewRevision", (Object)request.getForceNewRevision());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("workerPool", (Message)request.getWorkerPool(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.WorkerPools/DeleteWorkerPool").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/workerPools/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.WorkerPools/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{resource=projects/*/locations/*/workerPools/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "options", (Object)request.getOptions());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.WorkerPools/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{resource=projects/*/locations/*/workerPools/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.WorkerPools/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{resource=projects/*/locations/*/workerPools/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateWorkerPoolRequest, Operation> createWorkerPoolCallable;
    private final OperationCallable<CreateWorkerPoolRequest, WorkerPool, WorkerPool> createWorkerPoolOperationCallable;
    private final UnaryCallable<GetWorkerPoolRequest, WorkerPool> getWorkerPoolCallable;
    private final UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsCallable;
    private final UnaryCallable<ListWorkerPoolsRequest, WorkerPoolsClient.ListWorkerPoolsPagedResponse> listWorkerPoolsPagedCallable;
    private final UnaryCallable<UpdateWorkerPoolRequest, Operation> updateWorkerPoolCallable;
    private final OperationCallable<UpdateWorkerPoolRequest, WorkerPool, WorkerPool> updateWorkerPoolOperationCallable;
    private final UnaryCallable<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolCallable;
    private final OperationCallable<DeleteWorkerPoolRequest, WorkerPool, WorkerPool> deleteWorkerPoolOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;
    private static final PathTemplate CREATE_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate GET_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");
    private static final PathTemplate LIST_WORKER_POOLS_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate UPDATE_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");
    private static final PathTemplate DELETE_WORKER_POOL_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");

    public static final HttpJsonWorkerPoolsStub create(WorkerPoolsStubSettings settings) throws IOException {
        return new HttpJsonWorkerPoolsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonWorkerPoolsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonWorkerPoolsStub(WorkerPoolsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonWorkerPoolsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonWorkerPoolsStub(WorkerPoolsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonWorkerPoolsStub(WorkerPoolsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonWorkerPoolsCallableFactory());
    }

    protected HttpJsonWorkerPoolsStub(WorkerPoolsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v2/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*}/operations").build()).put((Object)"google.longrunning.Operations.WaitOperation", (Object)HttpRule.newBuilder().setPost("/v2/{name=projects/*/locations/*/operations/*}:wait").build()).build());
        HttpJsonCallSettings createWorkerPoolTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createWorkerPoolMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", CREATE_WORKER_POOL_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings getWorkerPoolTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getWorkerPoolMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", GET_WORKER_POOL_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings listWorkerPoolsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listWorkerPoolsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", LIST_WORKER_POOLS_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings updateWorkerPoolTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateWorkerPoolMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getWorkerPool() != null) {
                builder.add(request.getWorkerPool().getName(), "location", UPDATE_WORKER_POOL_0_PATH_TEMPLATE);
            }
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteWorkerPoolTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteWorkerPoolMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", DELETE_WORKER_POOL_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createWorkerPoolCallable = callableFactory.createUnaryCallable(createWorkerPoolTransportSettings, settings.createWorkerPoolSettings(), clientContext);
        this.createWorkerPoolOperationCallable = callableFactory.createOperationCallable(createWorkerPoolTransportSettings, settings.createWorkerPoolOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getWorkerPoolCallable = callableFactory.createUnaryCallable(getWorkerPoolTransportSettings, settings.getWorkerPoolSettings(), clientContext);
        this.listWorkerPoolsCallable = callableFactory.createUnaryCallable(listWorkerPoolsTransportSettings, settings.listWorkerPoolsSettings(), clientContext);
        this.listWorkerPoolsPagedCallable = callableFactory.createPagedCallable(listWorkerPoolsTransportSettings, settings.listWorkerPoolsSettings(), clientContext);
        this.updateWorkerPoolCallable = callableFactory.createUnaryCallable(updateWorkerPoolTransportSettings, settings.updateWorkerPoolSettings(), clientContext);
        this.updateWorkerPoolOperationCallable = callableFactory.createOperationCallable(updateWorkerPoolTransportSettings, settings.updateWorkerPoolOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteWorkerPoolCallable = callableFactory.createUnaryCallable(deleteWorkerPoolTransportSettings, settings.deleteWorkerPoolSettings(), clientContext);
        this.deleteWorkerPoolOperationCallable = callableFactory.createOperationCallable(deleteWorkerPoolTransportSettings, settings.deleteWorkerPoolOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createWorkerPoolMethodDescriptor);
        methodDescriptors.add(getWorkerPoolMethodDescriptor);
        methodDescriptors.add(listWorkerPoolsMethodDescriptor);
        methodDescriptors.add(updateWorkerPoolMethodDescriptor);
        methodDescriptors.add(deleteWorkerPoolMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateWorkerPoolRequest, Operation> createWorkerPoolCallable() {
        return this.createWorkerPoolCallable;
    }

    @Override
    public OperationCallable<CreateWorkerPoolRequest, WorkerPool, WorkerPool> createWorkerPoolOperationCallable() {
        return this.createWorkerPoolOperationCallable;
    }

    @Override
    public UnaryCallable<GetWorkerPoolRequest, WorkerPool> getWorkerPoolCallable() {
        return this.getWorkerPoolCallable;
    }

    @Override
    public UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsCallable() {
        return this.listWorkerPoolsCallable;
    }

    @Override
    public UnaryCallable<ListWorkerPoolsRequest, WorkerPoolsClient.ListWorkerPoolsPagedResponse> listWorkerPoolsPagedCallable() {
        return this.listWorkerPoolsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateWorkerPoolRequest, Operation> updateWorkerPoolCallable() {
        return this.updateWorkerPoolCallable;
    }

    @Override
    public OperationCallable<UpdateWorkerPoolRequest, WorkerPool, WorkerPool> updateWorkerPoolOperationCallable() {
        return this.updateWorkerPoolOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolCallable() {
        return this.deleteWorkerPoolCallable;
    }

    @Override
    public OperationCallable<DeleteWorkerPoolRequest, WorkerPool, WorkerPool> deleteWorkerPoolOperationCallable() {
        return this.deleteWorkerPoolOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

