/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.CreateJobRequest;
import com.google.cloud.run.v2.DeleteJobRequest;
import com.google.cloud.run.v2.Execution;
import com.google.cloud.run.v2.GetJobRequest;
import com.google.cloud.run.v2.Job;
import com.google.cloud.run.v2.JobName;
import com.google.cloud.run.v2.JobsSettings;
import com.google.cloud.run.v2.ListJobsRequest;
import com.google.cloud.run.v2.ListJobsResponse;
import com.google.cloud.run.v2.LocationName;
import com.google.cloud.run.v2.RunJobRequest;
import com.google.cloud.run.v2.UpdateJobRequest;
import com.google.cloud.run.v2.stub.JobsStub;
import com.google.cloud.run.v2.stub.JobsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class JobsClient
implements BackgroundResource {
    private final JobsSettings settings;
    private final JobsStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final JobsClient create() throws IOException {
        return JobsClient.create(JobsSettings.newBuilder().build());
    }

    public static final JobsClient create(JobsSettings settings) throws IOException {
        return new JobsClient(settings);
    }

    public static final JobsClient create(JobsStub stub) {
        return new JobsClient(stub);
    }

    protected JobsClient(JobsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((JobsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected JobsClient(JobsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final JobsSettings getSettings() {
        return this.settings;
    }

    public JobsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Job, Job> createJobAsync(LocationName parent, Job job, String jobId) {
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setJob(job).setJobId(jobId).build();
        return this.createJobAsync(request);
    }

    public final OperationFuture<Job, Job> createJobAsync(String parent, Job job, String jobId) {
        CreateJobRequest request = CreateJobRequest.newBuilder().setParent(parent).setJob(job).setJobId(jobId).build();
        return this.createJobAsync(request);
    }

    public final OperationFuture<Job, Job> createJobAsync(CreateJobRequest request) {
        return this.createJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateJobRequest, Job, Job> createJobOperationCallable() {
        return this.stub.createJobOperationCallable();
    }

    public final UnaryCallable<CreateJobRequest, Operation> createJobCallable() {
        return this.stub.createJobCallable();
    }

    public final Job getJob(JobName name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getJob(request);
    }

    public final Job getJob(String name) {
        GetJobRequest request = GetJobRequest.newBuilder().setName(name).build();
        return this.getJob(request);
    }

    public final Job getJob(GetJobRequest request) {
        return (Job)this.getJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.stub.getJobCallable();
    }

    public final ListJobsPagedResponse listJobs(LocationName parent) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(String parent) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setParent(parent).build();
        return this.listJobs(request);
    }

    public final ListJobsPagedResponse listJobs(ListJobsRequest request) {
        return (ListJobsPagedResponse)((Object)this.listJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListJobsRequest, ListJobsPagedResponse> listJobsPagedCallable() {
        return this.stub.listJobsPagedCallable();
    }

    public final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.stub.listJobsCallable();
    }

    public final OperationFuture<Job, Job> updateJobAsync(Job job) {
        UpdateJobRequest request = UpdateJobRequest.newBuilder().setJob(job).build();
        return this.updateJobAsync(request);
    }

    public final OperationFuture<Job, Job> updateJobAsync(UpdateJobRequest request) {
        return this.updateJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateJobRequest, Job, Job> updateJobOperationCallable() {
        return this.stub.updateJobOperationCallable();
    }

    public final UnaryCallable<UpdateJobRequest, Operation> updateJobCallable() {
        return this.stub.updateJobCallable();
    }

    public final OperationFuture<Job, Job> deleteJobAsync(JobName name) {
        DeleteJobRequest request = DeleteJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteJobAsync(request);
    }

    public final OperationFuture<Job, Job> deleteJobAsync(String name) {
        DeleteJobRequest request = DeleteJobRequest.newBuilder().setName(name).build();
        return this.deleteJobAsync(request);
    }

    public final OperationFuture<Job, Job> deleteJobAsync(DeleteJobRequest request) {
        return this.deleteJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteJobRequest, Job, Job> deleteJobOperationCallable() {
        return this.stub.deleteJobOperationCallable();
    }

    public final UnaryCallable<DeleteJobRequest, Operation> deleteJobCallable() {
        return this.stub.deleteJobCallable();
    }

    public final OperationFuture<Execution, Execution> runJobAsync(JobName name) {
        RunJobRequest request = RunJobRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.runJobAsync(request);
    }

    public final OperationFuture<Execution, Execution> runJobAsync(String name) {
        RunJobRequest request = RunJobRequest.newBuilder().setName(name).build();
        return this.runJobAsync(request);
    }

    public final OperationFuture<Execution, Execution> runJobAsync(RunJobRequest request) {
        return this.runJobOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RunJobRequest, Execution, Execution> runJobOperationCallable() {
        return this.stub.runJobOperationCallable();
    }

    public final UnaryCallable<RunJobRequest, Operation> runJobCallable() {
        return this.stub.runJobCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListJobsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        private ListJobsFixedSizeCollection(List<ListJobsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListJobsFixedSizeCollection createEmptyCollection() {
            return new ListJobsFixedSizeCollection(null, 0);
        }

        protected ListJobsFixedSizeCollection createCollection(List<ListJobsPage> pages, int collectionSize) {
            return new ListJobsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListJobsPage
    extends AbstractPage<ListJobsRequest, ListJobsResponse, Job, ListJobsPage> {
        private ListJobsPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            super(context, (Object)response);
        }

        private static ListJobsPage createEmptyPage() {
            return new ListJobsPage(null, null);
        }

        protected ListJobsPage createPage(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ListJobsResponse response) {
            return new ListJobsPage(context, response);
        }

        public ApiFuture<ListJobsPage> createPageAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListJobsPagedResponse
    extends AbstractPagedListResponse<ListJobsRequest, ListJobsResponse, Job, ListJobsPage, ListJobsFixedSizeCollection> {
        public static ApiFuture<ListJobsPagedResponse> createAsync(PageContext<ListJobsRequest, ListJobsResponse, Job> context, ApiFuture<ListJobsResponse> futureResponse) {
            ApiFuture<ListJobsPage> futurePage = ListJobsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListJobsPagedResponse((ListJobsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListJobsPagedResponse(ListJobsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListJobsFixedSizeCollection.createEmptyCollection());
        }
    }
}

