/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.DeleteExecutionRequest;
import com.google.cloud.run.v2.Execution;
import com.google.cloud.run.v2.ExecutionsClient;
import com.google.cloud.run.v2.GetExecutionRequest;
import com.google.cloud.run.v2.ListExecutionsRequest;
import com.google.cloud.run.v2.ListExecutionsResponse;
import com.google.cloud.run.v2.stub.ExecutionsStub;
import com.google.cloud.run.v2.stub.ExecutionsStubSettings;
import com.google.cloud.run.v2.stub.HttpJsonExecutionsCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonExecutionsStub
extends ExecutionsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Execution.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetExecutionRequest, Execution> getExecutionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Executions/GetExecution").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/jobs/*/executions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Execution.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListExecutionsRequest, ListExecutionsResponse> listExecutionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Executions/ListExecutions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*/jobs/*}/executions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListExecutionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteExecutionRequest, Operation> deleteExecutionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Executions/DeleteExecution").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/jobs/*/executions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<GetExecutionRequest, Execution> getExecutionCallable;
    private final UnaryCallable<ListExecutionsRequest, ListExecutionsResponse> listExecutionsCallable;
    private final UnaryCallable<ListExecutionsRequest, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsPagedCallable;
    private final UnaryCallable<DeleteExecutionRequest, Operation> deleteExecutionCallable;
    private final OperationCallable<DeleteExecutionRequest, Execution, Execution> deleteExecutionOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonExecutionsStub create(ExecutionsStubSettings settings) throws IOException {
        return new HttpJsonExecutionsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonExecutionsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonExecutionsStub(ExecutionsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonExecutionsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonExecutionsStub(ExecutionsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonExecutionsStub(ExecutionsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonExecutionsCallableFactory());
    }

    protected HttpJsonExecutionsStub(ExecutionsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v2/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v2/{name=projects/*/locations/*}/operations").build()).put((Object)"google.longrunning.Operations.WaitOperation", (Object)HttpRule.newBuilder().setPost("/v2/{name=projects/*/locations/*/operations/*}:wait").build()).build());
        HttpJsonCallSettings getExecutionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getExecutionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listExecutionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listExecutionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteExecutionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteExecutionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getExecutionCallable = callableFactory.createUnaryCallable(getExecutionTransportSettings, settings.getExecutionSettings(), clientContext);
        this.listExecutionsCallable = callableFactory.createUnaryCallable(listExecutionsTransportSettings, settings.listExecutionsSettings(), clientContext);
        this.listExecutionsPagedCallable = callableFactory.createPagedCallable(listExecutionsTransportSettings, settings.listExecutionsSettings(), clientContext);
        this.deleteExecutionCallable = callableFactory.createUnaryCallable(deleteExecutionTransportSettings, settings.deleteExecutionSettings(), clientContext);
        this.deleteExecutionOperationCallable = callableFactory.createOperationCallable(deleteExecutionTransportSettings, settings.deleteExecutionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getExecutionMethodDescriptor);
        methodDescriptors.add(listExecutionsMethodDescriptor);
        methodDescriptors.add(deleteExecutionMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetExecutionRequest, Execution> getExecutionCallable() {
        return this.getExecutionCallable;
    }

    @Override
    public UnaryCallable<ListExecutionsRequest, ListExecutionsResponse> listExecutionsCallable() {
        return this.listExecutionsCallable;
    }

    @Override
    public UnaryCallable<ListExecutionsRequest, ExecutionsClient.ListExecutionsPagedResponse> listExecutionsPagedCallable() {
        return this.listExecutionsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteExecutionRequest, Operation> deleteExecutionCallable() {
        return this.deleteExecutionCallable;
    }

    @Override
    public OperationCallable<DeleteExecutionRequest, Execution, Execution> deleteExecutionOperationCallable() {
        return this.deleteExecutionOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

