/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.AcceptTermsRequest;
import com.google.cloud.retail.v2alpha.AlertConfig;
import com.google.cloud.retail.v2alpha.EnrollSolutionMetadata;
import com.google.cloud.retail.v2alpha.EnrollSolutionRequest;
import com.google.cloud.retail.v2alpha.EnrollSolutionResponse;
import com.google.cloud.retail.v2alpha.GetAlertConfigRequest;
import com.google.cloud.retail.v2alpha.GetLoggingConfigRequest;
import com.google.cloud.retail.v2alpha.GetProjectRequest;
import com.google.cloud.retail.v2alpha.ListEnrolledSolutionsRequest;
import com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse;
import com.google.cloud.retail.v2alpha.LoggingConfig;
import com.google.cloud.retail.v2alpha.Project;
import com.google.cloud.retail.v2alpha.UpdateAlertConfigRequest;
import com.google.cloud.retail.v2alpha.UpdateLoggingConfigRequest;
import com.google.cloud.retail.v2alpha.stub.HttpJsonProjectServiceCallableFactory;
import com.google.cloud.retail.v2alpha.stub.ProjectServiceStub;
import com.google.cloud.retail.v2alpha.stub.ProjectServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonProjectServiceStub
extends ProjectServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(EnrollSolutionMetadata.getDescriptor()).add(EnrollSolutionResponse.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetProjectRequest, Project> getProjectMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.ProjectService/GetProject").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{name=projects/*/retailProject}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Project.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<AcceptTermsRequest, Project> acceptTermsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.ProjectService/AcceptTerms").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{project=projects/*/retailProject}:acceptTerms", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProject().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Project.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<EnrollSolutionRequest, Operation> enrollSolutionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.ProjectService/EnrollSolution").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{project=projects/*}:enrollSolution", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearProject().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListEnrolledSolutionsRequest, ListEnrolledSolutionsResponse> listEnrolledSolutionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.ProjectService/ListEnrolledSolutions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{parent=projects/*}:enrolledSolutions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListEnrolledSolutionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLoggingConfigRequest, LoggingConfig> getLoggingConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.ProjectService/GetLoggingConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{name=projects/*/loggingConfig}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)LoggingConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateLoggingConfigRequest, LoggingConfig> updateLoggingConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.ProjectService/UpdateLoggingConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{loggingConfig.name=projects/*/loggingConfig}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "loggingConfig.name", (Object)request.getLoggingConfig().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("loggingConfig", (Message)request.getLoggingConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)LoggingConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetAlertConfigRequest, AlertConfig> getAlertConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.ProjectService/GetAlertConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{name=projects/*/alertConfig}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AlertConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2alpha.ProjectService/UpdateAlertConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2alpha/{alertConfig.name=projects/*/alertConfig}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "alertConfig.name", (Object)request.getAlertConfig().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("alertConfig", (Message)request.getAlertConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)AlertConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetProjectRequest, Project> getProjectCallable;
    private final UnaryCallable<AcceptTermsRequest, Project> acceptTermsCallable;
    private final UnaryCallable<EnrollSolutionRequest, Operation> enrollSolutionCallable;
    private final OperationCallable<EnrollSolutionRequest, EnrollSolutionResponse, EnrollSolutionMetadata> enrollSolutionOperationCallable;
    private final UnaryCallable<ListEnrolledSolutionsRequest, ListEnrolledSolutionsResponse> listEnrolledSolutionsCallable;
    private final UnaryCallable<GetLoggingConfigRequest, LoggingConfig> getLoggingConfigCallable;
    private final UnaryCallable<UpdateLoggingConfigRequest, LoggingConfig> updateLoggingConfigCallable;
    private final UnaryCallable<GetAlertConfigRequest, AlertConfig> getAlertConfigCallable;
    private final UnaryCallable<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonProjectServiceStub create(ProjectServiceStubSettings settings) throws IOException {
        return new HttpJsonProjectServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonProjectServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonProjectServiceStub(ProjectServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonProjectServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonProjectServiceStub(ProjectServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonProjectServiceStub(ProjectServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonProjectServiceCallableFactory());
    }

    protected HttpJsonProjectServiceStub(ProjectServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v2alpha/{name=projects/*/locations/*/catalogs/*/branches/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v2alpha/{name=projects/*/locations/*/catalogs/*/branches/*/places/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v2alpha/{name=projects/*/locations/*/catalogs/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v2alpha/{name=projects/*/locations/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v2alpha/{name=projects/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v2alpha/{name=projects/*/locations/*/catalogs/*}/operations").addAdditionalBindings(HttpRule.newBuilder().setGet("/v2alpha/{name=projects/*/locations/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v2alpha/{name=projects/*}/operations").build()).build()).build());
        HttpJsonCallSettings getProjectTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getProjectMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings acceptTermsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(acceptTermsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings enrollSolutionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(enrollSolutionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listEnrolledSolutionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listEnrolledSolutionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLoggingConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLoggingConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateLoggingConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateLoggingConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("logging_config.name", String.valueOf(request.getLoggingConfig().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getAlertConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getAlertConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateAlertConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateAlertConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("alert_config.name", String.valueOf(request.getAlertConfig().getName()));
            return builder.build();
        }).build();
        this.getProjectCallable = callableFactory.createUnaryCallable(getProjectTransportSettings, settings.getProjectSettings(), clientContext);
        this.acceptTermsCallable = callableFactory.createUnaryCallable(acceptTermsTransportSettings, settings.acceptTermsSettings(), clientContext);
        this.enrollSolutionCallable = callableFactory.createUnaryCallable(enrollSolutionTransportSettings, settings.enrollSolutionSettings(), clientContext);
        this.enrollSolutionOperationCallable = callableFactory.createOperationCallable(enrollSolutionTransportSettings, settings.enrollSolutionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listEnrolledSolutionsCallable = callableFactory.createUnaryCallable(listEnrolledSolutionsTransportSettings, settings.listEnrolledSolutionsSettings(), clientContext);
        this.getLoggingConfigCallable = callableFactory.createUnaryCallable(getLoggingConfigTransportSettings, settings.getLoggingConfigSettings(), clientContext);
        this.updateLoggingConfigCallable = callableFactory.createUnaryCallable(updateLoggingConfigTransportSettings, settings.updateLoggingConfigSettings(), clientContext);
        this.getAlertConfigCallable = callableFactory.createUnaryCallable(getAlertConfigTransportSettings, settings.getAlertConfigSettings(), clientContext);
        this.updateAlertConfigCallable = callableFactory.createUnaryCallable(updateAlertConfigTransportSettings, settings.updateAlertConfigSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getProjectMethodDescriptor);
        methodDescriptors.add(acceptTermsMethodDescriptor);
        methodDescriptors.add(enrollSolutionMethodDescriptor);
        methodDescriptors.add(listEnrolledSolutionsMethodDescriptor);
        methodDescriptors.add(getLoggingConfigMethodDescriptor);
        methodDescriptors.add(updateLoggingConfigMethodDescriptor);
        methodDescriptors.add(getAlertConfigMethodDescriptor);
        methodDescriptors.add(updateAlertConfigMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetProjectRequest, Project> getProjectCallable() {
        return this.getProjectCallable;
    }

    @Override
    public UnaryCallable<AcceptTermsRequest, Project> acceptTermsCallable() {
        return this.acceptTermsCallable;
    }

    @Override
    public UnaryCallable<EnrollSolutionRequest, Operation> enrollSolutionCallable() {
        return this.enrollSolutionCallable;
    }

    @Override
    public OperationCallable<EnrollSolutionRequest, EnrollSolutionResponse, EnrollSolutionMetadata> enrollSolutionOperationCallable() {
        return this.enrollSolutionOperationCallable;
    }

    @Override
    public UnaryCallable<ListEnrolledSolutionsRequest, ListEnrolledSolutionsResponse> listEnrolledSolutionsCallable() {
        return this.listEnrolledSolutionsCallable;
    }

    @Override
    public UnaryCallable<GetLoggingConfigRequest, LoggingConfig> getLoggingConfigCallable() {
        return this.getLoggingConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateLoggingConfigRequest, LoggingConfig> updateLoggingConfigCallable() {
        return this.updateLoggingConfigCallable;
    }

    @Override
    public UnaryCallable<GetAlertConfigRequest, AlertConfig> getAlertConfigCallable() {
        return this.getAlertConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigCallable() {
        return this.updateAlertConfigCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

