/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.AcceptTermsRequest;
import com.google.cloud.retail.v2alpha.AlertConfig;
import com.google.cloud.retail.v2alpha.EnrollSolutionMetadata;
import com.google.cloud.retail.v2alpha.EnrollSolutionRequest;
import com.google.cloud.retail.v2alpha.EnrollSolutionResponse;
import com.google.cloud.retail.v2alpha.GetAlertConfigRequest;
import com.google.cloud.retail.v2alpha.GetLoggingConfigRequest;
import com.google.cloud.retail.v2alpha.GetProjectRequest;
import com.google.cloud.retail.v2alpha.ListEnrolledSolutionsRequest;
import com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse;
import com.google.cloud.retail.v2alpha.LoggingConfig;
import com.google.cloud.retail.v2alpha.Project;
import com.google.cloud.retail.v2alpha.UpdateAlertConfigRequest;
import com.google.cloud.retail.v2alpha.UpdateLoggingConfigRequest;
import com.google.cloud.retail.v2alpha.stub.GrpcProjectServiceCallableFactory;
import com.google.cloud.retail.v2alpha.stub.ProjectServiceStub;
import com.google.cloud.retail.v2alpha.stub.ProjectServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcProjectServiceStub
extends ProjectServiceStub {
    private static final MethodDescriptor<GetProjectRequest, Project> getProjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProjectService/GetProject").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Project.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<AcceptTermsRequest, Project> acceptTermsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProjectService/AcceptTerms").setRequestMarshaller(ProtoUtils.marshaller((Message)AcceptTermsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Project.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<EnrollSolutionRequest, Operation> enrollSolutionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProjectService/EnrollSolution").setRequestMarshaller(ProtoUtils.marshaller((Message)EnrollSolutionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListEnrolledSolutionsRequest, ListEnrolledSolutionsResponse> listEnrolledSolutionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProjectService/ListEnrolledSolutions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEnrolledSolutionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEnrolledSolutionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLoggingConfigRequest, LoggingConfig> getLoggingConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProjectService/GetLoggingConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLoggingConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LoggingConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateLoggingConfigRequest, LoggingConfig> updateLoggingConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProjectService/UpdateLoggingConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateLoggingConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LoggingConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetAlertConfigRequest, AlertConfig> getAlertConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProjectService/GetAlertConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAlertConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AlertConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProjectService/UpdateAlertConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAlertConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AlertConfig.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetProjectRequest, Project> getProjectCallable;
    private final UnaryCallable<AcceptTermsRequest, Project> acceptTermsCallable;
    private final UnaryCallable<EnrollSolutionRequest, Operation> enrollSolutionCallable;
    private final OperationCallable<EnrollSolutionRequest, EnrollSolutionResponse, EnrollSolutionMetadata> enrollSolutionOperationCallable;
    private final UnaryCallable<ListEnrolledSolutionsRequest, ListEnrolledSolutionsResponse> listEnrolledSolutionsCallable;
    private final UnaryCallable<GetLoggingConfigRequest, LoggingConfig> getLoggingConfigCallable;
    private final UnaryCallable<UpdateLoggingConfigRequest, LoggingConfig> updateLoggingConfigCallable;
    private final UnaryCallable<GetAlertConfigRequest, AlertConfig> getAlertConfigCallable;
    private final UnaryCallable<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProjectServiceStub create(ProjectServiceStubSettings settings) throws IOException {
        return new GrpcProjectServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProjectServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcProjectServiceStub(ProjectServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProjectServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProjectServiceStub(ProjectServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProjectServiceStub(ProjectServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcProjectServiceCallableFactory());
    }

    protected GrpcProjectServiceStub(ProjectServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getProjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings acceptTermsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(acceptTermsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        GrpcCallSettings enrollSolutionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(enrollSolutionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            return builder.build();
        }).build();
        GrpcCallSettings listEnrolledSolutionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEnrolledSolutionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getLoggingConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLoggingConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateLoggingConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateLoggingConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("logging_config.name", String.valueOf(request.getLoggingConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getAlertConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAlertConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateAlertConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAlertConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("alert_config.name", String.valueOf(request.getAlertConfig().getName()));
            return builder.build();
        }).build();
        this.getProjectCallable = callableFactory.createUnaryCallable(getProjectTransportSettings, settings.getProjectSettings(), clientContext);
        this.acceptTermsCallable = callableFactory.createUnaryCallable(acceptTermsTransportSettings, settings.acceptTermsSettings(), clientContext);
        this.enrollSolutionCallable = callableFactory.createUnaryCallable(enrollSolutionTransportSettings, settings.enrollSolutionSettings(), clientContext);
        this.enrollSolutionOperationCallable = callableFactory.createOperationCallable(enrollSolutionTransportSettings, settings.enrollSolutionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listEnrolledSolutionsCallable = callableFactory.createUnaryCallable(listEnrolledSolutionsTransportSettings, settings.listEnrolledSolutionsSettings(), clientContext);
        this.getLoggingConfigCallable = callableFactory.createUnaryCallable(getLoggingConfigTransportSettings, settings.getLoggingConfigSettings(), clientContext);
        this.updateLoggingConfigCallable = callableFactory.createUnaryCallable(updateLoggingConfigTransportSettings, settings.updateLoggingConfigSettings(), clientContext);
        this.getAlertConfigCallable = callableFactory.createUnaryCallable(getAlertConfigTransportSettings, settings.getAlertConfigSettings(), clientContext);
        this.updateAlertConfigCallable = callableFactory.createUnaryCallable(updateAlertConfigTransportSettings, settings.updateAlertConfigSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetProjectRequest, Project> getProjectCallable() {
        return this.getProjectCallable;
    }

    @Override
    public UnaryCallable<AcceptTermsRequest, Project> acceptTermsCallable() {
        return this.acceptTermsCallable;
    }

    @Override
    public UnaryCallable<EnrollSolutionRequest, Operation> enrollSolutionCallable() {
        return this.enrollSolutionCallable;
    }

    @Override
    public OperationCallable<EnrollSolutionRequest, EnrollSolutionResponse, EnrollSolutionMetadata> enrollSolutionOperationCallable() {
        return this.enrollSolutionOperationCallable;
    }

    @Override
    public UnaryCallable<ListEnrolledSolutionsRequest, ListEnrolledSolutionsResponse> listEnrolledSolutionsCallable() {
        return this.listEnrolledSolutionsCallable;
    }

    @Override
    public UnaryCallable<GetLoggingConfigRequest, LoggingConfig> getLoggingConfigCallable() {
        return this.getLoggingConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateLoggingConfigRequest, LoggingConfig> updateLoggingConfigCallable() {
        return this.updateLoggingConfigCallable;
    }

    @Override
    public UnaryCallable<GetAlertConfigRequest, AlertConfig> getAlertConfigCallable() {
        return this.getAlertConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigCallable() {
        return this.updateAlertConfigCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

