/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2.BatchUpdateGenerativeQuestionConfigsRequest;
import com.google.cloud.retail.v2.BatchUpdateGenerativeQuestionConfigsResponse;
import com.google.cloud.retail.v2.CatalogName;
import com.google.cloud.retail.v2.GenerativeQuestionConfig;
import com.google.cloud.retail.v2.GenerativeQuestionServiceSettings;
import com.google.cloud.retail.v2.GenerativeQuestionsFeatureConfig;
import com.google.cloud.retail.v2.GetGenerativeQuestionsFeatureConfigRequest;
import com.google.cloud.retail.v2.ListGenerativeQuestionConfigsRequest;
import com.google.cloud.retail.v2.ListGenerativeQuestionConfigsResponse;
import com.google.cloud.retail.v2.UpdateGenerativeQuestionConfigRequest;
import com.google.cloud.retail.v2.UpdateGenerativeQuestionsFeatureConfigRequest;
import com.google.cloud.retail.v2.stub.GenerativeQuestionServiceStub;
import com.google.cloud.retail.v2.stub.GenerativeQuestionServiceStubSettings;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class GenerativeQuestionServiceClient
implements BackgroundResource {
    private final GenerativeQuestionServiceSettings settings;
    private final GenerativeQuestionServiceStub stub;

    public static final GenerativeQuestionServiceClient create() throws IOException {
        return GenerativeQuestionServiceClient.create(GenerativeQuestionServiceSettings.newBuilder().build());
    }

    public static final GenerativeQuestionServiceClient create(GenerativeQuestionServiceSettings settings) throws IOException {
        return new GenerativeQuestionServiceClient(settings);
    }

    public static final GenerativeQuestionServiceClient create(GenerativeQuestionServiceStub stub) {
        return new GenerativeQuestionServiceClient(stub);
    }

    protected GenerativeQuestionServiceClient(GenerativeQuestionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GenerativeQuestionServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected GenerativeQuestionServiceClient(GenerativeQuestionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GenerativeQuestionServiceSettings getSettings() {
        return this.settings;
    }

    public GenerativeQuestionServiceStub getStub() {
        return this.stub;
    }

    public final GenerativeQuestionsFeatureConfig updateGenerativeQuestionsFeatureConfig(GenerativeQuestionsFeatureConfig generativeQuestionsFeatureConfig, FieldMask updateMask) {
        UpdateGenerativeQuestionsFeatureConfigRequest request = UpdateGenerativeQuestionsFeatureConfigRequest.newBuilder().setGenerativeQuestionsFeatureConfig(generativeQuestionsFeatureConfig).setUpdateMask(updateMask).build();
        return this.updateGenerativeQuestionsFeatureConfig(request);
    }

    public final GenerativeQuestionsFeatureConfig updateGenerativeQuestionsFeatureConfig(UpdateGenerativeQuestionsFeatureConfigRequest request) {
        return (GenerativeQuestionsFeatureConfig)this.updateGenerativeQuestionsFeatureConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGenerativeQuestionsFeatureConfigRequest, GenerativeQuestionsFeatureConfig> updateGenerativeQuestionsFeatureConfigCallable() {
        return this.stub.updateGenerativeQuestionsFeatureConfigCallable();
    }

    public final GenerativeQuestionsFeatureConfig getGenerativeQuestionsFeatureConfig(CatalogName catalog) {
        GetGenerativeQuestionsFeatureConfigRequest request = GetGenerativeQuestionsFeatureConfigRequest.newBuilder().setCatalog(catalog == null ? null : catalog.toString()).build();
        return this.getGenerativeQuestionsFeatureConfig(request);
    }

    public final GenerativeQuestionsFeatureConfig getGenerativeQuestionsFeatureConfig(String catalog) {
        GetGenerativeQuestionsFeatureConfigRequest request = GetGenerativeQuestionsFeatureConfigRequest.newBuilder().setCatalog(catalog).build();
        return this.getGenerativeQuestionsFeatureConfig(request);
    }

    public final GenerativeQuestionsFeatureConfig getGenerativeQuestionsFeatureConfig(GetGenerativeQuestionsFeatureConfigRequest request) {
        return (GenerativeQuestionsFeatureConfig)this.getGenerativeQuestionsFeatureConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetGenerativeQuestionsFeatureConfigRequest, GenerativeQuestionsFeatureConfig> getGenerativeQuestionsFeatureConfigCallable() {
        return this.stub.getGenerativeQuestionsFeatureConfigCallable();
    }

    public final ListGenerativeQuestionConfigsResponse listGenerativeQuestionConfigs(CatalogName parent) {
        ListGenerativeQuestionConfigsRequest request = ListGenerativeQuestionConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGenerativeQuestionConfigs(request);
    }

    public final ListGenerativeQuestionConfigsResponse listGenerativeQuestionConfigs(String parent) {
        ListGenerativeQuestionConfigsRequest request = ListGenerativeQuestionConfigsRequest.newBuilder().setParent(parent).build();
        return this.listGenerativeQuestionConfigs(request);
    }

    public final ListGenerativeQuestionConfigsResponse listGenerativeQuestionConfigs(ListGenerativeQuestionConfigsRequest request) {
        return (ListGenerativeQuestionConfigsResponse)this.listGenerativeQuestionConfigsCallable().call((Object)request);
    }

    public final UnaryCallable<ListGenerativeQuestionConfigsRequest, ListGenerativeQuestionConfigsResponse> listGenerativeQuestionConfigsCallable() {
        return this.stub.listGenerativeQuestionConfigsCallable();
    }

    public final GenerativeQuestionConfig updateGenerativeQuestionConfig(GenerativeQuestionConfig generativeQuestionConfig, FieldMask updateMask) {
        UpdateGenerativeQuestionConfigRequest request = UpdateGenerativeQuestionConfigRequest.newBuilder().setGenerativeQuestionConfig(generativeQuestionConfig).setUpdateMask(updateMask).build();
        return this.updateGenerativeQuestionConfig(request);
    }

    public final GenerativeQuestionConfig updateGenerativeQuestionConfig(UpdateGenerativeQuestionConfigRequest request) {
        return (GenerativeQuestionConfig)this.updateGenerativeQuestionConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGenerativeQuestionConfigRequest, GenerativeQuestionConfig> updateGenerativeQuestionConfigCallable() {
        return this.stub.updateGenerativeQuestionConfigCallable();
    }

    public final BatchUpdateGenerativeQuestionConfigsResponse batchUpdateGenerativeQuestionConfigs(CatalogName parent, List<UpdateGenerativeQuestionConfigRequest> requests) {
        BatchUpdateGenerativeQuestionConfigsRequest request = BatchUpdateGenerativeQuestionConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllRequests(requests).build();
        return this.batchUpdateGenerativeQuestionConfigs(request);
    }

    public final BatchUpdateGenerativeQuestionConfigsResponse batchUpdateGenerativeQuestionConfigs(String parent, List<UpdateGenerativeQuestionConfigRequest> requests) {
        BatchUpdateGenerativeQuestionConfigsRequest request = BatchUpdateGenerativeQuestionConfigsRequest.newBuilder().setParent(parent).addAllRequests(requests).build();
        return this.batchUpdateGenerativeQuestionConfigs(request);
    }

    public final BatchUpdateGenerativeQuestionConfigsResponse batchUpdateGenerativeQuestionConfigs(BatchUpdateGenerativeQuestionConfigsRequest request) {
        return (BatchUpdateGenerativeQuestionConfigsResponse)this.batchUpdateGenerativeQuestionConfigsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchUpdateGenerativeQuestionConfigsRequest, BatchUpdateGenerativeQuestionConfigsResponse> batchUpdateGenerativeQuestionConfigsCallable() {
        return this.stub.batchUpdateGenerativeQuestionConfigsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

