/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.AcceptTermsRequest;
import com.google.cloud.retail.v2alpha.AlertConfig;
import com.google.cloud.retail.v2alpha.AlertConfigName;
import com.google.cloud.retail.v2alpha.EnrollSolutionMetadata;
import com.google.cloud.retail.v2alpha.EnrollSolutionRequest;
import com.google.cloud.retail.v2alpha.EnrollSolutionResponse;
import com.google.cloud.retail.v2alpha.GetAlertConfigRequest;
import com.google.cloud.retail.v2alpha.GetLoggingConfigRequest;
import com.google.cloud.retail.v2alpha.GetProjectRequest;
import com.google.cloud.retail.v2alpha.ListEnrolledSolutionsRequest;
import com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse;
import com.google.cloud.retail.v2alpha.LoggingConfig;
import com.google.cloud.retail.v2alpha.LoggingConfigName;
import com.google.cloud.retail.v2alpha.Project;
import com.google.cloud.retail.v2alpha.ProjectName;
import com.google.cloud.retail.v2alpha.ProjectServiceSettings;
import com.google.cloud.retail.v2alpha.RetailProjectName;
import com.google.cloud.retail.v2alpha.UpdateAlertConfigRequest;
import com.google.cloud.retail.v2alpha.UpdateLoggingConfigRequest;
import com.google.cloud.retail.v2alpha.stub.ProjectServiceStub;
import com.google.cloud.retail.v2alpha.stub.ProjectServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ProjectServiceClient
implements BackgroundResource {
    private final ProjectServiceSettings settings;
    private final ProjectServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ProjectServiceClient create() throws IOException {
        return ProjectServiceClient.create(ProjectServiceSettings.newBuilder().build());
    }

    public static final ProjectServiceClient create(ProjectServiceSettings settings) throws IOException {
        return new ProjectServiceClient(settings);
    }

    public static final ProjectServiceClient create(ProjectServiceStub stub) {
        return new ProjectServiceClient(stub);
    }

    protected ProjectServiceClient(ProjectServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ProjectServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ProjectServiceClient(ProjectServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ProjectServiceSettings getSettings() {
        return this.settings;
    }

    public ProjectServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Project getProject(RetailProjectName name) {
        GetProjectRequest request = GetProjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProject(request);
    }

    public final Project getProject(String name) {
        GetProjectRequest request = GetProjectRequest.newBuilder().setName(name).build();
        return this.getProject(request);
    }

    public final Project getProject(GetProjectRequest request) {
        return (Project)this.getProjectCallable().call((Object)request);
    }

    public final UnaryCallable<GetProjectRequest, Project> getProjectCallable() {
        return this.stub.getProjectCallable();
    }

    public final Project acceptTerms(RetailProjectName project) {
        AcceptTermsRequest request = AcceptTermsRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.acceptTerms(request);
    }

    public final Project acceptTerms(String project) {
        AcceptTermsRequest request = AcceptTermsRequest.newBuilder().setProject(project).build();
        return this.acceptTerms(request);
    }

    public final Project acceptTerms(AcceptTermsRequest request) {
        return (Project)this.acceptTermsCallable().call((Object)request);
    }

    public final UnaryCallable<AcceptTermsRequest, Project> acceptTermsCallable() {
        return this.stub.acceptTermsCallable();
    }

    public final OperationFuture<EnrollSolutionResponse, EnrollSolutionMetadata> enrollSolutionAsync(EnrollSolutionRequest request) {
        return this.enrollSolutionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EnrollSolutionRequest, EnrollSolutionResponse, EnrollSolutionMetadata> enrollSolutionOperationCallable() {
        return this.stub.enrollSolutionOperationCallable();
    }

    public final UnaryCallable<EnrollSolutionRequest, Operation> enrollSolutionCallable() {
        return this.stub.enrollSolutionCallable();
    }

    public final ListEnrolledSolutionsResponse listEnrolledSolutions(ProjectName parent) {
        ListEnrolledSolutionsRequest request = ListEnrolledSolutionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEnrolledSolutions(request);
    }

    public final ListEnrolledSolutionsResponse listEnrolledSolutions(String parent) {
        ListEnrolledSolutionsRequest request = ListEnrolledSolutionsRequest.newBuilder().setParent(parent).build();
        return this.listEnrolledSolutions(request);
    }

    public final ListEnrolledSolutionsResponse listEnrolledSolutions(ListEnrolledSolutionsRequest request) {
        return (ListEnrolledSolutionsResponse)this.listEnrolledSolutionsCallable().call((Object)request);
    }

    public final UnaryCallable<ListEnrolledSolutionsRequest, ListEnrolledSolutionsResponse> listEnrolledSolutionsCallable() {
        return this.stub.listEnrolledSolutionsCallable();
    }

    public final LoggingConfig getLoggingConfig(LoggingConfigName name) {
        GetLoggingConfigRequest request = GetLoggingConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getLoggingConfig(request);
    }

    public final LoggingConfig getLoggingConfig(String name) {
        GetLoggingConfigRequest request = GetLoggingConfigRequest.newBuilder().setName(name).build();
        return this.getLoggingConfig(request);
    }

    public final LoggingConfig getLoggingConfig(GetLoggingConfigRequest request) {
        return (LoggingConfig)this.getLoggingConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetLoggingConfigRequest, LoggingConfig> getLoggingConfigCallable() {
        return this.stub.getLoggingConfigCallable();
    }

    public final LoggingConfig updateLoggingConfig(LoggingConfig loggingConfig, FieldMask updateMask) {
        UpdateLoggingConfigRequest request = UpdateLoggingConfigRequest.newBuilder().setLoggingConfig(loggingConfig).setUpdateMask(updateMask).build();
        return this.updateLoggingConfig(request);
    }

    public final LoggingConfig updateLoggingConfig(UpdateLoggingConfigRequest request) {
        return (LoggingConfig)this.updateLoggingConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateLoggingConfigRequest, LoggingConfig> updateLoggingConfigCallable() {
        return this.stub.updateLoggingConfigCallable();
    }

    public final AlertConfig getAlertConfig(AlertConfigName name) {
        GetAlertConfigRequest request = GetAlertConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAlertConfig(request);
    }

    public final AlertConfig getAlertConfig(String name) {
        GetAlertConfigRequest request = GetAlertConfigRequest.newBuilder().setName(name).build();
        return this.getAlertConfig(request);
    }

    public final AlertConfig getAlertConfig(GetAlertConfigRequest request) {
        return (AlertConfig)this.getAlertConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetAlertConfigRequest, AlertConfig> getAlertConfigCallable() {
        return this.stub.getAlertConfigCallable();
    }

    public final AlertConfig updateAlertConfig(AlertConfig alertConfig, FieldMask updateMask) {
        UpdateAlertConfigRequest request = UpdateAlertConfigRequest.newBuilder().setAlertConfig(alertConfig).setUpdateMask(updateMask).build();
        return this.updateAlertConfig(request);
    }

    public final AlertConfig updateAlertConfig(UpdateAlertConfigRequest request) {
        return (AlertConfig)this.updateAlertConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigCallable() {
        return this.stub.updateAlertConfigCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

