/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.AddCatalogAttributeRequest;
import com.google.cloud.retail.v2beta.AttributesConfig;
import com.google.cloud.retail.v2beta.AttributesConfigName;
import com.google.cloud.retail.v2beta.BatchRemoveCatalogAttributesRequest;
import com.google.cloud.retail.v2beta.BatchRemoveCatalogAttributesResponse;
import com.google.cloud.retail.v2beta.Catalog;
import com.google.cloud.retail.v2beta.CatalogName;
import com.google.cloud.retail.v2beta.CatalogServiceSettings;
import com.google.cloud.retail.v2beta.CompletionConfig;
import com.google.cloud.retail.v2beta.CompletionConfigName;
import com.google.cloud.retail.v2beta.GetAttributesConfigRequest;
import com.google.cloud.retail.v2beta.GetCompletionConfigRequest;
import com.google.cloud.retail.v2beta.GetDefaultBranchRequest;
import com.google.cloud.retail.v2beta.GetDefaultBranchResponse;
import com.google.cloud.retail.v2beta.ListCatalogsRequest;
import com.google.cloud.retail.v2beta.ListCatalogsResponse;
import com.google.cloud.retail.v2beta.LocationName;
import com.google.cloud.retail.v2beta.RemoveCatalogAttributeRequest;
import com.google.cloud.retail.v2beta.ReplaceCatalogAttributeRequest;
import com.google.cloud.retail.v2beta.SetDefaultBranchRequest;
import com.google.cloud.retail.v2beta.UpdateAttributesConfigRequest;
import com.google.cloud.retail.v2beta.UpdateCatalogRequest;
import com.google.cloud.retail.v2beta.UpdateCompletionConfigRequest;
import com.google.cloud.retail.v2beta.stub.CatalogServiceStub;
import com.google.cloud.retail.v2beta.stub.CatalogServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CatalogServiceClient
implements BackgroundResource {
    private final CatalogServiceSettings settings;
    private final CatalogServiceStub stub;

    public static final CatalogServiceClient create() throws IOException {
        return CatalogServiceClient.create(CatalogServiceSettings.newBuilder().build());
    }

    public static final CatalogServiceClient create(CatalogServiceSettings settings) throws IOException {
        return new CatalogServiceClient(settings);
    }

    public static final CatalogServiceClient create(CatalogServiceStub stub) {
        return new CatalogServiceClient(stub);
    }

    protected CatalogServiceClient(CatalogServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CatalogServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CatalogServiceClient(CatalogServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CatalogServiceSettings getSettings() {
        return this.settings;
    }

    public CatalogServiceStub getStub() {
        return this.stub;
    }

    public final ListCatalogsPagedResponse listCatalogs(LocationName parent) {
        ListCatalogsRequest request = ListCatalogsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCatalogs(request);
    }

    public final ListCatalogsPagedResponse listCatalogs(String parent) {
        ListCatalogsRequest request = ListCatalogsRequest.newBuilder().setParent(parent).build();
        return this.listCatalogs(request);
    }

    public final ListCatalogsPagedResponse listCatalogs(ListCatalogsRequest request) {
        return (ListCatalogsPagedResponse)((Object)this.listCatalogsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCatalogsRequest, ListCatalogsPagedResponse> listCatalogsPagedCallable() {
        return this.stub.listCatalogsPagedCallable();
    }

    public final UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> listCatalogsCallable() {
        return this.stub.listCatalogsCallable();
    }

    public final Catalog updateCatalog(Catalog catalog, FieldMask updateMask) {
        UpdateCatalogRequest request = UpdateCatalogRequest.newBuilder().setCatalog(catalog).setUpdateMask(updateMask).build();
        return this.updateCatalog(request);
    }

    public final Catalog updateCatalog(UpdateCatalogRequest request) {
        return (Catalog)this.updateCatalogCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCatalogRequest, Catalog> updateCatalogCallable() {
        return this.stub.updateCatalogCallable();
    }

    public final void setDefaultBranch(CatalogName catalog) {
        SetDefaultBranchRequest request = SetDefaultBranchRequest.newBuilder().setCatalog(catalog == null ? null : catalog.toString()).build();
        this.setDefaultBranch(request);
    }

    public final void setDefaultBranch(String catalog) {
        SetDefaultBranchRequest request = SetDefaultBranchRequest.newBuilder().setCatalog(catalog).build();
        this.setDefaultBranch(request);
    }

    public final void setDefaultBranch(SetDefaultBranchRequest request) {
        this.setDefaultBranchCallable().call((Object)request);
    }

    public final UnaryCallable<SetDefaultBranchRequest, Empty> setDefaultBranchCallable() {
        return this.stub.setDefaultBranchCallable();
    }

    public final GetDefaultBranchResponse getDefaultBranch(CatalogName catalog) {
        GetDefaultBranchRequest request = GetDefaultBranchRequest.newBuilder().setCatalog(catalog == null ? null : catalog.toString()).build();
        return this.getDefaultBranch(request);
    }

    public final GetDefaultBranchResponse getDefaultBranch(String catalog) {
        GetDefaultBranchRequest request = GetDefaultBranchRequest.newBuilder().setCatalog(catalog).build();
        return this.getDefaultBranch(request);
    }

    public final GetDefaultBranchResponse getDefaultBranch(GetDefaultBranchRequest request) {
        return (GetDefaultBranchResponse)this.getDefaultBranchCallable().call((Object)request);
    }

    public final UnaryCallable<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchCallable() {
        return this.stub.getDefaultBranchCallable();
    }

    public final CompletionConfig getCompletionConfig(CompletionConfigName name) {
        GetCompletionConfigRequest request = GetCompletionConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCompletionConfig(request);
    }

    public final CompletionConfig getCompletionConfig(String name) {
        GetCompletionConfigRequest request = GetCompletionConfigRequest.newBuilder().setName(name).build();
        return this.getCompletionConfig(request);
    }

    public final CompletionConfig getCompletionConfig(GetCompletionConfigRequest request) {
        return (CompletionConfig)this.getCompletionConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetCompletionConfigRequest, CompletionConfig> getCompletionConfigCallable() {
        return this.stub.getCompletionConfigCallable();
    }

    public final CompletionConfig updateCompletionConfig(CompletionConfig completionConfig, FieldMask updateMask) {
        UpdateCompletionConfigRequest request = UpdateCompletionConfigRequest.newBuilder().setCompletionConfig(completionConfig).setUpdateMask(updateMask).build();
        return this.updateCompletionConfig(request);
    }

    public final CompletionConfig updateCompletionConfig(UpdateCompletionConfigRequest request) {
        return (CompletionConfig)this.updateCompletionConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCompletionConfigRequest, CompletionConfig> updateCompletionConfigCallable() {
        return this.stub.updateCompletionConfigCallable();
    }

    public final AttributesConfig getAttributesConfig(AttributesConfigName name) {
        GetAttributesConfigRequest request = GetAttributesConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAttributesConfig(request);
    }

    public final AttributesConfig getAttributesConfig(String name) {
        GetAttributesConfigRequest request = GetAttributesConfigRequest.newBuilder().setName(name).build();
        return this.getAttributesConfig(request);
    }

    public final AttributesConfig getAttributesConfig(GetAttributesConfigRequest request) {
        return (AttributesConfig)this.getAttributesConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetAttributesConfigRequest, AttributesConfig> getAttributesConfigCallable() {
        return this.stub.getAttributesConfigCallable();
    }

    public final AttributesConfig updateAttributesConfig(AttributesConfig attributesConfig, FieldMask updateMask) {
        UpdateAttributesConfigRequest request = UpdateAttributesConfigRequest.newBuilder().setAttributesConfig(attributesConfig).setUpdateMask(updateMask).build();
        return this.updateAttributesConfig(request);
    }

    public final AttributesConfig updateAttributesConfig(UpdateAttributesConfigRequest request) {
        return (AttributesConfig)this.updateAttributesConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAttributesConfigRequest, AttributesConfig> updateAttributesConfigCallable() {
        return this.stub.updateAttributesConfigCallable();
    }

    public final AttributesConfig addCatalogAttribute(AddCatalogAttributeRequest request) {
        return (AttributesConfig)this.addCatalogAttributeCallable().call((Object)request);
    }

    public final UnaryCallable<AddCatalogAttributeRequest, AttributesConfig> addCatalogAttributeCallable() {
        return this.stub.addCatalogAttributeCallable();
    }

    public final AttributesConfig removeCatalogAttribute(RemoveCatalogAttributeRequest request) {
        return (AttributesConfig)this.removeCatalogAttributeCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveCatalogAttributeRequest, AttributesConfig> removeCatalogAttributeCallable() {
        return this.stub.removeCatalogAttributeCallable();
    }

    public final BatchRemoveCatalogAttributesResponse batchRemoveCatalogAttributes(BatchRemoveCatalogAttributesRequest request) {
        return (BatchRemoveCatalogAttributesResponse)this.batchRemoveCatalogAttributesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchRemoveCatalogAttributesRequest, BatchRemoveCatalogAttributesResponse> batchRemoveCatalogAttributesCallable() {
        return this.stub.batchRemoveCatalogAttributesCallable();
    }

    public final AttributesConfig replaceCatalogAttribute(ReplaceCatalogAttributeRequest request) {
        return (AttributesConfig)this.replaceCatalogAttributeCallable().call((Object)request);
    }

    public final UnaryCallable<ReplaceCatalogAttributeRequest, AttributesConfig> replaceCatalogAttributeCallable() {
        return this.stub.replaceCatalogAttributeCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCatalogsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCatalogsRequest, ListCatalogsResponse, Catalog, ListCatalogsPage, ListCatalogsFixedSizeCollection> {
        private ListCatalogsFixedSizeCollection(List<ListCatalogsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCatalogsFixedSizeCollection createEmptyCollection() {
            return new ListCatalogsFixedSizeCollection(null, 0);
        }

        protected ListCatalogsFixedSizeCollection createCollection(List<ListCatalogsPage> pages, int collectionSize) {
            return new ListCatalogsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCatalogsPage
    extends AbstractPage<ListCatalogsRequest, ListCatalogsResponse, Catalog, ListCatalogsPage> {
        private ListCatalogsPage(PageContext<ListCatalogsRequest, ListCatalogsResponse, Catalog> context, ListCatalogsResponse response) {
            super(context, (Object)response);
        }

        private static ListCatalogsPage createEmptyPage() {
            return new ListCatalogsPage(null, null);
        }

        protected ListCatalogsPage createPage(PageContext<ListCatalogsRequest, ListCatalogsResponse, Catalog> context, ListCatalogsResponse response) {
            return new ListCatalogsPage(context, response);
        }

        public ApiFuture<ListCatalogsPage> createPageAsync(PageContext<ListCatalogsRequest, ListCatalogsResponse, Catalog> context, ApiFuture<ListCatalogsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCatalogsPagedResponse
    extends AbstractPagedListResponse<ListCatalogsRequest, ListCatalogsResponse, Catalog, ListCatalogsPage, ListCatalogsFixedSizeCollection> {
        public static ApiFuture<ListCatalogsPagedResponse> createAsync(PageContext<ListCatalogsRequest, ListCatalogsResponse, Catalog> context, ApiFuture<ListCatalogsResponse> futureResponse) {
            ApiFuture<ListCatalogsPage> futurePage = ListCatalogsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCatalogsPagedResponse((ListCatalogsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCatalogsPagedResponse(ListCatalogsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCatalogsFixedSizeCollection.createEmptyCollection());
        }
    }
}

