/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.AddControlRequest;
import com.google.cloud.retail.v2beta.CreateServingConfigRequest;
import com.google.cloud.retail.v2beta.DeleteServingConfigRequest;
import com.google.cloud.retail.v2beta.GetServingConfigRequest;
import com.google.cloud.retail.v2beta.ListServingConfigsRequest;
import com.google.cloud.retail.v2beta.ListServingConfigsResponse;
import com.google.cloud.retail.v2beta.RemoveControlRequest;
import com.google.cloud.retail.v2beta.ServingConfig;
import com.google.cloud.retail.v2beta.ServingConfigServiceClient;
import com.google.cloud.retail.v2beta.UpdateServingConfigRequest;
import com.google.cloud.retail.v2beta.stub.GrpcServingConfigServiceCallableFactory;
import com.google.cloud.retail.v2beta.stub.ServingConfigServiceStub;
import com.google.cloud.retail.v2beta.stub.ServingConfigServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcServingConfigServiceStub
extends ServingConfigServiceStub {
    private static final MethodDescriptor<CreateServingConfigRequest, ServingConfig> createServingConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2beta.ServingConfigService/CreateServingConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateServingConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ServingConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteServingConfigRequest, Empty> deleteServingConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2beta.ServingConfigService/DeleteServingConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteServingConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateServingConfigRequest, ServingConfig> updateServingConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2beta.ServingConfigService/UpdateServingConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateServingConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ServingConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<GetServingConfigRequest, ServingConfig> getServingConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2beta.ServingConfigService/GetServingConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetServingConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ServingConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<ListServingConfigsRequest, ListServingConfigsResponse> listServingConfigsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2beta.ServingConfigService/ListServingConfigs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListServingConfigsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListServingConfigsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<AddControlRequest, ServingConfig> addControlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2beta.ServingConfigService/AddControl").setRequestMarshaller(ProtoUtils.marshaller((Message)AddControlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ServingConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<RemoveControlRequest, ServingConfig> removeControlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2beta.ServingConfigService/RemoveControl").setRequestMarshaller(ProtoUtils.marshaller((Message)RemoveControlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ServingConfig.getDefaultInstance())).build();
    private final UnaryCallable<CreateServingConfigRequest, ServingConfig> createServingConfigCallable;
    private final UnaryCallable<DeleteServingConfigRequest, Empty> deleteServingConfigCallable;
    private final UnaryCallable<UpdateServingConfigRequest, ServingConfig> updateServingConfigCallable;
    private final UnaryCallable<GetServingConfigRequest, ServingConfig> getServingConfigCallable;
    private final UnaryCallable<ListServingConfigsRequest, ListServingConfigsResponse> listServingConfigsCallable;
    private final UnaryCallable<ListServingConfigsRequest, ServingConfigServiceClient.ListServingConfigsPagedResponse> listServingConfigsPagedCallable;
    private final UnaryCallable<AddControlRequest, ServingConfig> addControlCallable;
    private final UnaryCallable<RemoveControlRequest, ServingConfig> removeControlCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcServingConfigServiceStub create(ServingConfigServiceStubSettings settings) throws IOException {
        return new GrpcServingConfigServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcServingConfigServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcServingConfigServiceStub(ServingConfigServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcServingConfigServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcServingConfigServiceStub(ServingConfigServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcServingConfigServiceStub(ServingConfigServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcServingConfigServiceCallableFactory());
    }

    protected GrpcServingConfigServiceStub(ServingConfigServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createServingConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createServingConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteServingConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteServingConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateServingConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateServingConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("serving_config.name", String.valueOf(request.getServingConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getServingConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getServingConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listServingConfigsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listServingConfigsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings addControlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(addControlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("serving_config", String.valueOf(request.getServingConfig()));
            return builder.build();
        }).build();
        GrpcCallSettings removeControlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removeControlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("serving_config", String.valueOf(request.getServingConfig()));
            return builder.build();
        }).build();
        this.createServingConfigCallable = callableFactory.createUnaryCallable(createServingConfigTransportSettings, settings.createServingConfigSettings(), clientContext);
        this.deleteServingConfigCallable = callableFactory.createUnaryCallable(deleteServingConfigTransportSettings, settings.deleteServingConfigSettings(), clientContext);
        this.updateServingConfigCallable = callableFactory.createUnaryCallable(updateServingConfigTransportSettings, settings.updateServingConfigSettings(), clientContext);
        this.getServingConfigCallable = callableFactory.createUnaryCallable(getServingConfigTransportSettings, settings.getServingConfigSettings(), clientContext);
        this.listServingConfigsCallable = callableFactory.createUnaryCallable(listServingConfigsTransportSettings, settings.listServingConfigsSettings(), clientContext);
        this.listServingConfigsPagedCallable = callableFactory.createPagedCallable(listServingConfigsTransportSettings, settings.listServingConfigsSettings(), clientContext);
        this.addControlCallable = callableFactory.createUnaryCallable(addControlTransportSettings, settings.addControlSettings(), clientContext);
        this.removeControlCallable = callableFactory.createUnaryCallable(removeControlTransportSettings, settings.removeControlSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateServingConfigRequest, ServingConfig> createServingConfigCallable() {
        return this.createServingConfigCallable;
    }

    @Override
    public UnaryCallable<DeleteServingConfigRequest, Empty> deleteServingConfigCallable() {
        return this.deleteServingConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateServingConfigRequest, ServingConfig> updateServingConfigCallable() {
        return this.updateServingConfigCallable;
    }

    @Override
    public UnaryCallable<GetServingConfigRequest, ServingConfig> getServingConfigCallable() {
        return this.getServingConfigCallable;
    }

    @Override
    public UnaryCallable<ListServingConfigsRequest, ListServingConfigsResponse> listServingConfigsCallable() {
        return this.listServingConfigsCallable;
    }

    @Override
    public UnaryCallable<ListServingConfigsRequest, ServingConfigServiceClient.ListServingConfigsPagedResponse> listServingConfigsPagedCallable() {
        return this.listServingConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<AddControlRequest, ServingConfig> addControlCallable() {
        return this.addControlCallable;
    }

    @Override
    public UnaryCallable<RemoveControlRequest, ServingConfig> removeControlCallable() {
        return this.removeControlCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

