/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2.AddControlRequest;
import com.google.cloud.retail.v2.CatalogName;
import com.google.cloud.retail.v2.CreateServingConfigRequest;
import com.google.cloud.retail.v2.DeleteServingConfigRequest;
import com.google.cloud.retail.v2.GetServingConfigRequest;
import com.google.cloud.retail.v2.ListServingConfigsRequest;
import com.google.cloud.retail.v2.ListServingConfigsResponse;
import com.google.cloud.retail.v2.RemoveControlRequest;
import com.google.cloud.retail.v2.ServingConfig;
import com.google.cloud.retail.v2.ServingConfigName;
import com.google.cloud.retail.v2.ServingConfigServiceSettings;
import com.google.cloud.retail.v2.UpdateServingConfigRequest;
import com.google.cloud.retail.v2.stub.ServingConfigServiceStub;
import com.google.cloud.retail.v2.stub.ServingConfigServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ServingConfigServiceClient
implements BackgroundResource {
    private final ServingConfigServiceSettings settings;
    private final ServingConfigServiceStub stub;

    public static final ServingConfigServiceClient create() throws IOException {
        return ServingConfigServiceClient.create(ServingConfigServiceSettings.newBuilder().build());
    }

    public static final ServingConfigServiceClient create(ServingConfigServiceSettings settings) throws IOException {
        return new ServingConfigServiceClient(settings);
    }

    public static final ServingConfigServiceClient create(ServingConfigServiceStub stub) {
        return new ServingConfigServiceClient(stub);
    }

    protected ServingConfigServiceClient(ServingConfigServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ServingConfigServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ServingConfigServiceClient(ServingConfigServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ServingConfigServiceSettings getSettings() {
        return this.settings;
    }

    public ServingConfigServiceStub getStub() {
        return this.stub;
    }

    public final ServingConfig createServingConfig(CatalogName parent, ServingConfig servingConfig, String servingConfigId) {
        CreateServingConfigRequest request = CreateServingConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setServingConfig(servingConfig).setServingConfigId(servingConfigId).build();
        return this.createServingConfig(request);
    }

    public final ServingConfig createServingConfig(String parent, ServingConfig servingConfig, String servingConfigId) {
        CreateServingConfigRequest request = CreateServingConfigRequest.newBuilder().setParent(parent).setServingConfig(servingConfig).setServingConfigId(servingConfigId).build();
        return this.createServingConfig(request);
    }

    public final ServingConfig createServingConfig(CreateServingConfigRequest request) {
        return (ServingConfig)this.createServingConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateServingConfigRequest, ServingConfig> createServingConfigCallable() {
        return this.stub.createServingConfigCallable();
    }

    public final void deleteServingConfig(ServingConfigName name) {
        DeleteServingConfigRequest request = DeleteServingConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteServingConfig(request);
    }

    public final void deleteServingConfig(String name) {
        DeleteServingConfigRequest request = DeleteServingConfigRequest.newBuilder().setName(name).build();
        this.deleteServingConfig(request);
    }

    public final void deleteServingConfig(DeleteServingConfigRequest request) {
        this.deleteServingConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteServingConfigRequest, Empty> deleteServingConfigCallable() {
        return this.stub.deleteServingConfigCallable();
    }

    public final ServingConfig updateServingConfig(ServingConfig servingConfig, FieldMask updateMask) {
        UpdateServingConfigRequest request = UpdateServingConfigRequest.newBuilder().setServingConfig(servingConfig).setUpdateMask(updateMask).build();
        return this.updateServingConfig(request);
    }

    public final ServingConfig updateServingConfig(UpdateServingConfigRequest request) {
        return (ServingConfig)this.updateServingConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateServingConfigRequest, ServingConfig> updateServingConfigCallable() {
        return this.stub.updateServingConfigCallable();
    }

    public final ServingConfig getServingConfig(ServingConfigName name) {
        GetServingConfigRequest request = GetServingConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getServingConfig(request);
    }

    public final ServingConfig getServingConfig(String name) {
        GetServingConfigRequest request = GetServingConfigRequest.newBuilder().setName(name).build();
        return this.getServingConfig(request);
    }

    public final ServingConfig getServingConfig(GetServingConfigRequest request) {
        return (ServingConfig)this.getServingConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetServingConfigRequest, ServingConfig> getServingConfigCallable() {
        return this.stub.getServingConfigCallable();
    }

    public final ListServingConfigsPagedResponse listServingConfigs(CatalogName parent) {
        ListServingConfigsRequest request = ListServingConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServingConfigs(request);
    }

    public final ListServingConfigsPagedResponse listServingConfigs(String parent) {
        ListServingConfigsRequest request = ListServingConfigsRequest.newBuilder().setParent(parent).build();
        return this.listServingConfigs(request);
    }

    public final ListServingConfigsPagedResponse listServingConfigs(ListServingConfigsRequest request) {
        return (ListServingConfigsPagedResponse)((Object)this.listServingConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServingConfigsRequest, ListServingConfigsPagedResponse> listServingConfigsPagedCallable() {
        return this.stub.listServingConfigsPagedCallable();
    }

    public final UnaryCallable<ListServingConfigsRequest, ListServingConfigsResponse> listServingConfigsCallable() {
        return this.stub.listServingConfigsCallable();
    }

    public final ServingConfig addControl(ServingConfigName servingConfig) {
        AddControlRequest request = AddControlRequest.newBuilder().setServingConfig(servingConfig == null ? null : servingConfig.toString()).build();
        return this.addControl(request);
    }

    public final ServingConfig addControl(String servingConfig) {
        AddControlRequest request = AddControlRequest.newBuilder().setServingConfig(servingConfig).build();
        return this.addControl(request);
    }

    public final ServingConfig addControl(AddControlRequest request) {
        return (ServingConfig)this.addControlCallable().call((Object)request);
    }

    public final UnaryCallable<AddControlRequest, ServingConfig> addControlCallable() {
        return this.stub.addControlCallable();
    }

    public final ServingConfig removeControl(ServingConfigName servingConfig) {
        RemoveControlRequest request = RemoveControlRequest.newBuilder().setServingConfig(servingConfig == null ? null : servingConfig.toString()).build();
        return this.removeControl(request);
    }

    public final ServingConfig removeControl(String servingConfig) {
        RemoveControlRequest request = RemoveControlRequest.newBuilder().setServingConfig(servingConfig).build();
        return this.removeControl(request);
    }

    public final ServingConfig removeControl(RemoveControlRequest request) {
        return (ServingConfig)this.removeControlCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveControlRequest, ServingConfig> removeControlCallable() {
        return this.stub.removeControlCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListServingConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfig, ListServingConfigsPage, ListServingConfigsFixedSizeCollection> {
        private ListServingConfigsFixedSizeCollection(List<ListServingConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServingConfigsFixedSizeCollection createEmptyCollection() {
            return new ListServingConfigsFixedSizeCollection(null, 0);
        }

        protected ListServingConfigsFixedSizeCollection createCollection(List<ListServingConfigsPage> pages, int collectionSize) {
            return new ListServingConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServingConfigsPage
    extends AbstractPage<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfig, ListServingConfigsPage> {
        private ListServingConfigsPage(PageContext<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfig> context, ListServingConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListServingConfigsPage createEmptyPage() {
            return new ListServingConfigsPage(null, null);
        }

        protected ListServingConfigsPage createPage(PageContext<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfig> context, ListServingConfigsResponse response) {
            return new ListServingConfigsPage(context, response);
        }

        public ApiFuture<ListServingConfigsPage> createPageAsync(PageContext<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfig> context, ApiFuture<ListServingConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServingConfigsPagedResponse
    extends AbstractPagedListResponse<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfig, ListServingConfigsPage, ListServingConfigsFixedSizeCollection> {
        public static ApiFuture<ListServingConfigsPagedResponse> createAsync(PageContext<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfig> context, ApiFuture<ListServingConfigsResponse> futureResponse) {
            ApiFuture<ListServingConfigsPage> futurePage = ListServingConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServingConfigsPagedResponse((ListServingConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServingConfigsPagedResponse(ListServingConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServingConfigsFixedSizeCollection.createEmptyCollection());
        }
    }
}

