/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.AddCatalogAttributeRequest;
import com.google.cloud.retail.v2beta.AttributesConfig;
import com.google.cloud.retail.v2beta.BatchRemoveCatalogAttributesRequest;
import com.google.cloud.retail.v2beta.BatchRemoveCatalogAttributesResponse;
import com.google.cloud.retail.v2beta.Catalog;
import com.google.cloud.retail.v2beta.CatalogServiceClient;
import com.google.cloud.retail.v2beta.CompletionConfig;
import com.google.cloud.retail.v2beta.GetAttributesConfigRequest;
import com.google.cloud.retail.v2beta.GetCompletionConfigRequest;
import com.google.cloud.retail.v2beta.GetDefaultBranchRequest;
import com.google.cloud.retail.v2beta.GetDefaultBranchResponse;
import com.google.cloud.retail.v2beta.ListCatalogsRequest;
import com.google.cloud.retail.v2beta.ListCatalogsResponse;
import com.google.cloud.retail.v2beta.RemoveCatalogAttributeRequest;
import com.google.cloud.retail.v2beta.ReplaceCatalogAttributeRequest;
import com.google.cloud.retail.v2beta.SetDefaultBranchRequest;
import com.google.cloud.retail.v2beta.UpdateAttributesConfigRequest;
import com.google.cloud.retail.v2beta.UpdateCatalogRequest;
import com.google.cloud.retail.v2beta.UpdateCompletionConfigRequest;
import com.google.cloud.retail.v2beta.stub.CatalogServiceStub;
import com.google.cloud.retail.v2beta.stub.GrpcCatalogServiceStub;
import com.google.cloud.retail.v2beta.stub.HttpJsonCatalogServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class CatalogServiceStubSettings
extends StubSettings<CatalogServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsSettings;
    private final UnaryCallSettings<UpdateCatalogRequest, Catalog> updateCatalogSettings;
    private final UnaryCallSettings<SetDefaultBranchRequest, Empty> setDefaultBranchSettings;
    private final UnaryCallSettings<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchSettings;
    private final UnaryCallSettings<GetCompletionConfigRequest, CompletionConfig> getCompletionConfigSettings;
    private final UnaryCallSettings<UpdateCompletionConfigRequest, CompletionConfig> updateCompletionConfigSettings;
    private final UnaryCallSettings<GetAttributesConfigRequest, AttributesConfig> getAttributesConfigSettings;
    private final UnaryCallSettings<UpdateAttributesConfigRequest, AttributesConfig> updateAttributesConfigSettings;
    private final UnaryCallSettings<AddCatalogAttributeRequest, AttributesConfig> addCatalogAttributeSettings;
    private final UnaryCallSettings<RemoveCatalogAttributeRequest, AttributesConfig> removeCatalogAttributeSettings;
    private final UnaryCallSettings<BatchRemoveCatalogAttributesRequest, BatchRemoveCatalogAttributesResponse> batchRemoveCatalogAttributesSettings;
    private final UnaryCallSettings<ReplaceCatalogAttributeRequest, AttributesConfig> replaceCatalogAttributeSettings;
    private static final PagedListDescriptor<ListCatalogsRequest, ListCatalogsResponse, Catalog> LIST_CATALOGS_PAGE_STR_DESC = new PagedListDescriptor<ListCatalogsRequest, ListCatalogsResponse, Catalog>(){

        public String emptyToken() {
            return "";
        }

        public ListCatalogsRequest injectToken(ListCatalogsRequest payload, String token) {
            return ListCatalogsRequest.newBuilder((ListCatalogsRequest)payload).setPageToken(token).build();
        }

        public ListCatalogsRequest injectPageSize(ListCatalogsRequest payload, int pageSize) {
            return ListCatalogsRequest.newBuilder((ListCatalogsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCatalogsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCatalogsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Catalog> extractResources(ListCatalogsResponse payload) {
            return payload.getCatalogsList() == null ? ImmutableList.of() : payload.getCatalogsList();
        }
    };
    private static final PagedListResponseFactory<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse> LIST_CATALOGS_PAGE_STR_FACT = new PagedListResponseFactory<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse>(){

        public ApiFuture<CatalogServiceClient.ListCatalogsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> callable, ListCatalogsRequest request, ApiCallContext context, ApiFuture<ListCatalogsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CATALOGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CatalogServiceClient.ListCatalogsPagedResponse.createAsync((PageContext<ListCatalogsRequest, ListCatalogsResponse, Catalog>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsSettings() {
        return this.listCatalogsSettings;
    }

    public UnaryCallSettings<UpdateCatalogRequest, Catalog> updateCatalogSettings() {
        return this.updateCatalogSettings;
    }

    public UnaryCallSettings<SetDefaultBranchRequest, Empty> setDefaultBranchSettings() {
        return this.setDefaultBranchSettings;
    }

    public UnaryCallSettings<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchSettings() {
        return this.getDefaultBranchSettings;
    }

    public UnaryCallSettings<GetCompletionConfigRequest, CompletionConfig> getCompletionConfigSettings() {
        return this.getCompletionConfigSettings;
    }

    public UnaryCallSettings<UpdateCompletionConfigRequest, CompletionConfig> updateCompletionConfigSettings() {
        return this.updateCompletionConfigSettings;
    }

    public UnaryCallSettings<GetAttributesConfigRequest, AttributesConfig> getAttributesConfigSettings() {
        return this.getAttributesConfigSettings;
    }

    public UnaryCallSettings<UpdateAttributesConfigRequest, AttributesConfig> updateAttributesConfigSettings() {
        return this.updateAttributesConfigSettings;
    }

    public UnaryCallSettings<AddCatalogAttributeRequest, AttributesConfig> addCatalogAttributeSettings() {
        return this.addCatalogAttributeSettings;
    }

    public UnaryCallSettings<RemoveCatalogAttributeRequest, AttributesConfig> removeCatalogAttributeSettings() {
        return this.removeCatalogAttributeSettings;
    }

    public UnaryCallSettings<BatchRemoveCatalogAttributesRequest, BatchRemoveCatalogAttributesResponse> batchRemoveCatalogAttributesSettings() {
        return this.batchRemoveCatalogAttributesSettings;
    }

    public UnaryCallSettings<ReplaceCatalogAttributeRequest, AttributesConfig> replaceCatalogAttributeSettings() {
        return this.replaceCatalogAttributeSettings;
    }

    public CatalogServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCatalogServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCatalogServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return CatalogServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "retail";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "retail.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "retail.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CatalogServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CatalogServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CatalogServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CatalogServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CatalogServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listCatalogsSettings = settingsBuilder.listCatalogsSettings().build();
        this.updateCatalogSettings = settingsBuilder.updateCatalogSettings().build();
        this.setDefaultBranchSettings = settingsBuilder.setDefaultBranchSettings().build();
        this.getDefaultBranchSettings = settingsBuilder.getDefaultBranchSettings().build();
        this.getCompletionConfigSettings = settingsBuilder.getCompletionConfigSettings().build();
        this.updateCompletionConfigSettings = settingsBuilder.updateCompletionConfigSettings().build();
        this.getAttributesConfigSettings = settingsBuilder.getAttributesConfigSettings().build();
        this.updateAttributesConfigSettings = settingsBuilder.updateAttributesConfigSettings().build();
        this.addCatalogAttributeSettings = settingsBuilder.addCatalogAttributeSettings().build();
        this.removeCatalogAttributeSettings = settingsBuilder.removeCatalogAttributeSettings().build();
        this.batchRemoveCatalogAttributesSettings = settingsBuilder.batchRemoveCatalogAttributesSettings().build();
        this.replaceCatalogAttributeSettings = settingsBuilder.replaceCatalogAttributeSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CatalogServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsSettings;
        private final UnaryCallSettings.Builder<UpdateCatalogRequest, Catalog> updateCatalogSettings;
        private final UnaryCallSettings.Builder<SetDefaultBranchRequest, Empty> setDefaultBranchSettings;
        private final UnaryCallSettings.Builder<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchSettings;
        private final UnaryCallSettings.Builder<GetCompletionConfigRequest, CompletionConfig> getCompletionConfigSettings;
        private final UnaryCallSettings.Builder<UpdateCompletionConfigRequest, CompletionConfig> updateCompletionConfigSettings;
        private final UnaryCallSettings.Builder<GetAttributesConfigRequest, AttributesConfig> getAttributesConfigSettings;
        private final UnaryCallSettings.Builder<UpdateAttributesConfigRequest, AttributesConfig> updateAttributesConfigSettings;
        private final UnaryCallSettings.Builder<AddCatalogAttributeRequest, AttributesConfig> addCatalogAttributeSettings;
        private final UnaryCallSettings.Builder<RemoveCatalogAttributeRequest, AttributesConfig> removeCatalogAttributeSettings;
        private final UnaryCallSettings.Builder<BatchRemoveCatalogAttributesRequest, BatchRemoveCatalogAttributesResponse> batchRemoveCatalogAttributesSettings;
        private final UnaryCallSettings.Builder<ReplaceCatalogAttributeRequest, AttributesConfig> replaceCatalogAttributeSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listCatalogsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CATALOGS_PAGE_STR_FACT);
            this.updateCatalogSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDefaultBranchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDefaultBranchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getCompletionConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCompletionConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAttributesConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAttributesConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addCatalogAttributeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeCatalogAttributeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchRemoveCatalogAttributesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.replaceCatalogAttributeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCatalogsSettings, this.updateCatalogSettings, this.setDefaultBranchSettings, this.getDefaultBranchSettings, this.getCompletionConfigSettings, this.updateCompletionConfigSettings, this.getAttributesConfigSettings, this.updateAttributesConfigSettings, this.addCatalogAttributeSettings, this.removeCatalogAttributeSettings, this.batchRemoveCatalogAttributesSettings, this.replaceCatalogAttributeSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(CatalogServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listCatalogsSettings = settings.listCatalogsSettings.toBuilder();
            this.updateCatalogSettings = settings.updateCatalogSettings.toBuilder();
            this.setDefaultBranchSettings = settings.setDefaultBranchSettings.toBuilder();
            this.getDefaultBranchSettings = settings.getDefaultBranchSettings.toBuilder();
            this.getCompletionConfigSettings = settings.getCompletionConfigSettings.toBuilder();
            this.updateCompletionConfigSettings = settings.updateCompletionConfigSettings.toBuilder();
            this.getAttributesConfigSettings = settings.getAttributesConfigSettings.toBuilder();
            this.updateAttributesConfigSettings = settings.updateAttributesConfigSettings.toBuilder();
            this.addCatalogAttributeSettings = settings.addCatalogAttributeSettings.toBuilder();
            this.removeCatalogAttributeSettings = settings.removeCatalogAttributeSettings.toBuilder();
            this.batchRemoveCatalogAttributesSettings = settings.batchRemoveCatalogAttributesSettings.toBuilder();
            this.replaceCatalogAttributeSettings = settings.replaceCatalogAttributeSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCatalogsSettings, this.updateCatalogSettings, this.setDefaultBranchSettings, this.getDefaultBranchSettings, this.getCompletionConfigSettings, this.updateCompletionConfigSettings, this.getAttributesConfigSettings, this.updateAttributesConfigSettings, this.addCatalogAttributeSettings, this.removeCatalogAttributeSettings, this.batchRemoveCatalogAttributesSettings, this.replaceCatalogAttributeSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CatalogServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CatalogServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CatalogServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CatalogServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CatalogServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CatalogServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CatalogServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CatalogServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listCatalogsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateCatalogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setDefaultBranchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDefaultBranchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCompletionConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateCompletionConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAttributesConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateAttributesConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.addCatalogAttributeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.removeCatalogAttributeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchRemoveCatalogAttributesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.replaceCatalogAttributeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsSettings() {
            return this.listCatalogsSettings;
        }

        public UnaryCallSettings.Builder<UpdateCatalogRequest, Catalog> updateCatalogSettings() {
            return this.updateCatalogSettings;
        }

        public UnaryCallSettings.Builder<SetDefaultBranchRequest, Empty> setDefaultBranchSettings() {
            return this.setDefaultBranchSettings;
        }

        public UnaryCallSettings.Builder<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchSettings() {
            return this.getDefaultBranchSettings;
        }

        public UnaryCallSettings.Builder<GetCompletionConfigRequest, CompletionConfig> getCompletionConfigSettings() {
            return this.getCompletionConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateCompletionConfigRequest, CompletionConfig> updateCompletionConfigSettings() {
            return this.updateCompletionConfigSettings;
        }

        public UnaryCallSettings.Builder<GetAttributesConfigRequest, AttributesConfig> getAttributesConfigSettings() {
            return this.getAttributesConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateAttributesConfigRequest, AttributesConfig> updateAttributesConfigSettings() {
            return this.updateAttributesConfigSettings;
        }

        public UnaryCallSettings.Builder<AddCatalogAttributeRequest, AttributesConfig> addCatalogAttributeSettings() {
            return this.addCatalogAttributeSettings;
        }

        public UnaryCallSettings.Builder<RemoveCatalogAttributeRequest, AttributesConfig> removeCatalogAttributeSettings() {
            return this.removeCatalogAttributeSettings;
        }

        public UnaryCallSettings.Builder<BatchRemoveCatalogAttributesRequest, BatchRemoveCatalogAttributesResponse> batchRemoveCatalogAttributesSettings() {
            return this.batchRemoveCatalogAttributesSettings;
        }

        public UnaryCallSettings.Builder<ReplaceCatalogAttributeRequest, AttributesConfig> replaceCatalogAttributeSettings() {
            return this.replaceCatalogAttributeSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return CatalogServiceStubSettings.getDefaultEndpoint();
        }

        public CatalogServiceStubSettings build() throws IOException {
            return new CatalogServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ofMillis((long)5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)5000L)).setTotalTimeout(Duration.ofMillis((long)5000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

