/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateFolderMetadata;
import com.google.cloud.resourcemanager.v3.CreateFolderRequest;
import com.google.cloud.resourcemanager.v3.DeleteFolderMetadata;
import com.google.cloud.resourcemanager.v3.DeleteFolderRequest;
import com.google.cloud.resourcemanager.v3.Folder;
import com.google.cloud.resourcemanager.v3.FoldersClient;
import com.google.cloud.resourcemanager.v3.GetFolderRequest;
import com.google.cloud.resourcemanager.v3.ListFoldersRequest;
import com.google.cloud.resourcemanager.v3.ListFoldersResponse;
import com.google.cloud.resourcemanager.v3.MoveFolderMetadata;
import com.google.cloud.resourcemanager.v3.MoveFolderRequest;
import com.google.cloud.resourcemanager.v3.SearchFoldersRequest;
import com.google.cloud.resourcemanager.v3.SearchFoldersResponse;
import com.google.cloud.resourcemanager.v3.UndeleteFolderMetadata;
import com.google.cloud.resourcemanager.v3.UndeleteFolderRequest;
import com.google.cloud.resourcemanager.v3.UpdateFolderMetadata;
import com.google.cloud.resourcemanager.v3.UpdateFolderRequest;
import com.google.cloud.resourcemanager.v3.stub.FoldersStub;
import com.google.cloud.resourcemanager.v3.stub.FoldersStubSettings;
import com.google.cloud.resourcemanager.v3.stub.GrpcFoldersCallableFactory;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcFoldersStub
extends FoldersStub {
    private static final MethodDescriptor<GetFolderRequest, Folder> getFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Folders/GetFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)GetFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Folder.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListFoldersRequest, ListFoldersResponse> listFoldersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Folders/ListFolders").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFoldersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFoldersResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SearchFoldersRequest, SearchFoldersResponse> searchFoldersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Folders/SearchFolders").setRequestMarshaller(ProtoUtils.marshaller((Message)SearchFoldersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SearchFoldersResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateFolderRequest, Operation> createFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Folders/CreateFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateFolderRequest, Operation> updateFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Folders/UpdateFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<MoveFolderRequest, Operation> moveFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Folders/MoveFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)MoveFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteFolderRequest, Operation> deleteFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Folders/DeleteFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UndeleteFolderRequest, Operation> undeleteFolderMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Folders/UndeleteFolder").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeleteFolderRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Folders/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Folders/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.Folders/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetFolderRequest, Folder> getFolderCallable;
    private final UnaryCallable<ListFoldersRequest, ListFoldersResponse> listFoldersCallable;
    private final UnaryCallable<ListFoldersRequest, FoldersClient.ListFoldersPagedResponse> listFoldersPagedCallable;
    private final UnaryCallable<SearchFoldersRequest, SearchFoldersResponse> searchFoldersCallable;
    private final UnaryCallable<SearchFoldersRequest, FoldersClient.SearchFoldersPagedResponse> searchFoldersPagedCallable;
    private final UnaryCallable<CreateFolderRequest, Operation> createFolderCallable;
    private final OperationCallable<CreateFolderRequest, Folder, CreateFolderMetadata> createFolderOperationCallable;
    private final UnaryCallable<UpdateFolderRequest, Operation> updateFolderCallable;
    private final OperationCallable<UpdateFolderRequest, Folder, UpdateFolderMetadata> updateFolderOperationCallable;
    private final UnaryCallable<MoveFolderRequest, Operation> moveFolderCallable;
    private final OperationCallable<MoveFolderRequest, Folder, MoveFolderMetadata> moveFolderOperationCallable;
    private final UnaryCallable<DeleteFolderRequest, Operation> deleteFolderCallable;
    private final OperationCallable<DeleteFolderRequest, Folder, DeleteFolderMetadata> deleteFolderOperationCallable;
    private final UnaryCallable<UndeleteFolderRequest, Operation> undeleteFolderCallable;
    private final OperationCallable<UndeleteFolderRequest, Folder, UndeleteFolderMetadata> undeleteFolderOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFoldersStub create(FoldersStubSettings settings) throws IOException {
        return new GrpcFoldersStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcFoldersStub create(ClientContext clientContext) throws IOException {
        return new GrpcFoldersStub(FoldersStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFoldersStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFoldersStub(FoldersStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFoldersStub(FoldersStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFoldersCallableFactory());
    }

    protected GrpcFoldersStub(FoldersStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listFoldersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFoldersMethodDescriptor).build();
        GrpcCallSettings searchFoldersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(searchFoldersMethodDescriptor).build();
        GrpcCallSettings createFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createFolderMethodDescriptor).build();
        GrpcCallSettings updateFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("folder.name", String.valueOf(request.getFolder().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings moveFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(moveFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings undeleteFolderTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeleteFolderMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.getFolderCallable = callableFactory.createUnaryCallable(getFolderTransportSettings, settings.getFolderSettings(), clientContext);
        this.listFoldersCallable = callableFactory.createUnaryCallable(listFoldersTransportSettings, settings.listFoldersSettings(), clientContext);
        this.listFoldersPagedCallable = callableFactory.createPagedCallable(listFoldersTransportSettings, settings.listFoldersSettings(), clientContext);
        this.searchFoldersCallable = callableFactory.createUnaryCallable(searchFoldersTransportSettings, settings.searchFoldersSettings(), clientContext);
        this.searchFoldersPagedCallable = callableFactory.createPagedCallable(searchFoldersTransportSettings, settings.searchFoldersSettings(), clientContext);
        this.createFolderCallable = callableFactory.createUnaryCallable(createFolderTransportSettings, settings.createFolderSettings(), clientContext);
        this.createFolderOperationCallable = callableFactory.createOperationCallable(createFolderTransportSettings, settings.createFolderOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateFolderCallable = callableFactory.createUnaryCallable(updateFolderTransportSettings, settings.updateFolderSettings(), clientContext);
        this.updateFolderOperationCallable = callableFactory.createOperationCallable(updateFolderTransportSettings, settings.updateFolderOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.moveFolderCallable = callableFactory.createUnaryCallable(moveFolderTransportSettings, settings.moveFolderSettings(), clientContext);
        this.moveFolderOperationCallable = callableFactory.createOperationCallable(moveFolderTransportSettings, settings.moveFolderOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteFolderCallable = callableFactory.createUnaryCallable(deleteFolderTransportSettings, settings.deleteFolderSettings(), clientContext);
        this.deleteFolderOperationCallable = callableFactory.createOperationCallable(deleteFolderTransportSettings, settings.deleteFolderOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.undeleteFolderCallable = callableFactory.createUnaryCallable(undeleteFolderTransportSettings, settings.undeleteFolderSettings(), clientContext);
        this.undeleteFolderOperationCallable = callableFactory.createOperationCallable(undeleteFolderTransportSettings, settings.undeleteFolderOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetFolderRequest, Folder> getFolderCallable() {
        return this.getFolderCallable;
    }

    @Override
    public UnaryCallable<ListFoldersRequest, ListFoldersResponse> listFoldersCallable() {
        return this.listFoldersCallable;
    }

    @Override
    public UnaryCallable<ListFoldersRequest, FoldersClient.ListFoldersPagedResponse> listFoldersPagedCallable() {
        return this.listFoldersPagedCallable;
    }

    @Override
    public UnaryCallable<SearchFoldersRequest, SearchFoldersResponse> searchFoldersCallable() {
        return this.searchFoldersCallable;
    }

    @Override
    public UnaryCallable<SearchFoldersRequest, FoldersClient.SearchFoldersPagedResponse> searchFoldersPagedCallable() {
        return this.searchFoldersPagedCallable;
    }

    @Override
    public UnaryCallable<CreateFolderRequest, Operation> createFolderCallable() {
        return this.createFolderCallable;
    }

    @Override
    public OperationCallable<CreateFolderRequest, Folder, CreateFolderMetadata> createFolderOperationCallable() {
        return this.createFolderOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateFolderRequest, Operation> updateFolderCallable() {
        return this.updateFolderCallable;
    }

    @Override
    public OperationCallable<UpdateFolderRequest, Folder, UpdateFolderMetadata> updateFolderOperationCallable() {
        return this.updateFolderOperationCallable;
    }

    @Override
    public UnaryCallable<MoveFolderRequest, Operation> moveFolderCallable() {
        return this.moveFolderCallable;
    }

    @Override
    public OperationCallable<MoveFolderRequest, Folder, MoveFolderMetadata> moveFolderOperationCallable() {
        return this.moveFolderOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFolderRequest, Operation> deleteFolderCallable() {
        return this.deleteFolderCallable;
    }

    @Override
    public OperationCallable<DeleteFolderRequest, Folder, DeleteFolderMetadata> deleteFolderOperationCallable() {
        return this.deleteFolderOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteFolderRequest, Operation> undeleteFolderCallable() {
        return this.undeleteFolderCallable;
    }

    @Override
    public OperationCallable<UndeleteFolderRequest, Folder, UndeleteFolderMetadata> undeleteFolderOperationCallable() {
        return this.undeleteFolderOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

