/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagKeyRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagKeyRequest;
import com.google.cloud.resourcemanager.v3.GetTagKeyRequest;
import com.google.cloud.resourcemanager.v3.ListTagKeysRequest;
import com.google.cloud.resourcemanager.v3.ListTagKeysResponse;
import com.google.cloud.resourcemanager.v3.TagKey;
import com.google.cloud.resourcemanager.v3.TagKeysClient;
import com.google.cloud.resourcemanager.v3.UpdateTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.UpdateTagKeyRequest;
import com.google.cloud.resourcemanager.v3.stub.GrpcTagKeysCallableFactory;
import com.google.cloud.resourcemanager.v3.stub.TagKeysStub;
import com.google.cloud.resourcemanager.v3.stub.TagKeysStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcTagKeysStub
extends TagKeysStub {
    private static final MethodDescriptor<ListTagKeysRequest, ListTagKeysResponse> listTagKeysMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/ListTagKeys").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTagKeysRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTagKeysResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetTagKeyRequest, TagKey> getTagKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/GetTagKey").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTagKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TagKey.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateTagKeyRequest, Operation> createTagKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/CreateTagKey").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateTagKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateTagKeyRequest, Operation> updateTagKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/UpdateTagKey").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateTagKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteTagKeyRequest, Operation> deleteTagKeyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/DeleteTagKey").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteTagKeyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.resourcemanager.v3.TagKeys/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<ListTagKeysRequest, ListTagKeysResponse> listTagKeysCallable;
    private final UnaryCallable<ListTagKeysRequest, TagKeysClient.ListTagKeysPagedResponse> listTagKeysPagedCallable;
    private final UnaryCallable<GetTagKeyRequest, TagKey> getTagKeyCallable;
    private final UnaryCallable<CreateTagKeyRequest, Operation> createTagKeyCallable;
    private final OperationCallable<CreateTagKeyRequest, TagKey, CreateTagKeyMetadata> createTagKeyOperationCallable;
    private final UnaryCallable<UpdateTagKeyRequest, Operation> updateTagKeyCallable;
    private final OperationCallable<UpdateTagKeyRequest, TagKey, UpdateTagKeyMetadata> updateTagKeyOperationCallable;
    private final UnaryCallable<DeleteTagKeyRequest, Operation> deleteTagKeyCallable;
    private final OperationCallable<DeleteTagKeyRequest, TagKey, DeleteTagKeyMetadata> deleteTagKeyOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcTagKeysStub create(TagKeysStubSettings settings) throws IOException {
        return new GrpcTagKeysStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcTagKeysStub create(ClientContext clientContext) throws IOException {
        return new GrpcTagKeysStub(TagKeysStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcTagKeysStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcTagKeysStub(TagKeysStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcTagKeysStub(TagKeysStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcTagKeysCallableFactory());
    }

    protected GrpcTagKeysStub(TagKeysStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listTagKeysTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTagKeysMethodDescriptor).build();
        GrpcCallSettings getTagKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTagKeyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createTagKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createTagKeyMethodDescriptor).build();
        GrpcCallSettings updateTagKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateTagKeyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"tag_key.name", (Object)String.valueOf(request.getTagKey().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteTagKeyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteTagKeyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"resource", (Object)String.valueOf(request.getResource()));
            return params.build();
        }).build();
        this.listTagKeysCallable = callableFactory.createUnaryCallable(listTagKeysTransportSettings, settings.listTagKeysSettings(), clientContext);
        this.listTagKeysPagedCallable = callableFactory.createPagedCallable(listTagKeysTransportSettings, settings.listTagKeysSettings(), clientContext);
        this.getTagKeyCallable = callableFactory.createUnaryCallable(getTagKeyTransportSettings, settings.getTagKeySettings(), clientContext);
        this.createTagKeyCallable = callableFactory.createUnaryCallable(createTagKeyTransportSettings, settings.createTagKeySettings(), clientContext);
        this.createTagKeyOperationCallable = callableFactory.createOperationCallable(createTagKeyTransportSettings, settings.createTagKeyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateTagKeyCallable = callableFactory.createUnaryCallable(updateTagKeyTransportSettings, settings.updateTagKeySettings(), clientContext);
        this.updateTagKeyOperationCallable = callableFactory.createOperationCallable(updateTagKeyTransportSettings, settings.updateTagKeyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteTagKeyCallable = callableFactory.createUnaryCallable(deleteTagKeyTransportSettings, settings.deleteTagKeySettings(), clientContext);
        this.deleteTagKeyOperationCallable = callableFactory.createOperationCallable(deleteTagKeyTransportSettings, settings.deleteTagKeyOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListTagKeysRequest, ListTagKeysResponse> listTagKeysCallable() {
        return this.listTagKeysCallable;
    }

    @Override
    public UnaryCallable<ListTagKeysRequest, TagKeysClient.ListTagKeysPagedResponse> listTagKeysPagedCallable() {
        return this.listTagKeysPagedCallable;
    }

    @Override
    public UnaryCallable<GetTagKeyRequest, TagKey> getTagKeyCallable() {
        return this.getTagKeyCallable;
    }

    @Override
    public UnaryCallable<CreateTagKeyRequest, Operation> createTagKeyCallable() {
        return this.createTagKeyCallable;
    }

    @Override
    public OperationCallable<CreateTagKeyRequest, TagKey, CreateTagKeyMetadata> createTagKeyOperationCallable() {
        return this.createTagKeyOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateTagKeyRequest, Operation> updateTagKeyCallable() {
        return this.updateTagKeyCallable;
    }

    @Override
    public OperationCallable<UpdateTagKeyRequest, TagKey, UpdateTagKeyMetadata> updateTagKeyOperationCallable() {
        return this.updateTagKeyOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteTagKeyRequest, Operation> deleteTagKeyCallable() {
        return this.deleteTagKeyCallable;
    }

    @Override
    public OperationCallable<DeleteTagKeyRequest, TagKey, DeleteTagKeyMetadata> deleteTagKeyOperationCallable() {
        return this.deleteTagKeyOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

