/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.resourcemanager.v3.CreateTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagKeyRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagKeyRequest;
import com.google.cloud.resourcemanager.v3.GetTagKeyRequest;
import com.google.cloud.resourcemanager.v3.ListTagKeysRequest;
import com.google.cloud.resourcemanager.v3.ListTagKeysResponse;
import com.google.cloud.resourcemanager.v3.TagKey;
import com.google.cloud.resourcemanager.v3.TagKeysClient;
import com.google.cloud.resourcemanager.v3.UpdateTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.UpdateTagKeyRequest;
import com.google.cloud.resourcemanager.v3.stub.GrpcTagKeysStub;
import com.google.cloud.resourcemanager.v3.stub.TagKeysStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class TagKeysStubSettings
extends StubSettings<TagKeysStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final PagedCallSettings<ListTagKeysRequest, ListTagKeysResponse, TagKeysClient.ListTagKeysPagedResponse> listTagKeysSettings;
    private final UnaryCallSettings<GetTagKeyRequest, TagKey> getTagKeySettings;
    private final UnaryCallSettings<CreateTagKeyRequest, Operation> createTagKeySettings;
    private final OperationCallSettings<CreateTagKeyRequest, TagKey, CreateTagKeyMetadata> createTagKeyOperationSettings;
    private final UnaryCallSettings<UpdateTagKeyRequest, Operation> updateTagKeySettings;
    private final OperationCallSettings<UpdateTagKeyRequest, TagKey, UpdateTagKeyMetadata> updateTagKeyOperationSettings;
    private final UnaryCallSettings<DeleteTagKeyRequest, Operation> deleteTagKeySettings;
    private final OperationCallSettings<DeleteTagKeyRequest, TagKey, DeleteTagKeyMetadata> deleteTagKeyOperationSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListTagKeysRequest, ListTagKeysResponse, TagKey> LIST_TAG_KEYS_PAGE_STR_DESC = new PagedListDescriptor<ListTagKeysRequest, ListTagKeysResponse, TagKey>(){

        public String emptyToken() {
            return "";
        }

        public ListTagKeysRequest injectToken(ListTagKeysRequest payload, String token) {
            return ListTagKeysRequest.newBuilder((ListTagKeysRequest)payload).setPageToken(token).build();
        }

        public ListTagKeysRequest injectPageSize(ListTagKeysRequest payload, int pageSize) {
            return ListTagKeysRequest.newBuilder((ListTagKeysRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTagKeysRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTagKeysResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TagKey> extractResources(ListTagKeysResponse payload) {
            return payload.getTagKeysList() == null ? ImmutableList.of() : payload.getTagKeysList();
        }
    };
    private static final PagedListResponseFactory<ListTagKeysRequest, ListTagKeysResponse, TagKeysClient.ListTagKeysPagedResponse> LIST_TAG_KEYS_PAGE_STR_FACT = new PagedListResponseFactory<ListTagKeysRequest, ListTagKeysResponse, TagKeysClient.ListTagKeysPagedResponse>(){

        public ApiFuture<TagKeysClient.ListTagKeysPagedResponse> getFuturePagedResponse(UnaryCallable<ListTagKeysRequest, ListTagKeysResponse> callable, ListTagKeysRequest request, ApiCallContext context, ApiFuture<ListTagKeysResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TAG_KEYS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TagKeysClient.ListTagKeysPagedResponse.createAsync((PageContext<ListTagKeysRequest, ListTagKeysResponse, TagKey>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListTagKeysRequest, ListTagKeysResponse, TagKeysClient.ListTagKeysPagedResponse> listTagKeysSettings() {
        return this.listTagKeysSettings;
    }

    public UnaryCallSettings<GetTagKeyRequest, TagKey> getTagKeySettings() {
        return this.getTagKeySettings;
    }

    public UnaryCallSettings<CreateTagKeyRequest, Operation> createTagKeySettings() {
        return this.createTagKeySettings;
    }

    public OperationCallSettings<CreateTagKeyRequest, TagKey, CreateTagKeyMetadata> createTagKeyOperationSettings() {
        return this.createTagKeyOperationSettings;
    }

    public UnaryCallSettings<UpdateTagKeyRequest, Operation> updateTagKeySettings() {
        return this.updateTagKeySettings;
    }

    public OperationCallSettings<UpdateTagKeyRequest, TagKey, UpdateTagKeyMetadata> updateTagKeyOperationSettings() {
        return this.updateTagKeyOperationSettings;
    }

    public UnaryCallSettings<DeleteTagKeyRequest, Operation> deleteTagKeySettings() {
        return this.deleteTagKeySettings;
    }

    public OperationCallSettings<DeleteTagKeyRequest, TagKey, DeleteTagKeyMetadata> deleteTagKeyOperationSettings() {
        return this.deleteTagKeyOperationSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TagKeysStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTagKeysStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudresourcemanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudresourcemanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TagKeysStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TagKeysStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TagKeysStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listTagKeysSettings = settingsBuilder.listTagKeysSettings().build();
        this.getTagKeySettings = settingsBuilder.getTagKeySettings().build();
        this.createTagKeySettings = settingsBuilder.createTagKeySettings().build();
        this.createTagKeyOperationSettings = settingsBuilder.createTagKeyOperationSettings().build();
        this.updateTagKeySettings = settingsBuilder.updateTagKeySettings().build();
        this.updateTagKeyOperationSettings = settingsBuilder.updateTagKeyOperationSettings().build();
        this.deleteTagKeySettings = settingsBuilder.deleteTagKeySettings().build();
        this.deleteTagKeyOperationSettings = settingsBuilder.deleteTagKeyOperationSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TagKeysStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListTagKeysRequest, ListTagKeysResponse, TagKeysClient.ListTagKeysPagedResponse> listTagKeysSettings;
        private final UnaryCallSettings.Builder<GetTagKeyRequest, TagKey> getTagKeySettings;
        private final UnaryCallSettings.Builder<CreateTagKeyRequest, Operation> createTagKeySettings;
        private final OperationCallSettings.Builder<CreateTagKeyRequest, TagKey, CreateTagKeyMetadata> createTagKeyOperationSettings;
        private final UnaryCallSettings.Builder<UpdateTagKeyRequest, Operation> updateTagKeySettings;
        private final OperationCallSettings.Builder<UpdateTagKeyRequest, TagKey, UpdateTagKeyMetadata> updateTagKeyOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTagKeyRequest, Operation> deleteTagKeySettings;
        private final OperationCallSettings.Builder<DeleteTagKeyRequest, TagKey, DeleteTagKeyMetadata> deleteTagKeyOperationSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listTagKeysSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TAG_KEYS_PAGE_STR_FACT);
            this.getTagKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTagKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTagKeyOperationSettings = OperationCallSettings.newBuilder();
            this.updateTagKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTagKeyOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTagKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTagKeyOperationSettings = OperationCallSettings.newBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTagKeysSettings, this.getTagKeySettings, this.createTagKeySettings, this.updateTagKeySettings, this.deleteTagKeySettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TagKeysStubSettings settings) {
            super((StubSettings)settings);
            this.listTagKeysSettings = settings.listTagKeysSettings.toBuilder();
            this.getTagKeySettings = settings.getTagKeySettings.toBuilder();
            this.createTagKeySettings = settings.createTagKeySettings.toBuilder();
            this.createTagKeyOperationSettings = settings.createTagKeyOperationSettings.toBuilder();
            this.updateTagKeySettings = settings.updateTagKeySettings.toBuilder();
            this.updateTagKeyOperationSettings = settings.updateTagKeyOperationSettings.toBuilder();
            this.deleteTagKeySettings = settings.deleteTagKeySettings.toBuilder();
            this.deleteTagKeyOperationSettings = settings.deleteTagKeyOperationSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listTagKeysSettings, this.getTagKeySettings, this.createTagKeySettings, this.updateTagKeySettings, this.deleteTagKeySettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TagKeysStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TagKeysStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TagKeysStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TagKeysStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TagKeysStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listTagKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTagKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createTagKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateTagKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteTagKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTagKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TagKey.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateTagKeyMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateTagKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TagKey.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(UpdateTagKeyMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTagKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TagKey.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteTagKeyMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListTagKeysRequest, ListTagKeysResponse, TagKeysClient.ListTagKeysPagedResponse> listTagKeysSettings() {
            return this.listTagKeysSettings;
        }

        public UnaryCallSettings.Builder<GetTagKeyRequest, TagKey> getTagKeySettings() {
            return this.getTagKeySettings;
        }

        public UnaryCallSettings.Builder<CreateTagKeyRequest, Operation> createTagKeySettings() {
            return this.createTagKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateTagKeyRequest, TagKey, CreateTagKeyMetadata> createTagKeyOperationSettings() {
            return this.createTagKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateTagKeyRequest, Operation> updateTagKeySettings() {
            return this.updateTagKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateTagKeyRequest, TagKey, UpdateTagKeyMetadata> updateTagKeyOperationSettings() {
            return this.updateTagKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTagKeyRequest, Operation> deleteTagKeySettings() {
            return this.deleteTagKeySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTagKeyRequest, TagKey, DeleteTagKeyMetadata> deleteTagKeyOperationSettings() {
            return this.deleteTagKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public TagKeysStubSettings build() throws IOException {
            return new TagKeysStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

