/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.resourcemanager.v3.GetOrganizationRequest;
import com.google.cloud.resourcemanager.v3.Organization;
import com.google.cloud.resourcemanager.v3.OrganizationName;
import com.google.cloud.resourcemanager.v3.OrganizationsSettings;
import com.google.cloud.resourcemanager.v3.SearchOrganizationsRequest;
import com.google.cloud.resourcemanager.v3.SearchOrganizationsResponse;
import com.google.cloud.resourcemanager.v3.stub.OrganizationsStub;
import com.google.cloud.resourcemanager.v3.stub.OrganizationsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class OrganizationsClient
implements BackgroundResource {
    private final OrganizationsSettings settings;
    private final OrganizationsStub stub;

    public static final OrganizationsClient create() throws IOException {
        return OrganizationsClient.create(OrganizationsSettings.newBuilder().build());
    }

    public static final OrganizationsClient create(OrganizationsSettings settings) throws IOException {
        return new OrganizationsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final OrganizationsClient create(OrganizationsStub stub) {
        return new OrganizationsClient(stub);
    }

    protected OrganizationsClient(OrganizationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((OrganizationsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected OrganizationsClient(OrganizationsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final OrganizationsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public OrganizationsStub getStub() {
        return this.stub;
    }

    public final Organization getOrganization(OrganizationName name) {
        GetOrganizationRequest request = GetOrganizationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOrganization(request);
    }

    public final Organization getOrganization(String name) {
        GetOrganizationRequest request = GetOrganizationRequest.newBuilder().setName(name).build();
        return this.getOrganization(request);
    }

    public final Organization getOrganization(GetOrganizationRequest request) {
        return (Organization)this.getOrganizationCallable().call((Object)request);
    }

    public final UnaryCallable<GetOrganizationRequest, Organization> getOrganizationCallable() {
        return this.stub.getOrganizationCallable();
    }

    public final SearchOrganizationsPagedResponse searchOrganizations(String query) {
        SearchOrganizationsRequest request = SearchOrganizationsRequest.newBuilder().setQuery(query).build();
        return this.searchOrganizations(request);
    }

    public final SearchOrganizationsPagedResponse searchOrganizations(SearchOrganizationsRequest request) {
        return (SearchOrganizationsPagedResponse)((Object)this.searchOrganizationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchOrganizationsRequest, SearchOrganizationsPagedResponse> searchOrganizationsPagedCallable() {
        return this.stub.searchOrganizationsPagedCallable();
    }

    public final UnaryCallable<SearchOrganizationsRequest, SearchOrganizationsResponse> searchOrganizationsCallable() {
        return this.stub.searchOrganizationsCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchOrganizationsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchOrganizationsRequest, SearchOrganizationsResponse, Organization, SearchOrganizationsPage, SearchOrganizationsFixedSizeCollection> {
        private SearchOrganizationsFixedSizeCollection(List<SearchOrganizationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchOrganizationsFixedSizeCollection createEmptyCollection() {
            return new SearchOrganizationsFixedSizeCollection(null, 0);
        }

        protected SearchOrganizationsFixedSizeCollection createCollection(List<SearchOrganizationsPage> pages, int collectionSize) {
            return new SearchOrganizationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchOrganizationsPage
    extends AbstractPage<SearchOrganizationsRequest, SearchOrganizationsResponse, Organization, SearchOrganizationsPage> {
        private SearchOrganizationsPage(PageContext<SearchOrganizationsRequest, SearchOrganizationsResponse, Organization> context, SearchOrganizationsResponse response) {
            super(context, (Object)response);
        }

        private static SearchOrganizationsPage createEmptyPage() {
            return new SearchOrganizationsPage(null, null);
        }

        protected SearchOrganizationsPage createPage(PageContext<SearchOrganizationsRequest, SearchOrganizationsResponse, Organization> context, SearchOrganizationsResponse response) {
            return new SearchOrganizationsPage(context, response);
        }

        public ApiFuture<SearchOrganizationsPage> createPageAsync(PageContext<SearchOrganizationsRequest, SearchOrganizationsResponse, Organization> context, ApiFuture<SearchOrganizationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchOrganizationsPagedResponse
    extends AbstractPagedListResponse<SearchOrganizationsRequest, SearchOrganizationsResponse, Organization, SearchOrganizationsPage, SearchOrganizationsFixedSizeCollection> {
        public static ApiFuture<SearchOrganizationsPagedResponse> createAsync(PageContext<SearchOrganizationsRequest, SearchOrganizationsResponse, Organization> context, ApiFuture<SearchOrganizationsResponse> futureResponse) {
            ApiFuture<SearchOrganizationsPage> futurePage = SearchOrganizationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<SearchOrganizationsPage, SearchOrganizationsPagedResponse>(){

                public SearchOrganizationsPagedResponse apply(SearchOrganizationsPage input) {
                    return new SearchOrganizationsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private SearchOrganizationsPagedResponse(SearchOrganizationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchOrganizationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

