/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.redis.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.redis.v1.CloudRedisClient;
import com.google.cloud.redis.v1.CreateInstanceRequest;
import com.google.cloud.redis.v1.DeleteInstanceRequest;
import com.google.cloud.redis.v1.ExportInstanceRequest;
import com.google.cloud.redis.v1.FailoverInstanceRequest;
import com.google.cloud.redis.v1.GetInstanceAuthStringRequest;
import com.google.cloud.redis.v1.GetInstanceRequest;
import com.google.cloud.redis.v1.ImportInstanceRequest;
import com.google.cloud.redis.v1.Instance;
import com.google.cloud.redis.v1.InstanceAuthString;
import com.google.cloud.redis.v1.ListInstancesRequest;
import com.google.cloud.redis.v1.ListInstancesResponse;
import com.google.cloud.redis.v1.OperationMetadata;
import com.google.cloud.redis.v1.RescheduleMaintenanceRequest;
import com.google.cloud.redis.v1.UpdateInstanceRequest;
import com.google.cloud.redis.v1.UpgradeInstanceRequest;
import com.google.cloud.redis.v1.stub.CloudRedisStub;
import com.google.cloud.redis.v1.stub.GrpcCloudRedisStub;
import com.google.cloud.redis.v1.stub.HttpJsonCloudRedisStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CloudRedisStubSettings
extends StubSettings<CloudRedisStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListInstancesRequest, ListInstancesResponse, CloudRedisClient.ListInstancesPagedResponse> listInstancesSettings;
    private final UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings;
    private final UnaryCallSettings<GetInstanceAuthStringRequest, InstanceAuthString> getInstanceAuthStringSettings;
    private final UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings;
    private final OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
    private final UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings;
    private final OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
    private final UnaryCallSettings<UpgradeInstanceRequest, Operation> upgradeInstanceSettings;
    private final OperationCallSettings<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings;
    private final UnaryCallSettings<ImportInstanceRequest, Operation> importInstanceSettings;
    private final OperationCallSettings<ImportInstanceRequest, Instance, OperationMetadata> importInstanceOperationSettings;
    private final UnaryCallSettings<ExportInstanceRequest, Operation> exportInstanceSettings;
    private final OperationCallSettings<ExportInstanceRequest, Instance, OperationMetadata> exportInstanceOperationSettings;
    private final UnaryCallSettings<FailoverInstanceRequest, Operation> failoverInstanceSettings;
    private final OperationCallSettings<FailoverInstanceRequest, Instance, OperationMetadata> failoverInstanceOperationSettings;
    private final UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings;
    private final OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
    private final UnaryCallSettings<RescheduleMaintenanceRequest, Operation> rescheduleMaintenanceSettings;
    private final OperationCallSettings<RescheduleMaintenanceRequest, Instance, OperationMetadata> rescheduleMaintenanceOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CloudRedisClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance> LIST_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListInstancesRequest, ListInstancesResponse, Instance>(){

        public String emptyToken() {
            return "";
        }

        public ListInstancesRequest injectToken(ListInstancesRequest payload, String token) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageToken(token).build();
        }

        public ListInstancesRequest injectPageSize(ListInstancesRequest payload, int pageSize) {
            return ListInstancesRequest.newBuilder((ListInstancesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInstancesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Instance> extractResources(ListInstancesResponse payload) {
            return payload.getInstancesList() == null ? ImmutableList.of() : payload.getInstancesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, CloudRedisClient.ListInstancesPagedResponse> LIST_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListInstancesRequest, ListInstancesResponse, CloudRedisClient.ListInstancesPagedResponse>(){

        public ApiFuture<CloudRedisClient.ListInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstancesRequest, ListInstancesResponse> callable, ListInstancesRequest request, ApiCallContext context, ApiFuture<ListInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudRedisClient.ListInstancesPagedResponse.createAsync((PageContext<ListInstancesRequest, ListInstancesResponse, Instance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CloudRedisClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, CloudRedisClient.ListLocationsPagedResponse>(){

        public ApiFuture<CloudRedisClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudRedisClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListInstancesRequest, ListInstancesResponse, CloudRedisClient.ListInstancesPagedResponse> listInstancesSettings() {
        return this.listInstancesSettings;
    }

    public UnaryCallSettings<GetInstanceRequest, Instance> getInstanceSettings() {
        return this.getInstanceSettings;
    }

    public UnaryCallSettings<GetInstanceAuthStringRequest, InstanceAuthString> getInstanceAuthStringSettings() {
        return this.getInstanceAuthStringSettings;
    }

    public UnaryCallSettings<CreateInstanceRequest, Operation> createInstanceSettings() {
        return this.createInstanceSettings;
    }

    public OperationCallSettings<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
        return this.createInstanceOperationSettings;
    }

    public UnaryCallSettings<UpdateInstanceRequest, Operation> updateInstanceSettings() {
        return this.updateInstanceSettings;
    }

    public OperationCallSettings<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
        return this.updateInstanceOperationSettings;
    }

    public UnaryCallSettings<UpgradeInstanceRequest, Operation> upgradeInstanceSettings() {
        return this.upgradeInstanceSettings;
    }

    public OperationCallSettings<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings() {
        return this.upgradeInstanceOperationSettings;
    }

    public UnaryCallSettings<ImportInstanceRequest, Operation> importInstanceSettings() {
        return this.importInstanceSettings;
    }

    public OperationCallSettings<ImportInstanceRequest, Instance, OperationMetadata> importInstanceOperationSettings() {
        return this.importInstanceOperationSettings;
    }

    public UnaryCallSettings<ExportInstanceRequest, Operation> exportInstanceSettings() {
        return this.exportInstanceSettings;
    }

    public OperationCallSettings<ExportInstanceRequest, Instance, OperationMetadata> exportInstanceOperationSettings() {
        return this.exportInstanceOperationSettings;
    }

    public UnaryCallSettings<FailoverInstanceRequest, Operation> failoverInstanceSettings() {
        return this.failoverInstanceSettings;
    }

    public OperationCallSettings<FailoverInstanceRequest, Instance, OperationMetadata> failoverInstanceOperationSettings() {
        return this.failoverInstanceOperationSettings;
    }

    public UnaryCallSettings<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
        return this.deleteInstanceSettings;
    }

    public OperationCallSettings<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
        return this.deleteInstanceOperationSettings;
    }

    public UnaryCallSettings<RescheduleMaintenanceRequest, Operation> rescheduleMaintenanceSettings() {
        return this.rescheduleMaintenanceSettings;
    }

    public OperationCallSettings<RescheduleMaintenanceRequest, Instance, OperationMetadata> rescheduleMaintenanceOperationSettings() {
        return this.rescheduleMaintenanceOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, CloudRedisClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public CloudRedisStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudRedisStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCloudRedisStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "redis";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "redis.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "redis.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudRedisStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudRedisStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudRedisStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CloudRedisStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudRedisStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listInstancesSettings = settingsBuilder.listInstancesSettings().build();
        this.getInstanceSettings = settingsBuilder.getInstanceSettings().build();
        this.getInstanceAuthStringSettings = settingsBuilder.getInstanceAuthStringSettings().build();
        this.createInstanceSettings = settingsBuilder.createInstanceSettings().build();
        this.createInstanceOperationSettings = settingsBuilder.createInstanceOperationSettings().build();
        this.updateInstanceSettings = settingsBuilder.updateInstanceSettings().build();
        this.updateInstanceOperationSettings = settingsBuilder.updateInstanceOperationSettings().build();
        this.upgradeInstanceSettings = settingsBuilder.upgradeInstanceSettings().build();
        this.upgradeInstanceOperationSettings = settingsBuilder.upgradeInstanceOperationSettings().build();
        this.importInstanceSettings = settingsBuilder.importInstanceSettings().build();
        this.importInstanceOperationSettings = settingsBuilder.importInstanceOperationSettings().build();
        this.exportInstanceSettings = settingsBuilder.exportInstanceSettings().build();
        this.exportInstanceOperationSettings = settingsBuilder.exportInstanceOperationSettings().build();
        this.failoverInstanceSettings = settingsBuilder.failoverInstanceSettings().build();
        this.failoverInstanceOperationSettings = settingsBuilder.failoverInstanceOperationSettings().build();
        this.deleteInstanceSettings = settingsBuilder.deleteInstanceSettings().build();
        this.deleteInstanceOperationSettings = settingsBuilder.deleteInstanceOperationSettings().build();
        this.rescheduleMaintenanceSettings = settingsBuilder.rescheduleMaintenanceSettings().build();
        this.rescheduleMaintenanceOperationSettings = settingsBuilder.rescheduleMaintenanceOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudRedisStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, CloudRedisClient.ListInstancesPagedResponse> listInstancesSettings;
        private final UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings;
        private final UnaryCallSettings.Builder<GetInstanceAuthStringRequest, InstanceAuthString> getInstanceAuthStringSettings;
        private final UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings;
        private final OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings;
        private final UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings;
        private final OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings;
        private final UnaryCallSettings.Builder<UpgradeInstanceRequest, Operation> upgradeInstanceSettings;
        private final OperationCallSettings.Builder<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings;
        private final UnaryCallSettings.Builder<ImportInstanceRequest, Operation> importInstanceSettings;
        private final OperationCallSettings.Builder<ImportInstanceRequest, Instance, OperationMetadata> importInstanceOperationSettings;
        private final UnaryCallSettings.Builder<ExportInstanceRequest, Operation> exportInstanceSettings;
        private final OperationCallSettings.Builder<ExportInstanceRequest, Instance, OperationMetadata> exportInstanceOperationSettings;
        private final UnaryCallSettings.Builder<FailoverInstanceRequest, Operation> failoverInstanceSettings;
        private final OperationCallSettings.Builder<FailoverInstanceRequest, Instance, OperationMetadata> failoverInstanceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings;
        private final OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings;
        private final UnaryCallSettings.Builder<RescheduleMaintenanceRequest, Operation> rescheduleMaintenanceSettings;
        private final OperationCallSettings.Builder<RescheduleMaintenanceRequest, Instance, OperationMetadata> rescheduleMaintenanceOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CloudRedisClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSTANCES_PAGE_STR_FACT);
            this.getInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getInstanceAuthStringSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.updateInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.upgradeInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.upgradeInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.importInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.exportInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.failoverInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.failoverInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInstanceOperationSettings = OperationCallSettings.newBuilder();
            this.rescheduleMaintenanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rescheduleMaintenanceOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.getInstanceAuthStringSettings, this.createInstanceSettings, this.updateInstanceSettings, this.upgradeInstanceSettings, this.importInstanceSettings, this.exportInstanceSettings, this.failoverInstanceSettings, this.deleteInstanceSettings, this.rescheduleMaintenanceSettings, this.listLocationsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(CloudRedisStubSettings settings) {
            super((StubSettings)settings);
            this.listInstancesSettings = settings.listInstancesSettings.toBuilder();
            this.getInstanceSettings = settings.getInstanceSettings.toBuilder();
            this.getInstanceAuthStringSettings = settings.getInstanceAuthStringSettings.toBuilder();
            this.createInstanceSettings = settings.createInstanceSettings.toBuilder();
            this.createInstanceOperationSettings = settings.createInstanceOperationSettings.toBuilder();
            this.updateInstanceSettings = settings.updateInstanceSettings.toBuilder();
            this.updateInstanceOperationSettings = settings.updateInstanceOperationSettings.toBuilder();
            this.upgradeInstanceSettings = settings.upgradeInstanceSettings.toBuilder();
            this.upgradeInstanceOperationSettings = settings.upgradeInstanceOperationSettings.toBuilder();
            this.importInstanceSettings = settings.importInstanceSettings.toBuilder();
            this.importInstanceOperationSettings = settings.importInstanceOperationSettings.toBuilder();
            this.exportInstanceSettings = settings.exportInstanceSettings.toBuilder();
            this.exportInstanceOperationSettings = settings.exportInstanceOperationSettings.toBuilder();
            this.failoverInstanceSettings = settings.failoverInstanceSettings.toBuilder();
            this.failoverInstanceOperationSettings = settings.failoverInstanceOperationSettings.toBuilder();
            this.deleteInstanceSettings = settings.deleteInstanceSettings.toBuilder();
            this.deleteInstanceOperationSettings = settings.deleteInstanceOperationSettings.toBuilder();
            this.rescheduleMaintenanceSettings = settings.rescheduleMaintenanceSettings.toBuilder();
            this.rescheduleMaintenanceOperationSettings = settings.rescheduleMaintenanceOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInstancesSettings, this.getInstanceSettings, this.getInstanceAuthStringSettings, this.createInstanceSettings, this.updateInstanceSettings, this.upgradeInstanceSettings, this.importInstanceSettings, this.exportInstanceSettings, this.failoverInstanceSettings, this.deleteInstanceSettings, this.rescheduleMaintenanceSettings, this.listLocationsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudRedisStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudRedisStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudRedisStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudRedisStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CloudRedisStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CloudRedisStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudRedisStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudRedisStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getInstanceAuthStringSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.upgradeInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.importInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.exportInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.failoverInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.rescheduleMaintenanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)360000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)0x6DDD00L)).build()));
            builder.updateInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)360000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)0x6DDD00L)).build()));
            builder.upgradeInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)360000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)18000000L)).build()));
            builder.exportInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)360000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)18000000L)).build()));
            builder.failoverInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)360000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)1200000L)).build()));
            builder.deleteInstanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)60000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)360000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)1200000L)).build()));
            builder.rescheduleMaintenanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Instance.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListInstancesRequest, ListInstancesResponse, CloudRedisClient.ListInstancesPagedResponse> listInstancesSettings() {
            return this.listInstancesSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceRequest, Instance> getInstanceSettings() {
            return this.getInstanceSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceAuthStringRequest, InstanceAuthString> getInstanceAuthStringSettings() {
            return this.getInstanceAuthStringSettings;
        }

        public UnaryCallSettings.Builder<CreateInstanceRequest, Operation> createInstanceSettings() {
            return this.createInstanceSettings;
        }

        public OperationCallSettings.Builder<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationSettings() {
            return this.createInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateInstanceRequest, Operation> updateInstanceSettings() {
            return this.updateInstanceSettings;
        }

        public OperationCallSettings.Builder<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationSettings() {
            return this.updateInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<UpgradeInstanceRequest, Operation> upgradeInstanceSettings() {
            return this.upgradeInstanceSettings;
        }

        public OperationCallSettings.Builder<UpgradeInstanceRequest, Instance, OperationMetadata> upgradeInstanceOperationSettings() {
            return this.upgradeInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportInstanceRequest, Operation> importInstanceSettings() {
            return this.importInstanceSettings;
        }

        public OperationCallSettings.Builder<ImportInstanceRequest, Instance, OperationMetadata> importInstanceOperationSettings() {
            return this.importInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportInstanceRequest, Operation> exportInstanceSettings() {
            return this.exportInstanceSettings;
        }

        public OperationCallSettings.Builder<ExportInstanceRequest, Instance, OperationMetadata> exportInstanceOperationSettings() {
            return this.exportInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<FailoverInstanceRequest, Operation> failoverInstanceSettings() {
            return this.failoverInstanceSettings;
        }

        public OperationCallSettings.Builder<FailoverInstanceRequest, Instance, OperationMetadata> failoverInstanceOperationSettings() {
            return this.failoverInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceRequest, Operation> deleteInstanceSettings() {
            return this.deleteInstanceSettings;
        }

        public OperationCallSettings.Builder<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationSettings() {
            return this.deleteInstanceOperationSettings;
        }

        public UnaryCallSettings.Builder<RescheduleMaintenanceRequest, Operation> rescheduleMaintenanceSettings() {
            return this.rescheduleMaintenanceSettings;
        }

        public OperationCallSettings.Builder<RescheduleMaintenanceRequest, Instance, OperationMetadata> rescheduleMaintenanceOperationSettings() {
            return this.rescheduleMaintenanceOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, CloudRedisClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public CloudRedisStubSettings build() throws IOException {
            return new CloudRedisStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

