/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.redis.cluster.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.redis.cluster.v1.CloudRedisClusterSettings;
import com.google.cloud.redis.cluster.v1.Cluster;
import com.google.cloud.redis.cluster.v1.ClusterName;
import com.google.cloud.redis.cluster.v1.CreateClusterRequest;
import com.google.cloud.redis.cluster.v1.DeleteClusterRequest;
import com.google.cloud.redis.cluster.v1.GetClusterRequest;
import com.google.cloud.redis.cluster.v1.ListClustersRequest;
import com.google.cloud.redis.cluster.v1.ListClustersResponse;
import com.google.cloud.redis.cluster.v1.LocationName;
import com.google.cloud.redis.cluster.v1.UpdateClusterRequest;
import com.google.cloud.redis.cluster.v1.stub.CloudRedisClusterStub;
import com.google.cloud.redis.cluster.v1.stub.CloudRedisClusterStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CloudRedisClusterClient
implements BackgroundResource {
    private final CloudRedisClusterSettings settings;
    private final CloudRedisClusterStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final CloudRedisClusterClient create() throws IOException {
        return CloudRedisClusterClient.create(CloudRedisClusterSettings.newBuilder().build());
    }

    public static final CloudRedisClusterClient create(CloudRedisClusterSettings settings) throws IOException {
        return new CloudRedisClusterClient(settings);
    }

    public static final CloudRedisClusterClient create(CloudRedisClusterStub stub) {
        return new CloudRedisClusterClient(stub);
    }

    protected CloudRedisClusterClient(CloudRedisClusterSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudRedisClusterStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected CloudRedisClusterClient(CloudRedisClusterStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final CloudRedisClusterSettings getSettings() {
        return this.settings;
    }

    public CloudRedisClusterStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListClustersPagedResponse listClusters(LocationName parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(String parent) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setParent(parent).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(ListClustersRequest request) {
        return (ListClustersPagedResponse)((Object)this.listClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListClustersRequest, ListClustersPagedResponse> listClustersPagedCallable() {
        return this.stub.listClustersPagedCallable();
    }

    public final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.stub.listClustersCallable();
    }

    public final Cluster getCluster(ClusterName name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(String name) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setName(name).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(GetClusterRequest request) {
        return (Cluster)this.getClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.stub.getClusterCallable();
    }

    public final OperationFuture<Cluster, Any> updateClusterAsync(Cluster cluster, FieldMask updateMask) {
        UpdateClusterRequest request = UpdateClusterRequest.newBuilder().setCluster(cluster).setUpdateMask(updateMask).build();
        return this.updateClusterAsync(request);
    }

    public final OperationFuture<Cluster, Any> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateClusterRequest, Cluster, Any> updateClusterOperationCallable() {
        return this.stub.updateClusterOperationCallable();
    }

    public final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.stub.updateClusterCallable();
    }

    public final OperationFuture<Empty, Any> deleteClusterAsync(ClusterName name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, Any> deleteClusterAsync(String name) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setName(name).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, Any> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteClusterRequest, Empty, Any> deleteClusterOperationCallable() {
        return this.stub.deleteClusterOperationCallable();
    }

    public final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.stub.deleteClusterCallable();
    }

    public final OperationFuture<Cluster, Any> createClusterAsync(LocationName parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, Any> createClusterAsync(String parent, Cluster cluster, String clusterId) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setParent(parent).setCluster(cluster).setClusterId(clusterId).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, Any> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateClusterRequest, Cluster, Any> createClusterOperationCallable() {
        return this.stub.createClusterOperationCallable();
    }

    public final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.stub.createClusterCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        private ListClustersFixedSizeCollection(List<ListClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListClustersFixedSizeCollection createEmptyCollection() {
            return new ListClustersFixedSizeCollection(null, 0);
        }

        protected ListClustersFixedSizeCollection createCollection(List<ListClustersPage> pages, int collectionSize) {
            return new ListClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListClustersPage
    extends AbstractPage<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage> {
        private ListClustersPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListClustersPage createEmptyPage() {
            return new ListClustersPage(null, null);
        }

        protected ListClustersPage createPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            return new ListClustersPage(context, response);
        }

        public ApiFuture<ListClustersPage> createPageAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListClustersPagedResponse
    extends AbstractPagedListResponse<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        public static ApiFuture<ListClustersPagedResponse> createAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            ApiFuture<ListClustersPage> futurePage = ListClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListClustersPagedResponse((ListClustersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListClustersPagedResponse(ListClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

