/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.redis.cluster.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.redis.cluster.v1.CloudRedisClusterClient;
import com.google.cloud.redis.cluster.v1.Cluster;
import com.google.cloud.redis.cluster.v1.CreateClusterRequest;
import com.google.cloud.redis.cluster.v1.DeleteClusterRequest;
import com.google.cloud.redis.cluster.v1.GetClusterRequest;
import com.google.cloud.redis.cluster.v1.ListClustersRequest;
import com.google.cloud.redis.cluster.v1.ListClustersResponse;
import com.google.cloud.redis.cluster.v1.UpdateClusterRequest;
import com.google.cloud.redis.cluster.v1.stub.CloudRedisClusterStub;
import com.google.cloud.redis.cluster.v1.stub.CloudRedisClusterStubSettings;
import com.google.cloud.redis.cluster.v1.stub.GrpcCloudRedisClusterCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcCloudRedisClusterStub
extends CloudRedisClusterStub {
    private static final MethodDescriptor<ListClustersRequest, ListClustersResponse> listClustersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/ListClusters").setRequestMarshaller(ProtoUtils.marshaller((Message)ListClustersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListClustersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetClusterRequest, Cluster> getClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/GetCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)GetClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Cluster.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateClusterRequest, Operation> updateClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/UpdateCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteClusterRequest, Operation> deleteClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/DeleteCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateClusterRequest, Operation> createClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.redis.cluster.v1.CloudRedisCluster/CreateCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable;
    private final UnaryCallable<ListClustersRequest, CloudRedisClusterClient.ListClustersPagedResponse> listClustersPagedCallable;
    private final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable;
    private final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable;
    private final OperationCallable<UpdateClusterRequest, Cluster, Any> updateClusterOperationCallable;
    private final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable;
    private final OperationCallable<DeleteClusterRequest, Empty, Any> deleteClusterOperationCallable;
    private final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable;
    private final OperationCallable<CreateClusterRequest, Cluster, Any> createClusterOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, CloudRedisClusterClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCloudRedisClusterStub create(CloudRedisClusterStubSettings settings) throws IOException {
        return new GrpcCloudRedisClusterStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCloudRedisClusterStub create(ClientContext clientContext) throws IOException {
        return new GrpcCloudRedisClusterStub(CloudRedisClusterStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCloudRedisClusterStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCloudRedisClusterStub(CloudRedisClusterStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCloudRedisClusterStub(CloudRedisClusterStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCloudRedisClusterCallableFactory());
    }

    protected GrpcCloudRedisClusterStub(CloudRedisClusterStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listClustersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listClustersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getClusterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateClusterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("cluster.name", String.valueOf(request.getCluster().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteClusterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createClusterMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listClustersCallable = callableFactory.createUnaryCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.listClustersPagedCallable = callableFactory.createPagedCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.getClusterCallable = callableFactory.createUnaryCallable(getClusterTransportSettings, settings.getClusterSettings(), clientContext);
        this.updateClusterCallable = callableFactory.createUnaryCallable(updateClusterTransportSettings, settings.updateClusterSettings(), clientContext);
        this.updateClusterOperationCallable = callableFactory.createOperationCallable(updateClusterTransportSettings, settings.updateClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteClusterCallable = callableFactory.createUnaryCallable(deleteClusterTransportSettings, settings.deleteClusterSettings(), clientContext);
        this.deleteClusterOperationCallable = callableFactory.createOperationCallable(deleteClusterTransportSettings, settings.deleteClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createClusterCallable = callableFactory.createUnaryCallable(createClusterTransportSettings, settings.createClusterSettings(), clientContext);
        this.createClusterOperationCallable = callableFactory.createOperationCallable(createClusterTransportSettings, settings.createClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.listClustersCallable;
    }

    @Override
    public UnaryCallable<ListClustersRequest, CloudRedisClusterClient.ListClustersPagedResponse> listClustersPagedCallable() {
        return this.listClustersPagedCallable;
    }

    @Override
    public UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.getClusterCallable;
    }

    @Override
    public UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.updateClusterCallable;
    }

    @Override
    public OperationCallable<UpdateClusterRequest, Cluster, Any> updateClusterOperationCallable() {
        return this.updateClusterOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.deleteClusterCallable;
    }

    @Override
    public OperationCallable<DeleteClusterRequest, Empty, Any> deleteClusterOperationCallable() {
        return this.deleteClusterOperationCallable;
    }

    @Override
    public UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.createClusterCallable;
    }

    @Override
    public OperationCallable<CreateClusterRequest, Cluster, Any> createClusterOperationCallable() {
        return this.createClusterOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, CloudRedisClusterClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

