/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.recommendationengine.v1beta1.stub;

import com.google.api.HttpBody;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.recommendationengine.v1beta1.CollectUserEventRequest;
import com.google.cloud.recommendationengine.v1beta1.ImportMetadata;
import com.google.cloud.recommendationengine.v1beta1.ImportUserEventsRequest;
import com.google.cloud.recommendationengine.v1beta1.ImportUserEventsResponse;
import com.google.cloud.recommendationengine.v1beta1.ListUserEventsRequest;
import com.google.cloud.recommendationengine.v1beta1.ListUserEventsResponse;
import com.google.cloud.recommendationengine.v1beta1.PurgeUserEventsMetadata;
import com.google.cloud.recommendationengine.v1beta1.PurgeUserEventsRequest;
import com.google.cloud.recommendationengine.v1beta1.PurgeUserEventsResponse;
import com.google.cloud.recommendationengine.v1beta1.UserEvent;
import com.google.cloud.recommendationengine.v1beta1.UserEventServiceClient;
import com.google.cloud.recommendationengine.v1beta1.WriteUserEventRequest;
import com.google.cloud.recommendationengine.v1beta1.stub.GrpcUserEventServiceStub;
import com.google.cloud.recommendationengine.v1beta1.stub.HttpJsonUserEventServiceStub;
import com.google.cloud.recommendationengine.v1beta1.stub.UserEventServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class UserEventServiceStubSettings
extends StubSettings<UserEventServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<WriteUserEventRequest, UserEvent> writeUserEventSettings;
    private final UnaryCallSettings<CollectUserEventRequest, HttpBody> collectUserEventSettings;
    private final PagedCallSettings<ListUserEventsRequest, ListUserEventsResponse, UserEventServiceClient.ListUserEventsPagedResponse> listUserEventsSettings;
    private final UnaryCallSettings<PurgeUserEventsRequest, Operation> purgeUserEventsSettings;
    private final OperationCallSettings<PurgeUserEventsRequest, PurgeUserEventsResponse, PurgeUserEventsMetadata> purgeUserEventsOperationSettings;
    private final UnaryCallSettings<ImportUserEventsRequest, Operation> importUserEventsSettings;
    private final OperationCallSettings<ImportUserEventsRequest, ImportUserEventsResponse, ImportMetadata> importUserEventsOperationSettings;
    private static final PagedListDescriptor<ListUserEventsRequest, ListUserEventsResponse, UserEvent> LIST_USER_EVENTS_PAGE_STR_DESC = new PagedListDescriptor<ListUserEventsRequest, ListUserEventsResponse, UserEvent>(){

        public String emptyToken() {
            return "";
        }

        public ListUserEventsRequest injectToken(ListUserEventsRequest payload, String token) {
            return ListUserEventsRequest.newBuilder((ListUserEventsRequest)payload).setPageToken(token).build();
        }

        public ListUserEventsRequest injectPageSize(ListUserEventsRequest payload, int pageSize) {
            return ListUserEventsRequest.newBuilder((ListUserEventsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListUserEventsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListUserEventsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UserEvent> extractResources(ListUserEventsResponse payload) {
            return payload.getUserEventsList() == null ? ImmutableList.of() : payload.getUserEventsList();
        }
    };
    private static final PagedListResponseFactory<ListUserEventsRequest, ListUserEventsResponse, UserEventServiceClient.ListUserEventsPagedResponse> LIST_USER_EVENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListUserEventsRequest, ListUserEventsResponse, UserEventServiceClient.ListUserEventsPagedResponse>(){

        public ApiFuture<UserEventServiceClient.ListUserEventsPagedResponse> getFuturePagedResponse(UnaryCallable<ListUserEventsRequest, ListUserEventsResponse> callable, ListUserEventsRequest request, ApiCallContext context, ApiFuture<ListUserEventsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USER_EVENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return UserEventServiceClient.ListUserEventsPagedResponse.createAsync((PageContext<ListUserEventsRequest, ListUserEventsResponse, UserEvent>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<WriteUserEventRequest, UserEvent> writeUserEventSettings() {
        return this.writeUserEventSettings;
    }

    public UnaryCallSettings<CollectUserEventRequest, HttpBody> collectUserEventSettings() {
        return this.collectUserEventSettings;
    }

    public PagedCallSettings<ListUserEventsRequest, ListUserEventsResponse, UserEventServiceClient.ListUserEventsPagedResponse> listUserEventsSettings() {
        return this.listUserEventsSettings;
    }

    public UnaryCallSettings<PurgeUserEventsRequest, Operation> purgeUserEventsSettings() {
        return this.purgeUserEventsSettings;
    }

    public OperationCallSettings<PurgeUserEventsRequest, PurgeUserEventsResponse, PurgeUserEventsMetadata> purgeUserEventsOperationSettings() {
        return this.purgeUserEventsOperationSettings;
    }

    public UnaryCallSettings<ImportUserEventsRequest, Operation> importUserEventsSettings() {
        return this.importUserEventsSettings;
    }

    public OperationCallSettings<ImportUserEventsRequest, ImportUserEventsResponse, ImportMetadata> importUserEventsOperationSettings() {
        return this.importUserEventsOperationSettings;
    }

    public UserEventServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcUserEventServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonUserEventServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "recommendationengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "recommendationengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return UserEventServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(UserEventServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(UserEventServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return UserEventServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected UserEventServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.writeUserEventSettings = settingsBuilder.writeUserEventSettings().build();
        this.collectUserEventSettings = settingsBuilder.collectUserEventSettings().build();
        this.listUserEventsSettings = settingsBuilder.listUserEventsSettings().build();
        this.purgeUserEventsSettings = settingsBuilder.purgeUserEventsSettings().build();
        this.purgeUserEventsOperationSettings = settingsBuilder.purgeUserEventsOperationSettings().build();
        this.importUserEventsSettings = settingsBuilder.importUserEventsSettings().build();
        this.importUserEventsOperationSettings = settingsBuilder.importUserEventsOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<UserEventServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<WriteUserEventRequest, UserEvent> writeUserEventSettings;
        private final UnaryCallSettings.Builder<CollectUserEventRequest, HttpBody> collectUserEventSettings;
        private final PagedCallSettings.Builder<ListUserEventsRequest, ListUserEventsResponse, UserEventServiceClient.ListUserEventsPagedResponse> listUserEventsSettings;
        private final UnaryCallSettings.Builder<PurgeUserEventsRequest, Operation> purgeUserEventsSettings;
        private final OperationCallSettings.Builder<PurgeUserEventsRequest, PurgeUserEventsResponse, PurgeUserEventsMetadata> purgeUserEventsOperationSettings;
        private final UnaryCallSettings.Builder<ImportUserEventsRequest, Operation> importUserEventsSettings;
        private final OperationCallSettings.Builder<ImportUserEventsRequest, ImportUserEventsResponse, ImportMetadata> importUserEventsOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.writeUserEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.collectUserEventSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listUserEventsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USER_EVENTS_PAGE_STR_FACT);
            this.purgeUserEventsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.purgeUserEventsOperationSettings = OperationCallSettings.newBuilder();
            this.importUserEventsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importUserEventsOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.writeUserEventSettings, this.collectUserEventSettings, this.listUserEventsSettings, this.purgeUserEventsSettings, this.importUserEventsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(UserEventServiceStubSettings settings) {
            super((StubSettings)settings);
            this.writeUserEventSettings = settings.writeUserEventSettings.toBuilder();
            this.collectUserEventSettings = settings.collectUserEventSettings.toBuilder();
            this.listUserEventsSettings = settings.listUserEventsSettings.toBuilder();
            this.purgeUserEventsSettings = settings.purgeUserEventsSettings.toBuilder();
            this.purgeUserEventsOperationSettings = settings.purgeUserEventsOperationSettings.toBuilder();
            this.importUserEventsSettings = settings.importUserEventsSettings.toBuilder();
            this.importUserEventsOperationSettings = settings.importUserEventsOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.writeUserEventSettings, this.collectUserEventSettings, this.listUserEventsSettings, this.purgeUserEventsSettings, this.importUserEventsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(UserEventServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)UserEventServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)UserEventServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(UserEventServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(UserEventServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)UserEventServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)UserEventServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)UserEventServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(UserEventServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(UserEventServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.writeUserEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.collectUserEventSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listUserEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.purgeUserEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importUserEventsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.purgeUserEventsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PurgeUserEventsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(PurgeUserEventsMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.importUserEventsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportUserEventsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<WriteUserEventRequest, UserEvent> writeUserEventSettings() {
            return this.writeUserEventSettings;
        }

        public UnaryCallSettings.Builder<CollectUserEventRequest, HttpBody> collectUserEventSettings() {
            return this.collectUserEventSettings;
        }

        public PagedCallSettings.Builder<ListUserEventsRequest, ListUserEventsResponse, UserEventServiceClient.ListUserEventsPagedResponse> listUserEventsSettings() {
            return this.listUserEventsSettings;
        }

        public UnaryCallSettings.Builder<PurgeUserEventsRequest, Operation> purgeUserEventsSettings() {
            return this.purgeUserEventsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<PurgeUserEventsRequest, PurgeUserEventsResponse, PurgeUserEventsMetadata> purgeUserEventsOperationSettings() {
            return this.purgeUserEventsOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportUserEventsRequest, Operation> importUserEventsSettings() {
            return this.importUserEventsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ImportUserEventsRequest, ImportUserEventsResponse, ImportMetadata> importUserEventsOperationSettings() {
            return this.importUserEventsOperationSettings;
        }

        public UserEventServiceStubSettings build() throws IOException {
            return new UserEventServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

